/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.net.Authenticator;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.EclipseAuthenticator;
import org.eclipse.egit.ui.EclipseProxySelector;
import org.eclipse.egit.ui.EclipseSshSessionFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.lib.IndexChangedEvent;
import org.eclipse.jgit.lib.RefsChangedEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryListener;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.themes.ITheme;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private static List<IPropertyChangeListener> propertyChangeListeners;
    public static final String DECORATORS_CHANGED = "org.eclipse.egit.ui.DECORATORS_CHANGED";
    private boolean traceVerbose;
    private RCS rcs;
    private RIRefresh refreshJob;

    static {
        propertyChangeListeners = new ArrayList<IPropertyChangeListener>(5);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static CoreException error(String message, Throwable thr) {
        return new CoreException((IStatus)new Status(4, Activator.getPluginId(), 0, message, thr));
    }

    public static void logError(String message, Throwable thr) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getPluginId(), 0, message, thr));
    }

    private static boolean isOptionSet(String optionId) {
        String option = String.valueOf(Activator.getPluginId()) + optionId;
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equals("true");
    }

    public static void trace(String what) {
        if (Activator.getDefault().traceVerbose) {
            System.out.println("[" + Activator.getPluginId() + "] " + what);
        }
    }

    public static ITheme getTheme() {
        return plugin.getWorkbench().getThemeManager().getCurrentTheme();
    }

    public static Font getFont(String id) {
        return Activator.getTheme().getFontRegistry().get(id);
    }

    public static Font getBoldFont(String id) {
        return Activator.getTheme().getFontRegistry().getBold(id);
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.traceVerbose = Activator.isOptionSet("/trace/verbose");
        this.setupSSH(context);
        this.setupProxy(context);
        this.setupRepoChangeScanner();
        this.setupRepoIndexRefresh();
    }

    private void setupRepoIndexRefresh() {
        this.refreshJob = new RIRefresh();
        Repository.addAnyRepositoryChangedListener((RepositoryListener)this.refreshJob);
    }

    public static synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static synchronized void broadcastPropertyChange(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private void setupRepoChangeScanner() {
        this.rcs = new RCS();
        this.rcs.schedule(10000L);
    }

    private void setupSSH(BundleContext context) {
        ServiceReference ssh = context.getServiceReference(IJSchService.class.getName());
        if (ssh != null) {
            SshSessionFactory.setInstance((SshSessionFactory)new EclipseSshSessionFactory((IJSchService)context.getService(ssh)));
        }
    }

    private void setupProxy(BundleContext context) {
        ServiceReference proxy = context.getServiceReference(IProxyService.class.getName());
        if (proxy != null) {
            ProxySelector.setDefault(new EclipseProxySelector((IProxyService)context.getService(proxy)));
            Authenticator.setDefault(new EclipseAuthenticator((IProxyService)context.getService(proxy)));
        }
    }

    public void stop(BundleContext context) throws Exception {
        Activator.trace("Trying to cancel " + this.rcs.getName() + " job");
        this.rcs.cancel();
        Activator.trace("Trying to cancel " + this.refreshJob.getName() + " job");
        this.refreshJob.cancel();
        this.rcs.join();
        this.refreshJob.join();
        Activator.trace("Jobs terminated");
        super.stop(context);
        plugin = null;
    }

    static class RCS
    extends Job {
        private static final long REPO_SCAN_INTERVAL = 10000L;

        RCS() {
            super("Repository Change Scanner");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                monitor.beginTask("Scanning Git repositories for changes", projects.length);
                HashSet<Repository> scanned = new HashSet<Repository>();
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    Repository r;
                    IProject p = iProjectArray[n2];
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)p);
                    if (mapping != null && !scanned.contains(r = mapping.getRepository())) {
                        if (monitor.isCanceled()) break;
                        Activator.trace("Scanning " + r + " for changes");
                        scanned.add(r);
                        ISchedulingRule rule = p.getWorkspace().getRuleFactory().modifyRule((IResource)p);
                        RCS.getJobManager().beginRule(rule, monitor);
                        try {
                            r.scanForRepoChanges();
                        }
                        finally {
                            RCS.getJobManager().endRule(rule);
                        }
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
                Activator.trace("Rescheduling " + this.getName() + " job");
                this.schedule(10000L);
            }
            catch (Exception e) {
                Activator.trace("Stopped rescheduling " + this.getName() + "job");
                return new Status(4, Activator.getPluginId(), 0, "An error occurred while scanning for changes. Scanning aborted", (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    static class RIRefresh
    extends Job
    implements RepositoryListener {
        private Set<IProject> projectsToScan = new LinkedHashSet<IProject>();

        RIRefresh() {
            super("Git index refresh Job");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            monitor.beginTask("Refreshing git managed projects", projects.length);
            while (this.projectsToScan.size() > 0) {
                IProject p;
                Set<IProject> set = this.projectsToScan;
                synchronized (set) {
                    if (this.projectsToScan.size() == 0) {
                        break;
                    }
                    Iterator<IProject> i = this.projectsToScan.iterator();
                    p = i.next();
                    i.remove();
                }
                ISchedulingRule rule = p.getWorkspace().getRuleFactory().refreshRule((IResource)p);
                try {
                    try {
                        RIRefresh.getJobManager().beginRule(rule, monitor);
                        p.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        Activator.logError("Failed to refresh projects from index changes", e);
                        Status status = new Status(4, Activator.getPluginId(), e.getMessage());
                        RIRefresh.getJobManager().endRule(rule);
                        return status;
                    }
                }
                finally {
                    RIRefresh.getJobManager().endRule(rule);
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void indexChanged(IndexChangedEvent e) {
            if (!ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("refresh.enabled")) {
                return;
            }
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            HashSet<IProject> toRefresh = new HashSet<IProject>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)p);
                if (mapping != null && mapping.getRepository() == e.getRepository()) {
                    toRefresh.add(p);
                }
                ++n2;
            }
            Set<IProject> set = this.projectsToScan;
            synchronized (set) {
                this.projectsToScan.addAll(toRefresh);
            }
            if (this.projectsToScan.size() > 0) {
                this.schedule();
            }
        }

        public void refsChanged(RefsChangedEvent e) {
        }
    }
}

