/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EclipseProxySelector
extends ProxySelector {
    private final IProxyService service;

    EclipseProxySelector(IProxyService s) {
        this.service = s;
    }

    @Override
    public List<Proxy> select(URI uri) {
        ArrayList<Proxy> r = new ArrayList<Proxy>();
        String host = uri.getHost();
        String type = "SOCKS";
        if ("http".equals(uri.getScheme())) {
            type = "HTTP";
        } else if ("ftp".equals(uri.getScheme())) {
            type = "HTTP";
        } else if ("https".equals(uri.getScheme())) {
            type = "HTTPS";
        }
        IProxyData data = this.service.getProxyDataForHost(host, type);
        if (data != null) {
            if ("HTTP".equals(data.getType())) {
                this.addProxy(r, Proxy.Type.HTTP, data);
            } else if ("HTTPS".equals(data.getType())) {
                this.addProxy(r, Proxy.Type.HTTP, data);
            } else if ("SOCKS".equals(data.getType())) {
                this.addProxy(r, Proxy.Type.SOCKS, data);
            }
        }
        if (r.isEmpty()) {
            r.add(Proxy.NO_PROXY);
        }
        return r;
    }

    private void addProxy(ArrayList<Proxy> r, Proxy.Type type, IProxyData d) {
        try {
            r.add(new Proxy(type, new InetSocketAddress(InetAddress.getByName(d.getHost()), d.getPort())));
        }
        catch (UnknownHostException unknownHostException) {}
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

