/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.ContentChangeNotifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;

public class EditableRevision
extends FileRevisionTypedElement
implements ITypedElement,
IEditableContent,
IContentChangeNotifier {
    private byte[] modifiedContent;
    private ContentChangeNotifier fChangeNotifier;
    private EditableSharedDocumentAdapter sharedDocumentAdapter;

    public EditableRevision(IFileRevision fileRevision) {
        super(fileRevision);
    }

    public boolean isEditable() {
        return true;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return null;
    }

    public InputStream getContents() throws CoreException {
        if (this.modifiedContent != null) {
            return new ByteArrayInputStream(this.modifiedContent);
        }
        return super.getContents();
    }

    public void setContent(byte[] newContent) {
        this.modifiedContent = newContent;
        this.fireContentChanged();
    }

    public byte[] getModifiedContent() {
        return this.modifiedContent;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISharedDocumentAdapter.class) {
            return this.getSharedDocumentAdapter();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    private synchronized ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                }

                public void handleDocumentFlushed() {
                }

                public void handleDocumentDeleted() {
                }

                public void handleDocumentSaved() {
                }

                public void handleDocumentDisconnected() {
                }
            });
        }
        return this.sharedDocumentAdapter;
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        if (this.fChangeNotifier == null) {
            this.fChangeNotifier = new ContentChangeNotifier((IContentChangeNotifier)this);
        }
        this.fChangeNotifier.addContentChangeListener(listener);
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this.fChangeNotifier != null) {
            this.fChangeNotifier.removeContentChangeListener(listener);
            if (this.fChangeNotifier.isEmpty()) {
                this.fChangeNotifier = null;
            }
        }
    }

    protected void fireContentChanged() {
        if (this.fChangeNotifier == null || this.fChangeNotifier.isEmpty()) {
            return;
        }
        this.fChangeNotifier.fireContentChanged();
    }
}

