/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileTreeEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.swt.graphics.Image;

public class GitResourceNode
extends BufferedContent
implements IStructureComparator,
ITypedElement {
    TreeEntry entry;
    GitResourceNode[] children;
    String contentIdentifier;

    public GitResourceNode(TreeEntry e) {
        this.entry = e;
    }

    public Object[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        if (this.entry instanceof Tree) {
            try {
                Tree t = (Tree)this.entry;
                this.children = new GitResourceNode[t.memberCount()];
                int i = 0;
                while (i < this.children.length) {
                    this.children[i] = new GitResourceNode(t.members()[i]);
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.children = new GitResourceNode[0];
            }
        }
        return this.children;
    }

    public boolean equals(Object obj) {
        return this.entry.getId().equals((AnyObjectId)((GitResourceNode)((Object)obj)).entry.getId());
    }

    protected InputStream createStream() throws CoreException {
        if (this.entry instanceof FileTreeEntry) {
            try {
                ObjectId id = this.entry.getId();
                ObjectLoader reader = this.entry.getRepository().openBlob(id);
                byte[] bytes = reader.getBytes();
                return new ByteArrayInputStream(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public String getName() {
        if (this.entry != null) {
            return this.entry.getFullName();
        }
        return "<none>";
    }

    public Image getImage() {
        return CompareUI.getImage((String)this.getType());
    }

    public String getType() {
        if (this.entry instanceof Tree) {
            return "FOLDER";
        }
        if (this.entry != null) {
            String name = this.entry.getName();
            if (name != null) {
                int index = name.lastIndexOf(46);
                if (index == -1) {
                    return "";
                }
                if (index == name.length() - 1) {
                    return "";
                }
                return name.substring(index + 1);
            }
            return "";
        }
        return "";
    }

    public String getContentIdentifier() {
        return this.contentIdentifier;
    }
}

