/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractOperationAction
implements IObjectActionDelegate {
    protected IWorkbenchPart wp;
    private IWorkspaceRunnable op;

    public void selectionChanged(IAction act, ISelection sel) {
    }

    public void setActivePart(IAction act, IWorkbenchPart part) {
        this.wp = part;
        ISelection sel = part.getSite().getPage().getSelection();
        List selection = sel instanceof IStructuredSelection && !sel.isEmpty() ? ((IStructuredSelection)sel).toList() : Collections.EMPTY_LIST;
        this.op = this.createOperation(act, selection);
        act.setEnabled(this.op != null && this.wp != null);
    }

    protected abstract IWorkspaceRunnable createOperation(IAction var1, List var2);

    protected void postOperation() {
    }

    public void run(IAction act) {
        if (this.op != null) {
            try {
                try {
                    this.wp.getSite().getWorkbenchWindow().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                AbstractOperationAction.this.op.run(monitor);
                            }
                            catch (CoreException ce) {
                                throw new InvocationTargetException(ce);
                            }
                        }
                    });
                }
                finally {
                    this.postOperation();
                }
            }
            catch (Throwable e) {
                IStatus status;
                String msg = NLS.bind((String)UIText.GenericOperationFailed, (Object)act.getText());
                if (e instanceof InvocationTargetException) {
                    e = e.getCause();
                }
                if (e instanceof CoreException) {
                    status = ((CoreException)e).getStatus();
                    e = status.getException();
                } else {
                    status = new Status(4, Activator.getPluginId(), 1, msg, e);
                }
                Activator.logError(msg, e);
                ErrorDialog.openError((Shell)this.wp.getSite().getShell(), (String)act.getText(), (String)msg, (IStatus)status, (int)status.getSeverity());
            }
        }
    }
}

