/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.ui.internal.actions.RepositoryAction;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BranchAction
extends RepositoryAction {
    public void run(IAction action) {
        final Repository repository = this.getRepository(true);
        if (repository == null) {
            return;
        }
        if (!repository.getRepositoryState().canCheckout()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Cannot checkout now", (String)("Repository state:" + repository.getRepositoryState().getDescription()));
            return;
        }
        BranchSelectionDialog dialog = new BranchSelectionDialog(this.getShell(), repository);
        dialog.setShowResetType(false);
        if (dialog.open() != 0) {
            return;
        }
        final String refName = dialog.getRefName();
        try {
            this.getTargetPart().getSite().getWorkbenchWindow().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        new BranchOperation(repository, refName).run(monitor);
                        GitLightweightDecorator.refresh();
                    }
                    catch (CoreException ce) {
                        ce.printStackTrace();
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                BranchAction.this.handle((Exception)((Object)ce), "Error while switching branches", "Unable to switch branches");
                            }
                        });
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return this.getRepository(false) != null;
    }
}

