/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.actions.RepositoryAction;
import org.eclipse.egit.ui.internal.dialogs.CommitDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectWriter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryConfig;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitAction
extends RepositoryAction {
    private ArrayList<IFile> notIndexed;
    private ArrayList<IFile> indexChanges;
    private ArrayList<IFile> files;
    private Commit previousCommit;
    private boolean amendAllowed;
    private boolean amending;

    public void run(IAction act) {
        this.resetState();
        try {
            this.buildIndexHeadDiffList();
        }
        catch (IOException e) {
            Utils.handleError((Shell)this.getTargetPart().getSite().getShell(), (Exception)e, (String)"Error during commit", (String)"Error occurred computing diffs");
            return;
        }
        Repository[] repos = this.getRepositoriesFor(this.getProjectsForSelectedResources());
        Repository repository = null;
        this.amendAllowed = repos.length == 1;
        Repository[] repositoryArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repo;
            repository = repo = repositoryArray[n2];
            if (!repo.getRepositoryState().canCommit()) {
                MessageDialog.openError((Shell)this.getTargetPart().getSite().getShell(), (String)"Cannot commit now", (String)("Repository state:" + repo.getRepositoryState().getDescription()));
                return;
            }
            ++n2;
        }
        this.loadPreviousCommit();
        if (this.files.isEmpty()) {
            if (this.amendAllowed && this.previousCommit != null) {
                boolean result = MessageDialog.openQuestion((Shell)this.getTargetPart().getSite().getShell(), (String)"No files to commit", (String)"No changed items were selected. Do you wish to amend the last commit?");
                if (!result) {
                    return;
                }
                this.amending = true;
            } else {
                MessageDialog.openWarning((Shell)this.getTargetPart().getSite().getShell(), (String)"No files to commit", (String)"Commit/amend not possible. Possible causes:\n\n- No changed items were selected\n- Multiple repositories selected\n- No repositories selected\n- No previous commits");
                return;
            }
        }
        String author = null;
        String committer = null;
        if (repository != null) {
            RepositoryConfig config = repository.getConfig();
            author = config.getAuthorName();
            String authorEmail = config.getAuthorEmail();
            author = String.valueOf(author) + " <" + authorEmail + ">";
            committer = config.getCommitterName();
            String committerEmail = config.getCommitterEmail();
            committer = String.valueOf(committer) + " <" + committerEmail + ">";
        }
        CommitDialog commitDialog = new CommitDialog(this.getTargetPart().getSite().getShell());
        commitDialog.setAmending(this.amending);
        commitDialog.setAmendAllowed(this.amendAllowed);
        commitDialog.setFileList(this.files);
        commitDialog.setAuthor(author);
        commitDialog.setCommitter(committer);
        if (this.previousCommit != null) {
            commitDialog.setPreviousCommitMessage(this.previousCommit.getMessage());
            PersonIdent previousAuthor = this.previousCommit.getAuthor();
            commitDialog.setPreviousAuthor(String.valueOf(previousAuthor.getName()) + " <" + previousAuthor.getEmailAddress() + ">");
        }
        if (commitDialog.open() != 0) {
            return;
        }
        String commitMessage = commitDialog.getCommitMessage();
        this.amending = commitDialog.isAmending();
        try {
            this.performCommit(commitDialog, commitMessage);
        }
        catch (TeamException e) {
            Utils.handleError((Shell)this.getTargetPart().getSite().getShell(), (Exception)((Object)e), (String)"Error during commit", (String)"Error occurred while committing");
        }
    }

    private void resetState() {
        this.files = new ArrayList();
        this.notIndexed = new ArrayList();
        this.indexChanges = new ArrayList();
        this.amending = false;
        this.previousCommit = null;
    }

    private void loadPreviousCommit() {
        IProject project = this.getProjectsForSelectedResources()[0];
        Repository repo = RepositoryMapping.getMapping((IResource)project).getRepository();
        try {
            ObjectId parentId = repo.resolve("HEAD");
            if (parentId != null) {
                this.previousCommit = repo.mapCommit(parentId);
            }
        }
        catch (IOException e) {
            Utils.handleError((Shell)this.getTargetPart().getSite().getShell(), (Exception)e, (String)"Error during commit", (String)"Error occurred retrieving last commit");
        }
    }

    private void performCommit(CommitDialog commitDialog, String commitMessage) throws TeamException {
        IFile[] selectedItems = commitDialog.getSelectedFiles();
        HashMap<Repository, Tree> treeMap = new HashMap<Repository, Tree>();
        try {
            this.prepareTrees(selectedItems, treeMap);
        }
        catch (IOException e) {
            throw new TeamException("Preparing trees", (Throwable)e);
        }
        try {
            this.doCommits(commitDialog, commitMessage, treeMap);
        }
        catch (IOException e) {
            throw new TeamException("Committing changes", (Throwable)e);
        }
        IProject[] iProjectArray = this.getProjectsForSelectedResources();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            RepositoryMapping.getMapping((IResource)proj).fireRepositoryChanged();
            ++n2;
        }
    }

    private void doCommits(CommitDialog commitDialog, String commitMessage, HashMap<Repository, Tree> treeMap) throws IOException, TeamException {
        String author = commitDialog.getAuthor();
        String committer = commitDialog.getCommitter();
        Date commitDate = new Date();
        TimeZone timeZone = TimeZone.getDefault();
        PersonIdent authorIdent = new PersonIdent(author);
        PersonIdent committerIdent = new PersonIdent(committer);
        for (Map.Entry<Repository, Tree> entry : treeMap.entrySet()) {
            Tree tree = entry.getValue();
            Repository repo = tree.getRepository();
            this.writeTreeWithSubTrees(tree);
            ObjectId currentHeadId = repo.resolve("HEAD");
            ObjectId[] parentIds = this.amending ? this.previousCommit.getParentIds() : (currentHeadId != null ? new ObjectId[]{currentHeadId} : new ObjectId[]{});
            Commit commit = new Commit(repo, parentIds);
            commit.setTree(tree);
            commit.setMessage(commitMessage);
            commit.setAuthor(new PersonIdent(authorIdent, commitDate, timeZone));
            commit.setCommitter(new PersonIdent(committerIdent, commitDate, timeZone));
            ObjectWriter writer = new ObjectWriter(repo);
            commit.setCommitId(writer.writeCommit(commit));
            RefUpdate ru = repo.updateRef("HEAD");
            ru.setNewObjectId((AnyObjectId)commit.getCommitId());
            ru.setRefLogMessage(this.buildReflogMessage(commitMessage), false);
            if (ru.forceUpdate() != RefUpdate.Result.LOCK_FAILURE) continue;
            throw new TeamException("Failed to update " + ru.getName() + " to commit " + commit.getCommitId() + ".");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void prepareTrees(IFile[] selectedItems, HashMap<Repository, Tree> treeMap) throws IOException, UnsupportedEncodingException {
        if (selectedItems.length == 0) {
            var6_3 = this.getProjectsForSelectedResources();
            var5_4 = var6_3.length;
            var4_5 = 0;
            while (var4_5 < var5_4) {
                proj = var6_3[var4_5];
                repo = RepositoryMapping.getMapping((IResource)proj).getRepository();
                if (!treeMap.containsKey(repo)) {
                    treeMap.put(repo, repo.mapTree("HEAD"));
                }
                ++var4_5;
            }
        }
        var6_3 = selectedItems;
        var5_4 = selectedItems.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            file = var6_3[var4_5];
            project = file.getProject();
            repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            repository = repositoryMapping.getRepository();
            projTree = treeMap.get(repository);
            if (projTree == null) {
                projTree = repository.mapTree("HEAD");
                if (projTree == null) {
                    projTree = new Tree(repository);
                }
                treeMap.put(repository, projTree);
                System.out.println("Orig tree id: " + projTree.getId());
            }
            index = repository.getIndex();
            string = repoRelativePath = repositoryMapping.getRepoRelativePath((IResource)file);
            treeMember = projTree.findBlobMember(repoRelativePath);
            if (treeMember != null) {
                treeMember.delete();
            }
            idxEntry = index.getEntry(string);
            if (!this.notIndexed.contains(file)) ** GOTO lbl45
            thisfile = new File(repositoryMapping.getWorkDir(), idxEntry.getName());
            if (!thisfile.isFile()) {
                index.remove(repositoryMapping.getWorkDir(), thisfile);
                index.write();
                System.out.println("Phantom file, so removing from index");
            } else {
                if (idxEntry.update(thisfile)) {
                    index.write();
                }
lbl45:
                // 4 sources

                if (idxEntry != null) {
                    projTree.addFile(repoRelativePath);
                    newMember = projTree.findBlobMember(repoRelativePath);
                    newMember.setId(idxEntry.getObjectId());
                    System.out.println("New member id for " + repoRelativePath + ": " + newMember.getId() + " idx id: " + idxEntry.getObjectId());
                }
            }
            ++var4_5;
        }
    }

    private String buildReflogMessage(String commitMessage) {
        String firstLine = commitMessage;
        int newlineIndex = commitMessage.indexOf("\n");
        if (newlineIndex > 0) {
            firstLine = commitMessage.substring(0, newlineIndex);
        }
        String commitStr = this.amending ? "commit (amend):" : "commit: ";
        String message = String.valueOf(commitStr) + firstLine;
        return message;
    }

    private void writeTreeWithSubTrees(Tree tree) throws TeamException {
        if (tree.getId() == null) {
            System.out.println("writing tree for: " + tree.getFullName());
            try {
                TreeEntry[] treeEntryArray = tree.members();
                int n = treeEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeEntry entry = treeEntryArray[n2];
                    if (entry.isModified()) {
                        if (entry instanceof Tree) {
                            this.writeTreeWithSubTrees((Tree)entry);
                        } else {
                            System.out.println("BAD JUJU: " + entry.getFullName());
                        }
                    }
                    ++n2;
                }
                ObjectWriter writer = new ObjectWriter(tree.getRepository());
                tree.setId(writer.writeTree(tree));
            }
            catch (IOException e) {
                throw new TeamException("Writing trees", (Throwable)e);
            }
        }
    }

    private void buildIndexHeadDiffList() throws IOException {
        IProject[] iProjectArray = this.getProjectsInRepositoryOfSelectedResources();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            assert (repositoryMapping != null);
            Repository repository = repositoryMapping.getRepository();
            Tree head = repository.mapTree("HEAD");
            GitIndex index = repository.getIndex();
            IndexDiff indexDiff = new IndexDiff(head, index);
            indexDiff.diff();
            this.includeList(project, indexDiff.getAdded(), this.indexChanges);
            this.includeList(project, indexDiff.getChanged(), this.indexChanges);
            this.includeList(project, indexDiff.getRemoved(), this.indexChanges);
            this.includeList(project, indexDiff.getMissing(), this.notIndexed);
            this.includeList(project, indexDiff.getModified(), this.notIndexed);
            ++n2;
        }
    }

    private void includeList(IProject project, HashSet<String> added, ArrayList<IFile> category) {
        String repoRelativePath = RepositoryMapping.getMapping((IResource)project).getRepoRelativePath((IResource)project);
        if (repoRelativePath.length() > 0) {
            repoRelativePath = String.valueOf(repoRelativePath) + "/";
        }
        for (String filename : added) {
            try {
                if (!filename.startsWith(repoRelativePath)) continue;
                String projectRelativePath = filename.substring(repoRelativePath.length());
                IFile member = project.getFile(projectRelativePath);
                if (member != null && member instanceof IFile) {
                    if (!this.files.contains(member)) {
                        this.files.add(member);
                    }
                    category.add(member);
                    continue;
                }
                System.out.println("Couldn't find " + filename);
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        }
    }

    boolean tryAddResource(IFile resource, GitProjectData projectData, ArrayList<IFile> category) {
        if (this.files.contains(resource)) {
            return false;
        }
        try {
            RepositoryMapping repositoryMapping = projectData.getRepositoryMapping((IResource)resource);
            if (this.isChanged(repositoryMapping, resource)) {
                this.files.add(resource);
                category.add(resource);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isChanged(RepositoryMapping map, IFile resource) {
        try {
            Repository repository = map.getRepository();
            GitIndex index = repository.getIndex();
            String repoRelativePath = map.getRepoRelativePath((IResource)resource);
            GitIndex.Entry entry = index.getEntry(repoRelativePath);
            if (entry != null) {
                return entry.isModified(map.getWorkDir());
            }
            return false;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.getProjectsInRepositoryOfSelectedResources().length > 0;
    }
}

