/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.EditableRevision;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;

public class CompareWithIndexAction
extends RepositoryAction {
    public void execute(IAction action) {
        IResource resource = this.getSelectedResources()[0];
        final RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource.getProject());
        final Repository repository = mapping.getRepository();
        String gitPath = mapping.getRepoRelativePath(resource);
        GitFileRevision nextFile = GitFileRevision.inIndex((Repository)repository, (String)gitPath);
        final IFile baseFile = (IFile)resource;
        ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)baseFile);
        final EditableRevision next = new EditableRevision((IFileRevision)nextFile);
        IContentChangeListener listener = new IContentChangeListener(){

            public void contentChanged(IContentChangeNotifier source) {
                byte[] newContent = next.getModifiedContent();
                try {
                    GitIndex index = repository.getIndex();
                    File file = new File(baseFile.getLocation().toString());
                    index.add(mapping.getWorkDir(), file, newContent);
                    index.write();
                }
                catch (IOException e) {
                    Utils.handleError((Shell)CompareWithIndexAction.this.getTargetPart().getSite().getShell(), (Exception)e, (String)"Error during adding to index", (String)"Error during adding to index");
                    return;
                }
            }
        };
        next.addContentChangeListener(listener);
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
        CompareUI.openCompareEditor((CompareEditorInput)in);
    }

    public boolean isEnabled() {
        IResource[] selectedResources = this.getSelectedResources();
        if (selectedResources.length != 1) {
            return false;
        }
        IResource resource = selectedResources[0];
        if (!(resource instanceof IFile)) {
            return false;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource.getProject());
        return mapping != null;
    }
}

