/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.Team;

public class IgnoreAction
extends RepositoryAction {
    public void run(IAction action) {
        final IResource[] resources = this.getSelectedResources();
        if (resources.length == 0) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(UIText.IgnoreAction_jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(UIText.IgnoreAction_taskName, resources.length);
                try {
                    IResource[] iResourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (!Team.isIgnoredHint((IResource)resource)) {
                            this.addIgnore(monitor, resource);
                        }
                        monitor.worked(1);
                        ++n2;
                    }
                    monitor.done();
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.egit.ui", UIText.IgnoreAction_error, (Throwable)e));
                }
                return Status.OK_STATUS;
            }

            private void addIgnore(IProgressMonitor monitor, IResource resource) throws UnsupportedEncodingException, CoreException {
                IContainer container = resource.getParent();
                IFile gitignore = container.getFile((IPath)new Path(".gitignore"));
                String entry = "/" + resource.getName() + "\n";
                ByteArrayInputStream entryBytes = this.asStream(entry);
                if (gitignore.exists()) {
                    gitignore.appendContents((InputStream)entryBytes, true, true, monitor);
                } else {
                    gitignore.create((InputStream)entryBytes, true, monitor);
                }
            }

            private ByteArrayInputStream asStream(String entry) throws UnsupportedEncodingException {
                return new ByteArrayInputStream(entry.getBytes("UTF-8"));
            }
        };
        job.schedule();
    }

    public boolean isEnabled() {
        IResource[] resources;
        if (this.getProjectsInRepositoryOfSelectedResources().length == 0) {
            return false;
        }
        IResource[] iResourceArray = resources = this.getSelectedResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!Team.isIgnoredHint((IResource)resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

