/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.actions.TeamAction;

public abstract class RepositoryAction
extends TeamAction {
    public void execute(IAction action) {
        this.run(action);
    }

    protected IProject[] getProjectsForSelectedResources() {
        HashSet<IProject> ret = new HashSet<IProject>();
        IResource[] iResourceArray = (IResource[])RepositoryAction.getSelectedAdaptables((ISelection)this.getSelection(), IResource.class);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ret.add(resource.getProject());
            ++n2;
        }
        return ret.toArray(new IProject[ret.size()]);
    }

    protected Repository[] getRepositoriesFor(IProject[] projects) {
        HashSet<Repository> ret = new HashSet<Repository>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            ret.add(repositoryMapping.getRepository());
            ++n2;
        }
        return ret.toArray(new Repository[ret.size()]);
    }

    public IProject[] getProjectsInRepositoryOfSelectedResources() {
        IProject[] projects;
        HashSet<IProject> ret = new HashSet<IProject>();
        Repository[] repositories = this.getRepositoriesFor(this.getProjectsForSelectedResources());
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            Repository[] repositoryArray = repositories;
            int n3 = repositories.length;
            int n4 = 0;
            while (n4 < n3) {
                Repository repository = repositoryArray[n4];
                if (mapping != null && mapping.getRepository() == repository) {
                    ret.add(project);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return ret.toArray(new IProject[ret.size()]);
    }

    protected Repository getRepository(boolean warn) {
        RepositoryMapping mapping = null;
        IProject[] iProjectArray = this.getSelectedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            if (mapping == null) {
                mapping = repositoryMapping;
            }
            if (repositoryMapping == null) {
                return null;
            }
            if (mapping.getRepository() != repositoryMapping.getRepository()) {
                if (warn) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Multiple Repositories Selection", (String)"Cannot perform reset on multiple repositories simultaneously.\n\nPlease select items from only one repository.");
                }
                return null;
            }
            ++n2;
        }
        if (mapping == null) {
            if (warn) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Cannot Find Repository", (String)"Could not find a repository associated with this project");
            }
            return null;
        }
        Repository repository = mapping.getRepository();
        return repository;
    }

    protected Repository[] getRepositories() {
        IProject[] selectedProjects = this.getSelectedProjects();
        HashSet<Repository> repos = new HashSet<Repository>(selectedProjects.length);
        IProject[] iProjectArray = selectedProjects;
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            repos.add(repositoryMapping.getRepository());
            ++n2;
        }
        return repos.toArray(new Repository[repos.size()]);
    }

    public abstract boolean isEnabled();
}

