/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.internal.actions.RepositoryAction;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class ResetAction
extends RepositoryAction {
    public void run(IAction action) {
        final Repository repository = this.getRepository(true);
        if (repository == null) {
            return;
        }
        if (!repository.getRepositoryState().canResetHead()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Cannot reset HEAD now", (String)("Repository state:" + repository.getRepositoryState().getDescription()));
            return;
        }
        BranchSelectionDialog branchSelectionDialog = new BranchSelectionDialog(this.getShell(), repository);
        if (branchSelectionDialog.open() == 0) {
            final String refName = branchSelectionDialog.getRefName();
            final ResetOperation.ResetType type = branchSelectionDialog.getResetType();
            try {
                this.getTargetPart().getSite().getWorkbenchWindow().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            new ResetOperation(repository, refName, type).run(monitor);
                            GitLightweightDecorator.refresh();
                        }
                        catch (CoreException ce) {
                            ce.printStackTrace();
                            throw new InvocationTargetException(ce);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Reset failed", (String)e.getMessage());
            }
            catch (InterruptedException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Reset failed", (String)e.getMessage());
            }
        }
    }

    public boolean isEnabled() {
        return this.getRepository(false) != null;
    }
}

