/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.clone.SourceBranchPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.components.SelectionChangeListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class CloneDestinationPage
extends WizardPage {
    private final RepositorySelectionPage sourcePage;
    private final SourceBranchPage branchPage;
    private RepositorySelection validatedRepoSelection;
    private List<Ref> validatedSelectedBranches;
    private Ref validatedHEAD;
    private Combo initialBranch;
    private Text directoryText;
    private Text remoteText;
    Button showImportWizard;
    String alreadyClonedInto;

    CloneDestinationPage(RepositorySelectionPage sp, SourceBranchPage bp) {
        super(CloneDestinationPage.class.getName());
        this.sourcePage = sp;
        this.branchPage = bp;
        this.setTitle(UIText.CloneDestinationPage_title);
        SelectionChangeListener listener = new SelectionChangeListener(){

            public void selectionChanged() {
                CloneDestinationPage.this.checkPreviousPagesSelections();
            }
        };
        this.sourcePage.addSelectionListener(listener);
        this.branchPage.addSelectionListener(listener);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.createDestinationGroup(panel);
        this.createConfigGroup(panel);
        this.createWorkbenchGroup(panel);
        this.setControl((Control)panel);
        this.checkPage();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.revalidate();
        }
        super.setVisible(visible);
        if (visible) {
            this.directoryText.setFocus();
        }
    }

    private void checkPreviousPagesSelections() {
        if (!this.sourcePage.selectionEquals(this.validatedRepoSelection) || !this.branchPage.selectionEquals(this.validatedSelectedBranches, this.validatedHEAD)) {
            this.setPageComplete(false);
        } else {
            this.checkPage();
        }
    }

    private void createDestinationGroup(Composite parent) {
        Group g = CloneDestinationPage.createGroup(parent, UIText.CloneDestinationPage_groupDestination);
        CloneDestinationPage.newLabel(g, String.valueOf(UIText.CloneDestinationPage_promptDirectory) + ":");
        Composite p = new Composite((Composite)g, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        p.setLayout((Layout)grid);
        p.setLayoutData((Object)CloneDestinationPage.createFieldGridData());
        this.directoryText = new Text(p, 2048);
        this.directoryText.setLayoutData((Object)CloneDestinationPage.createFieldGridData());
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloneDestinationPage.this.checkPage();
            }
        });
        Button b = new Button(p, 8);
        b.setText(UIText.CloneDestinationPage_browseButton);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String r;
                FileDialog d = new FileDialog(CloneDestinationPage.this.getShell(), 73728);
                if (CloneDestinationPage.this.directoryText.getText().length() > 0) {
                    File file = new File(CloneDestinationPage.this.directoryText.getText()).getAbsoluteFile();
                    d.setFilterPath(file.getParent());
                    d.setFileName(file.getName());
                }
                if ((r = d.open()) != null) {
                    CloneDestinationPage.this.directoryText.setText(r);
                }
            }
        });
        CloneDestinationPage.newLabel(g, String.valueOf(UIText.CloneDestinationPage_promptInitialBranch) + ":");
        this.initialBranch = new Combo((Composite)g, 12);
        this.initialBranch.setLayoutData((Object)CloneDestinationPage.createFieldGridData());
        this.initialBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloneDestinationPage.this.checkPage();
            }
        });
    }

    private void createConfigGroup(Composite parent) {
        Group g = CloneDestinationPage.createGroup(parent, UIText.CloneDestinationPage_groupConfiguration);
        CloneDestinationPage.newLabel(g, String.valueOf(UIText.CloneDestinationPage_promptRemoteName) + ":");
        this.remoteText = new Text((Composite)g, 2048);
        this.remoteText.setText("origin");
        this.remoteText.setLayoutData((Object)CloneDestinationPage.createFieldGridData());
        this.remoteText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloneDestinationPage.this.checkPage();
            }
        });
    }

    private void createWorkbenchGroup(Composite parent) {
        Group g = CloneDestinationPage.createGroup(parent, UIText.CloneDestinationPage_workspaceImport);
        this.showImportWizard = new Button((Composite)g, 32);
        this.showImportWizard.setSelection(true);
        this.showImportWizard.setText(UIText.CloneDestinationPage_importProjectsAfterClone);
        this.showImportWizard.setLayoutData((Object)CloneDestinationPage.createFieldGridData());
        this.showImportWizard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloneDestinationPage.this.checkPage();
            }
        });
    }

    private static Group createGroup(Composite parent, String text) {
        Group g = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        g.setLayout((Layout)layout);
        g.setText(text);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static void newLabel(Group g, String text) {
        new Label((Composite)g, 0).setText(text);
    }

    private static GridData createFieldGridData() {
        return new GridData(4, -1, true, false);
    }

    public File getDestinationFile() {
        return new File(this.directoryText.getText());
    }

    public String getInitialBranch() {
        int ix = this.initialBranch.getSelectionIndex();
        if (ix < 0) {
            return "refs/heads/master";
        }
        return "refs/heads/" + this.initialBranch.getItem(ix);
    }

    public String getRemote() {
        return this.remoteText.getText();
    }

    private void checkPage() {
        String dstpath = this.directoryText.getText();
        if (dstpath.length() == 0) {
            this.setErrorMessage(NLS.bind((String)UIText.CloneDestinationPage_fieldRequired, (Object)UIText.CloneDestinationPage_promptDirectory));
            this.setPageComplete(false);
            return;
        }
        File absoluteFile = new File(dstpath).getAbsoluteFile();
        if (!absoluteFile.getAbsolutePath().equals(this.alreadyClonedInto) && !CloneDestinationPage.isEmptyDir(absoluteFile)) {
            this.setErrorMessage(NLS.bind((String)UIText.CloneDestinationPage_errorNotEmptyDir, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        if (!CloneDestinationPage.canCreateSubdir(absoluteFile.getParentFile())) {
            this.setErrorMessage(NLS.bind((String)UIText.GitCloneWizard_errorCannotCreate, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        if (this.initialBranch.getSelectionIndex() < 0) {
            this.setErrorMessage(NLS.bind((String)UIText.CloneDestinationPage_fieldRequired, (Object)UIText.CloneDestinationPage_promptInitialBranch));
            this.setPageComplete(false);
            return;
        }
        if (this.remoteText.getText().length() == 0) {
            this.setErrorMessage(NLS.bind((String)UIText.CloneDestinationPage_fieldRequired, (Object)UIText.CloneDestinationPage_promptRemoteName));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private static boolean isEmptyDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        return dir.listFiles().length == 0;
    }

    private static boolean canCreateSubdir(File parent) {
        if (parent == null) {
            return true;
        }
        if (parent.exists()) {
            return parent.isDirectory() && parent.canWrite();
        }
        return CloneDestinationPage.canCreateSubdir(parent.getParentFile());
    }

    private void revalidate() {
        if (this.sourcePage.selectionEquals(this.validatedRepoSelection) && this.branchPage.selectionEquals(this.validatedSelectedBranches, this.validatedHEAD)) {
            this.checkPage();
            return;
        }
        if (!this.sourcePage.selectionEquals(this.validatedRepoSelection)) {
            this.validatedRepoSelection = this.sourcePage.getSelection();
            String n = this.validatedRepoSelection.getURI().getHumanishName();
            this.setDescription(NLS.bind((String)UIText.CloneDestinationPage_description, (Object)n));
            this.directoryText.setText(new File(ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toFile(), n).getAbsolutePath());
        }
        this.validatedSelectedBranches = this.branchPage.getSelectedBranches();
        this.validatedHEAD = this.branchPage.getHEAD();
        this.initialBranch.removeAll();
        Ref head = this.branchPage.getHEAD();
        int newix = 0;
        for (Ref r : this.branchPage.getSelectedBranches()) {
            String name = r.getName();
            if (name.startsWith("refs/heads/")) {
                name = name.substring("refs/heads/".length());
            }
            if (head != null && head.getName().equals(r.getName())) {
                newix = this.initialBranch.getItemCount();
            }
            this.initialBranch.add(name);
        }
        this.initialBranch.select(newix);
        this.checkPage();
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.showImportWizard.getSelection();
    }
}

