/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.clone.CloneDestinationPage;
import org.eclipse.egit.ui.internal.clone.GitProjectsImportPage;
import org.eclipse.egit.ui.internal.clone.SourceBranchPage;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class GitCloneWizard
extends Wizard
implements IImportWizard {
    private RepositorySelectionPage cloneSource;
    private SourceBranchPage validSource;
    private CloneDestinationPage cloneDestination;
    private GitProjectsImportPage importProject;

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
        this.setWindowTitle(UIText.GitCloneWizard_title);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.setNeedsProgressMonitor(true);
        this.cloneSource = new RepositorySelectionPage(true);
        this.validSource = new SourceBranchPage(this.cloneSource);
        this.cloneDestination = new CloneDestinationPage(this.cloneSource, this.validSource);
        this.importProject = new GitProjectsImportPage(){

            public void setVisible(boolean visible) {
                if (visible) {
                    if (((GitCloneWizard)GitCloneWizard.this).cloneDestination.alreadyClonedInto == null && GitCloneWizard.this.performClone(false)) {
                        ((GitCloneWizard)GitCloneWizard.this).cloneDestination.alreadyClonedInto = GitCloneWizard.this.cloneDestination.getDestinationFile().getAbsolutePath();
                    }
                    this.setProjectsList(((GitCloneWizard)GitCloneWizard.this).cloneDestination.alreadyClonedInto);
                }
                super.setVisible(visible);
            }
        };
    }

    public boolean performCancel() {
        if (this.cloneDestination.alreadyClonedInto != null && MessageDialog.openQuestion((Shell)this.getShell(), (String)"Aborting clone.", (String)"A complete clone was already made. Do you want to delete it?")) {
            this.deleteRecursively(new File(this.cloneDestination.alreadyClonedInto));
        }
        return true;
    }

    private void deleteRecursively(File f) {
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File i = fileArray[n2];
            if (i.isDirectory()) {
                this.deleteRecursively(i);
            } else if (!i.delete()) {
                i.deleteOnExit();
            }
            ++n2;
        }
        if (!f.delete()) {
            f.deleteOnExit();
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.cloneSource);
        this.addPage((IWizardPage)this.validSource);
        this.addPage((IWizardPage)this.cloneDestination);
        this.addPage((IWizardPage)this.importProject);
    }

    public boolean canFinish() {
        return this.cloneDestination.isPageComplete() && !this.cloneDestination.showImportWizard.getSelection() || this.importProject.isPageComplete();
    }

    public boolean performFinish() {
        if (!this.cloneDestination.showImportWizard.getSelection()) {
            return this.performClone(true);
        }
        return this.importProject.createProjects();
    }

    boolean performClone(boolean background) {
        URIish uri = this.cloneSource.getSelection().getURI();
        boolean allSelected = this.validSource.isAllSelected();
        List<Ref> selectedBranches = this.validSource.getSelectedBranches();
        File workdir = this.cloneDestination.getDestinationFile();
        String branch = this.cloneDestination.getInitialBranch();
        String remoteName = this.cloneDestination.getRemote();
        workdir.mkdirs();
        if (!workdir.isDirectory()) {
            String errorMessage = NLS.bind((String)UIText.GitCloneWizard_errorCannotCreate, (Object)workdir.getPath());
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getWindowTitle(), (String)UIText.GitCloneWizard_failed, (IStatus)new Status(4, Activator.getPluginId(), 0, errorMessage, null));
            return false;
        }
        final CloneOperation op = new CloneOperation(uri, allSelected, selectedBranches, workdir, branch, remoteName);
        this.importProject.setGitDir(op.getGitDir());
        if (background) {
            Job job = new Job(NLS.bind((String)UIText.GitCloneWizard_jobName, (Object)uri.toString())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        op.run(monitor);
                        return Status.OK_STATUS;
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (InvocationTargetException e) {
                        Throwable thr = e.getCause();
                        return new Status(4, Activator.getPluginId(), 0, thr.getMessage(), thr);
                    }
                }
            };
            job.setUser(true);
            job.schedule();
            return true;
        }
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            return true;
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)UIText.GitCloneWizard_CloneFailedHeading, (String)UIText.GitCloneWizard_CloneCanceledMessage);
            return false;
        }
        catch (Exception e) {
            Activator.logError(UIText.GitCloneWizard_CloneFailedHeading, e);
            MessageDialog.openError((Shell)this.getShell(), (String)UIText.GitCloneWizard_CloneFailedHeading, (String)e.toString());
            return false;
        }
    }
}

