/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitProjectsImportPage
extends WizardPage {
    public static final String METADATA_FOLDER = ".metadata";
    private IImportStructureProvider structureProvider;
    private File gitDir;
    private TreeViewer projectsList;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private final HashSet<Object> checkedItems = new HashSet();
    private IProject[] wsProjects;
    private String lastPath;
    private long lastModified;
    private Button shareCheckBox;
    private boolean share;

    public GitProjectsImportPage() {
        this("gitWizardExternalProjectsPage");
    }

    public GitProjectsImportPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle(UIText.WizardProjectsImportPage_ImportProjectsTitle);
        this.setDescription(UIText.WizardProjectsImportPage_ImportProjectsDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        this.createOptionsArea(workArea);
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createOptionsArea(Composite workArea) {
        Composite optionsGroup = new Composite(workArea, 0);
        optionsGroup.setLayout((Layout)new GridLayout());
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.shareCheckBox = new Button(optionsGroup, 32);
        this.shareCheckBox.setText(UIText.WizardProjectsImportPage_enableGit);
        this.shareCheckBox.setLayoutData((Object)new GridData(768));
        this.share = true;
        this.shareCheckBox.setSelection(true);
        this.shareCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitProjectsImportPage.this.share = GitProjectsImportPage.this.shareCheckBox.getSelection();
            }
        });
    }

    private void createProjectsList(Composite workArea) {
        this.checkedItems.clear();
        Label title = new Label(workArea, 0);
        title.setText(UIText.WizardProjectsImportPage_ProjectsListTitle);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        PatternFilter filter = new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                if (GitProjectsImportPage.this.checkedItems.contains(element)) {
                    return true;
                }
                return super.isElementVisible(viewer, element);
            }
        };
        FilteredTree filteredTree = new FilteredTree(listComposite, 2080, filter, true);
        filteredTree.setInitialText(UIText.WizardProjectsImportPage_filterText);
        this.projectsList = filteredTree.getViewer();
        GridData listData = new GridData(1808);
        this.projectsList.getControl().setLayoutData((Object)listData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return GitProjectsImportPage.this.getValidProjects();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TreeItem item;
                if (e.widget instanceof Tree && (item = ((Tree)e.widget).getItem(new Point(e.x, e.y))) != null) {
                    if (item.getChecked()) {
                        GitProjectsImportPage.this.checkedItems.add(item.getData());
                    } else {
                        GitProjectsImportPage.this.checkedItems.remove(item.getData());
                    }
                    GitProjectsImportPage.this.setPageComplete(!GitProjectsImportPage.this.checkedItems.isEmpty());
                }
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TreeItem[] treeItemArray = GitProjectsImportPage.this.projectsList.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (GitProjectsImportPage.this.checkedItems.contains(item.getData())) {
                        item.setChecked(true);
                    } else {
                        item.setChecked(false);
                    }
                    ++n2;
                }
                return ((ProjectRecord)element).getProjectLabel();
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(UIText.WizardProjectsImportPage_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitProjectsImportPage.this.checkedItems.clear();
                TreeItem[] treeItemArray = GitProjectsImportPage.this.projectsList.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    item.setChecked(true);
                    GitProjectsImportPage.this.checkedItems.add(item.getData());
                    ++n2;
                }
                GitProjectsImportPage.this.setPageComplete(true);
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(UIText.WizardProjectsImportPage_deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitProjectsImportPage.this.checkedItems.clear();
                TreeItem[] treeItemArray = GitProjectsImportPage.this.projectsList.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    item.setChecked(false);
                    ++n2;
                }
                GitProjectsImportPage.this.projectsList.setInput((Object)this);
                GitProjectsImportPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void setGitDir(File gitDir) {
        this.gitDir = gitDir;
    }

    void setProjectsList(String path) {
        if (path == null || path.length() == 0) {
            this.setMessage(UIText.WizardProjectsImportPage_ImportProjectsDescription);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.setPageComplete(this.checkedItems.size() > 0);
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(UIText.WizardProjectsImportPage_SearchingMessage, 100);
                    GitProjectsImportPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList files = new ArrayList();
                    monitor.worked(10);
                    if (directory.isDirectory()) {
                        if (!GitProjectsImportPage.this.collectProjectFilesFromDirectory(files, directory, null, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        GitProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(UIText.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            File file = (File)filesIterator.next();
                            ((GitProjectsImportPage)GitProjectsImportPage.this).selectedProjects[index] = new ProjectRecord(file);
                            GitProjectsImportPage.this.checkedItems.add(GitProjectsImportPage.this.selectedProjects[index]);
                            ++index;
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        if (this.getValidProjects().length < this.selectedProjects.length) {
            this.setMessage(UIText.WizardProjectsImportPage_projectsInWorkspace, 2);
        } else {
            this.setMessage(UIText.WizardProjectsImportPage_ImportProjectsDescription);
        }
        this.setPageComplete(this.checkedItems.size() > 0);
    }

    private boolean collectProjectFilesFromDirectory(Collection<File> files, File directory, Set<String> directoriesVisited, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)UIText.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(file);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            block12: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block11: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block11;
                            break block12;
                        }
                        catch (IOException exception) {
                            StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
                        }
                    }
                    this.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited, monitor);
                }
            }
            ++i;
        }
        return true;
    }

    boolean createProjects() {
        final Object[] selected = this.checkedItems.toArray();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("", selected.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int i = 0;
                    while (i < selected.length) {
                        GitProjectsImportPage.this.createExistingProject((ProjectRecord)selected[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = UIText.WizardProjectImportPage_errorMessage;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
            Activator.logError(message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        return true;
    }

    private boolean createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        try {
            try {
                monitor.beginTask(UIText.WizardProjectsImportPage_CreateProjectsTask, 100);
                project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                int openTicks = this.share ? 50 : 70;
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, openTicks));
                if (this.share) {
                    ConnectProviderOperation connectProviderOperation = new ConnectProviderOperation(project, this.gitDir);
                    connectProviderOperation.run((IProgressMonitor)new SubProgressMonitor(monitor, 20));
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public TreeViewer getProjectsList() {
        return this.projectsList;
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    public ProjectRecord[] getValidProjects() {
        ArrayList<ProjectRecord> validProjects = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (!this.isProjectInWorkspace(this.selectedProjects[i].getProjectName())) {
                validProjects.add(this.selectedProjects[i]);
            }
            ++i;
        }
        return validProjects.toArray(new ProjectRecord[validProjects.size()]);
    }

    private boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class ProjectRecord {
        File projectSystemFile;
        String projectName;
        Object parent;
        int level;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        ProjectRecord(Object parent, int level) {
            this.parent = parent;
            this.level = level;
            this.setProjectName();
        }

        private void setProjectName() {
            try {
                if (this.projectName == null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                }
            }
            catch (CoreException coreException) {}
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectLabel() {
            if (this.description == null) {
                return this.projectName;
            }
            String path = this.projectSystemFile == null ? GitProjectsImportPage.this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)UIText.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)path);
        }
    }
}

