/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.BaseWizardPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.components.SelectionChangeListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceBranchPage
extends BaseWizardPage {
    private final RepositorySelectionPage sourcePage;
    private RepositorySelection validatedRepoSelection;
    private Ref head;
    private List<Ref> availableRefs = new ArrayList<Ref>();
    private List<Ref> selectedRefs = new ArrayList<Ref>();
    private Label label;
    private Table refsTable;
    private String transportError;

    SourceBranchPage(RepositorySelectionPage sp) {
        super(SourceBranchPage.class.getName());
        this.sourcePage = sp;
        this.setTitle(UIText.SourceBranchPage_title);
        this.setDescription(UIText.SourceBranchPage_description);
        this.sourcePage.addSelectionListener(new SelectionChangeListener(){

            public void selectionChanged() {
                if (!SourceBranchPage.this.sourcePage.selectionEquals(SourceBranchPage.this.validatedRepoSelection)) {
                    SourceBranchPage.this.setPageComplete(false);
                } else {
                    SourceBranchPage.this.checkPage();
                }
            }
        });
    }

    List<Ref> getSelectedBranches() {
        return new ArrayList<Ref>(this.selectedRefs);
    }

    Ref getHEAD() {
        return this.head;
    }

    boolean isAllSelected() {
        return this.availableRefs.size() == this.selectedRefs.size();
    }

    boolean selectionEquals(List<Ref> selectedRefs, Ref head) {
        return this.selectedRefs.equals(selectedRefs) && this.head == head;
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.label = new Label(panel, 0);
        this.label.setLayoutData((Object)new GridData(4, 128, true, false));
        this.refsTable = new Table(panel, 2592);
        this.refsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.refsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                TableItem tableItem = (TableItem)e.item;
                int i = SourceBranchPage.this.refsTable.indexOf(tableItem);
                Ref ref = (Ref)SourceBranchPage.this.availableRefs.get(i);
                if (tableItem.getChecked()) {
                    int insertionPos = 0;
                    int j = 0;
                    while (j < i) {
                        if (SourceBranchPage.this.selectedRefs.contains(SourceBranchPage.this.availableRefs.get(j))) {
                            ++insertionPos;
                        }
                        ++j;
                    }
                    SourceBranchPage.this.selectedRefs.add(insertionPos, ref);
                } else {
                    SourceBranchPage.this.selectedRefs.remove(ref);
                }
                SourceBranchPage.this.notifySelectionChanged();
                SourceBranchPage.this.checkPage();
            }
        });
        Composite bPanel = new Composite(panel, 0);
        bPanel.setLayout((Layout)new RowLayout());
        final Button selectB = new Button(bPanel, 8);
        selectB.setText(UIText.SourceBranchPage_selectAll);
        selectB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < SourceBranchPage.this.refsTable.getItemCount()) {
                    SourceBranchPage.this.refsTable.getItem(i).setChecked(true);
                    ++i;
                }
                SourceBranchPage.this.selectedRefs.clear();
                SourceBranchPage.this.selectedRefs.addAll(SourceBranchPage.this.availableRefs);
                SourceBranchPage.this.notifySelectionChanged();
                SourceBranchPage.this.checkPage();
            }
        });
        final Button unselectB = new Button(bPanel, 8);
        unselectB.setText(UIText.SourceBranchPage_selectNone);
        unselectB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < SourceBranchPage.this.refsTable.getItemCount()) {
                    SourceBranchPage.this.refsTable.getItem(i).setChecked(false);
                    ++i;
                }
                SourceBranchPage.this.selectedRefs.clear();
                SourceBranchPage.this.notifySelectionChanged();
                SourceBranchPage.this.checkPage();
            }
        });
        bPanel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addSelectionListener(new SelectionChangeListener(){

            public void selectionChanged() {
                selectB.setEnabled(SourceBranchPage.this.selectedRefs.size() != SourceBranchPage.this.availableRefs.size());
                unselectB.setEnabled(SourceBranchPage.this.selectedRefs.size() != 0);
            }
        });
        this.setControl((Control)panel);
        this.checkPage();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.revalidate();
        }
        super.setVisible(visible);
    }

    private void checkPage() {
        if (this.transportError != null) {
            this.setErrorMessage(this.transportError);
            this.setPageComplete(false);
            return;
        }
        if (this.getSelectedBranches().isEmpty()) {
            this.setErrorMessage(UIText.SourceBranchPage_errorBranchRequired);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void revalidate() {
        if (this.sourcePage.selectionEquals(this.validatedRepoSelection)) {
            this.checkPage();
            return;
        }
        final RepositorySelection newRepoSelection = this.sourcePage.getSelection();
        this.label.setText(NLS.bind((String)UIText.SourceBranchPage_branchList, (Object)newRepoSelection.getURI().toString()));
        this.label.getParent().layout();
        this.validatedRepoSelection = null;
        this.transportError = null;
        this.head = null;
        this.availableRefs.clear();
        this.selectedRefs.clear();
        this.refsTable.removeAll();
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.label.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SourceBranchPage.this.revalidateImpl(newRepoSelection);
            }
        });
    }

    private void revalidateImpl(RepositorySelection newRepoSelection) {
        String n;
        ListRemoteOperation listRemoteOp;
        if (this.label.isDisposed() || !this.isCurrentPage()) {
            return;
        }
        try {
            URIish uri = newRepoSelection.getURI();
            Repository db = new Repository(new File("/tmp"));
            listRemoteOp = new ListRemoteOperation(db, uri);
            this.getContainer().run(true, true, (IRunnableWithProgress)listRemoteOp);
        }
        catch (InvocationTargetException e) {
            Throwable why = e.getCause();
            this.transportError(why.getMessage());
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.SourceBranchPage_transportError, (String)UIText.SourceBranchPage_cannotListBranches, (IStatus)new Status(4, Activator.getPluginId(), 0, why.getMessage(), why.getCause()));
            return;
        }
        catch (IOException iOException) {
            this.transportError(UIText.SourceBranchPage_cannotCreateTemp);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.transportError(UIText.SourceBranchPage_remoteListingCancelled);
            return;
        }
        Ref idHEAD = listRemoteOp.getRemoteRef("HEAD");
        this.head = null;
        for (Ref r : listRemoteOp.getRemoteRefs()) {
            n = r.getName();
            if (!n.startsWith("refs/heads/")) continue;
            this.availableRefs.add(r);
            if (idHEAD == null || this.head != null || !r.getObjectId().equals((AnyObjectId)idHEAD.getObjectId())) continue;
            this.head = r;
        }
        Collections.sort(this.availableRefs, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (idHEAD != null && this.head == null) {
            this.head = idHEAD;
            this.availableRefs.add(0, idHEAD);
        }
        this.validatedRepoSelection = newRepoSelection;
        for (Ref r : this.availableRefs) {
            n = r.getName();
            if (n.startsWith("refs/heads/")) {
                n = n.substring("refs/heads/".length());
            }
            TableItem ti = new TableItem(this.refsTable, 0);
            ti.setText(n);
            ti.setChecked(true);
            this.selectedRefs.add(r);
        }
        this.notifySelectionChanged();
        this.checkPage();
    }

    private void transportError(String msg) {
        this.transportError = msg;
        this.checkPage();
    }
}

