/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.io.IOException;
import java.sql.Blob;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tag;
import org.eclipse.jgit.lib.Tree;

public class RefContentProposal
implements IContentProposal {
    private static final String[] PREFIXES = new String[]{"refs/heads/", "refs/remotes/", "refs/tags/"};
    private static final String[] PREFIXES_DESCRIPTIONS = new String[]{" [branch]", " [tracking branch]", " [tag]"};
    private final Repository db;
    private final String refName;
    private final ObjectId objectId;

    private static void appendObjectSummary(StringBuilder sb, String type, PersonIdent author, String message) {
        sb.append(String.valueOf(type) + " by ");
        sb.append(author.getName());
        sb.append("\n");
        sb.append(author.getWhen());
        sb.append("\n\n");
        int newLine = message.indexOf(10);
        int last = newLine != -1 ? newLine : message.length();
        sb.append(message.substring(0, last));
    }

    public RefContentProposal(Repository repo, Ref ref) {
        this(repo, ref.getName(), ref.getObjectId());
    }

    public RefContentProposal(Repository repo, String refName, ObjectId objectId) {
        this.db = repo;
        this.refName = refName;
        this.objectId = objectId;
    }

    public String getContent() {
        return this.refName;
    }

    public int getCursorPosition() {
        return this.refName.length();
    }

    public String getDescription() {
        Object obj;
        if (this.objectId == null) {
            return null;
        }
        try {
            obj = this.db.mapObject(this.objectId, this.refName);
        }
        catch (IOException e) {
            Activator.logError("Unable to read object " + this.objectId + " for content proposal assistance", e);
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.refName);
        sb.append('\n');
        sb.append(this.objectId.abbreviate(this.db).name());
        sb.append(" - ");
        if (obj instanceof Commit) {
            Commit c = (Commit)obj;
            RefContentProposal.appendObjectSummary(sb, "commit", c.getAuthor(), c.getMessage());
        } else if (obj instanceof Tag) {
            Tag t = (Tag)obj;
            RefContentProposal.appendObjectSummary(sb, "tag", t.getAuthor(), t.getMessage());
        } else if (obj instanceof Tree) {
            sb.append("tree");
        } else if (obj instanceof Blob) {
            sb.append("blob");
        } else {
            sb.append("locally unknown object");
        }
        return sb.toString();
    }

    public String getLabel() {
        int i = 0;
        while (i < PREFIXES.length) {
            if (this.refName.startsWith(PREFIXES[i])) {
                return String.valueOf(this.refName.substring(PREFIXES[i].length())) + PREFIXES_DESCRIPTIONS[i];
            }
            ++i;
        }
        return this.refName;
    }
}

