/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.BaseWizardPage;
import org.eclipse.egit.ui.internal.components.RefSpecPanel;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.components.SelectionChangeListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefSpecPage
extends BaseWizardPage {
    private final Repository local;
    private final RepositorySelectionPage repoPage;
    private final boolean pushPage;
    private RepositorySelection validatedRepoSelection;
    private RefSpecPanel specsPanel;
    private Button saveButton;
    private Button tagsAutoFollowButton;
    private Button tagsFetchTagsButton;
    private Button tagsNoTagsButton;
    private String transportError;

    public RefSpecPage(Repository local, boolean pushPage, final RepositorySelectionPage repoPage) {
        super(RefSpecPage.class.getName());
        this.local = local;
        this.repoPage = repoPage;
        this.pushPage = pushPage;
        if (pushPage) {
            this.setTitle(UIText.RefSpecPage_titlePush);
            this.setDescription(UIText.RefSpecPage_descriptionPush);
        } else {
            this.setTitle(UIText.RefSpecPage_titleFetch);
            this.setDescription(UIText.RefSpecPage_descriptionFetch);
        }
        repoPage.addSelectionListener(new SelectionChangeListener(){

            public void selectionChanged() {
                if (!repoPage.selectionEquals(RefSpecPage.this.validatedRepoSelection)) {
                    RefSpecPage.this.setPageComplete(false);
                } else {
                    RefSpecPage.this.checkPage();
                }
            }
        });
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        this.specsPanel = new RefSpecPanel(panel, this.pushPage);
        this.specsPanel.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.specsPanel.addRefSpecTableListener(new SelectionChangeListener(){

            public void selectionChanged() {
                RefSpecPage.this.notifySelectionChanged();
                RefSpecPage.this.checkPage();
            }
        });
        SelectionAdapter changesNotifier = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpecPage.this.notifySelectionChanged();
            }
        };
        if (!this.pushPage) {
            Group tagsGroup = new Group(panel, 0);
            tagsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            tagsGroup.setText(UIText.RefSpecPage_annotatedTagsGroup);
            tagsGroup.setLayout((Layout)new GridLayout());
            this.tagsAutoFollowButton = new Button((Composite)tagsGroup, 16);
            this.tagsAutoFollowButton.setText(UIText.RefSpecPage_annotatedTagsAutoFollow);
            this.tagsFetchTagsButton = new Button((Composite)tagsGroup, 16);
            this.tagsFetchTagsButton.setText(UIText.RefSpecPage_annotatedTagsFetchTags);
            this.tagsNoTagsButton = new Button((Composite)tagsGroup, 16);
            this.tagsNoTagsButton.setText(UIText.RefSpecPage_annotatedTagsNoTags);
            this.tagsAutoFollowButton.addSelectionListener((SelectionListener)changesNotifier);
            this.tagsFetchTagsButton.addSelectionListener((SelectionListener)changesNotifier);
            this.tagsNoTagsButton.addSelectionListener((SelectionListener)changesNotifier);
        }
        this.saveButton = new Button(panel, 32);
        this.saveButton.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.saveButton.addSelectionListener((SelectionListener)changesNotifier);
        this.setControl((Control)panel);
        this.notifySelectionChanged();
        this.checkPage();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.revalidate();
        }
        super.setVisible(visible);
    }

    public List<RefSpec> getRefSpecs() {
        if (this.specsPanel == null) {
            return Collections.emptyList();
        }
        return new ArrayList<RefSpec>(this.specsPanel.getRefSpecs());
    }

    public boolean isSaveRequested() {
        return this.saveButton.getSelection();
    }

    public TagOpt getTagOpt() {
        if (this.tagsAutoFollowButton.getSelection()) {
            return TagOpt.AUTO_FOLLOW;
        }
        if (this.tagsFetchTagsButton.getSelection()) {
            return TagOpt.FETCH_TAGS;
        }
        return TagOpt.NO_TAGS;
    }

    public boolean specsSelectionEquals(List<RefSpec> specs) {
        return this.getRefSpecs().equals(specs);
    }

    private void revalidate() {
        final RepositorySelection newRepoSelection = this.repoPage.getSelection();
        if (this.repoPage.selectionEquals(this.validatedRepoSelection)) {
            this.checkPage();
            return;
        }
        this.specsPanel.clearRefSpecs();
        this.specsPanel.setEnable(false);
        this.saveButton.setVisible(false);
        this.saveButton.setSelection(false);
        this.notifySelectionChanged();
        this.validatedRepoSelection = null;
        this.transportError = null;
        this.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                RefSpecPage.this.revalidateImpl(newRepoSelection);
            }
        });
    }

    private void revalidateImpl(RepositorySelection newRepoSelection) {
        ListRemoteOperation listRemotesOp;
        try {
            URIish uri = newRepoSelection.getURI();
            listRemotesOp = new ListRemoteOperation(this.local, uri);
            this.getContainer().run(true, true, (IRunnableWithProgress)listRemotesOp);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.transportError(cause.getMessage());
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.RefSpecPage_errorTransportDialogTitle, (String)UIText.RefSpecPage_errorTransportDialogMessage, (IStatus)new Status(4, Activator.getPluginId(), 0, cause.getMessage(), cause));
            return;
        }
        catch (InterruptedException interruptedException) {
            this.transportError(UIText.RefSpecPage_operationCancelled);
            return;
        }
        this.validatedRepoSelection = newRepoSelection;
        String remoteName = this.validatedRepoSelection.getConfigName();
        this.specsPanel.setAssistanceData(this.local, listRemotesOp.getRemoteRefs(), remoteName);
        this.tagsAutoFollowButton.setSelection(false);
        this.tagsFetchTagsButton.setSelection(false);
        this.tagsNoTagsButton.setSelection(false);
        if (newRepoSelection.isConfigSelected()) {
            this.saveButton.setVisible(true);
            this.saveButton.setText(NLS.bind((String)UIText.RefSpecPage_saveSpecifications, (Object)remoteName));
            this.saveButton.getParent().layout();
            TagOpt tagOpt = newRepoSelection.getConfig().getTagOpt();
            switch (tagOpt) {
                case AUTO_FOLLOW: {
                    this.tagsAutoFollowButton.setSelection(true);
                    break;
                }
                case FETCH_TAGS: {
                    this.tagsFetchTagsButton.setSelection(true);
                    break;
                }
                case NO_TAGS: {
                    this.tagsNoTagsButton.setSelection(true);
                }
            }
        } else {
            this.tagsAutoFollowButton.setSelection(true);
        }
        this.checkPage();
    }

    private void transportError(String message) {
        this.transportError = message;
        this.checkPage();
    }

    private void checkPage() {
        if (this.transportError != null) {
            this.setErrorMessage(this.transportError);
            this.setPageComplete(false);
            return;
        }
        if (!this.specsPanel.isEmpty() && this.specsPanel.isValid() && !this.specsPanel.isMatchingAnyRefs()) {
            this.setErrorMessage(UIText.RefSpecPage_errorDontMatchSrc);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(this.specsPanel.getErrorMessage());
        this.setPageComplete(!this.specsPanel.isEmpty() && this.specsPanel.isValid());
    }
}

