/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySelection {
    private URIish uri;
    private RemoteConfig config;
    static final RepositorySelection INVALID_SELECTION = new RepositorySelection(null, null);

    RepositorySelection(URIish uri, RemoteConfig config) {
        if (config != null && uri != null) {
            throw new IllegalArgumentException("URI and config cannot be set at the same time.");
        }
        this.config = config;
        this.uri = uri;
    }

    public URIish getURI() {
        if (this.isConfigSelected()) {
            return (URIish)this.config.getURIs().get(0);
        }
        return this.uri;
    }

    public List<URIish> getAllURIs() {
        if (this.isURISelected()) {
            return Collections.singletonList(this.uri);
        }
        if (this.isConfigSelected()) {
            return this.config.getURIs();
        }
        return null;
    }

    public RemoteConfig getConfig() {
        return this.config;
    }

    public String getConfigName() {
        if (this.isConfigSelected()) {
            return this.config.getName();
        }
        return null;
    }

    public boolean isValidSelection() {
        return this.uri != null || this.config != null;
    }

    public boolean isURISelected() {
        return this.uri != null;
    }

    public boolean isConfigSelected() {
        return this.config != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RepositorySelection) {
            RepositorySelection other = (RepositorySelection)obj;
            if (this.uri == null ^ other.uri == null) {
                return false;
            }
            if (this.uri != null && !this.uri.equals((Object)other.uri)) {
                return false;
            }
            return this.config == other.config;
        }
        return false;
    }
}

