/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.BaseWizardPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySelectionPage
extends BaseWizardPage {
    private static final int REMOTE_CONFIG_TEXT_MAX_LENGTH = 80;
    private static final int S_GIT = 0;
    private static final int S_SSH = 1;
    private static final int S_SFTP = 2;
    private static final int S_HTTP = 3;
    private static final int S_HTTPS = 4;
    private static final int S_FTP = 5;
    private static final int S_FILE = 6;
    private static final String[] DEFAULT_SCHEMES = new String[7];
    private final List<RemoteConfig> configuredRemotes;
    private Group authGroup;
    private Text uriText;
    private Text hostText;
    private Text pathText;
    private Text userText;
    private Text passText;
    private Combo scheme;
    private Text portText;
    private int eventDepth;
    private URIish uri = new URIish();
    private RemoteConfig remoteConfig;
    private RepositorySelection selection;
    private Composite remotePanel;
    private Button remoteButton;
    private Combo remoteCombo;
    private Composite uriPanel;
    private Button uriButton;

    static {
        RepositorySelectionPage.DEFAULT_SCHEMES[0] = "git";
        RepositorySelectionPage.DEFAULT_SCHEMES[1] = "git+ssh";
        RepositorySelectionPage.DEFAULT_SCHEMES[2] = "sftp";
        RepositorySelectionPage.DEFAULT_SCHEMES[3] = "http";
        RepositorySelectionPage.DEFAULT_SCHEMES[4] = "https";
        RepositorySelectionPage.DEFAULT_SCHEMES[5] = "ftp";
        RepositorySelectionPage.DEFAULT_SCHEMES[6] = "file";
    }

    private static void setEnabledRecursively(Control control, boolean enable) {
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                RepositorySelectionPage.setEnabledRecursively(child, enable);
                ++n2;
            }
        }
    }

    public RepositorySelectionPage(boolean sourceSelection, List<RemoteConfig> configuredRemotes) {
        super(RepositorySelectionPage.class.getName());
        if (configuredRemotes != null) {
            RepositorySelectionPage.removeUnusableRemoteConfigs(configuredRemotes);
        }
        if (configuredRemotes == null || configuredRemotes.isEmpty()) {
            this.configuredRemotes = null;
        } else {
            this.configuredRemotes = configuredRemotes;
            this.remoteConfig = this.selectDefaultRemoteConfig();
        }
        this.selection = RepositorySelection.INVALID_SELECTION;
        if (sourceSelection) {
            this.setTitle(UIText.RepositorySelectionPage_sourceSelectionTitle);
            this.setDescription(UIText.RepositorySelectionPage_sourceSelectionDescription);
        } else {
            this.setTitle(UIText.RepositorySelectionPage_destinationSelectionTitle);
            this.setDescription(UIText.RepositorySelectionPage_destinationSelectionDescription);
        }
    }

    public RepositorySelectionPage(boolean sourceSelection) {
        this(sourceSelection, null);
    }

    public RepositorySelection getSelection() {
        return this.selection;
    }

    public boolean selectionEquals(RepositorySelection s) {
        return this.selection.equals(s);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        if (this.configuredRemotes != null) {
            this.createRemotePanel(panel);
        }
        this.createUriPanel(panel);
        this.updateRemoteAndURIPanels();
        this.setControl((Control)panel);
        this.checkPage();
    }

    private void createRemotePanel(Composite parent) {
        this.remoteButton = new Button(parent, 16);
        this.remoteButton.setText(String.valueOf(UIText.RepositorySelectionPage_configuredRemoteChoice) + ":");
        this.remoteButton.setSelection(true);
        this.remotePanel = new Composite(parent, 0);
        this.remotePanel.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.remotePanel.setLayoutData((Object)gd);
        this.remoteCombo = new Combo(this.remotePanel, 12);
        String[] items = new String[this.configuredRemotes.size()];
        int i = 0;
        for (RemoteConfig rc : this.configuredRemotes) {
            items[i++] = RepositorySelectionPage.getTextForRemoteConfig(rc);
        }
        int defaultIndex = this.configuredRemotes.indexOf(this.remoteConfig);
        this.remoteCombo.setItems(items);
        this.remoteCombo.select(defaultIndex);
        this.remoteCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = RepositorySelectionPage.this.remoteCombo.getSelectionIndex();
                RepositorySelectionPage.this.remoteConfig = (RemoteConfig)RepositorySelectionPage.this.configuredRemotes.get(idx);
                RepositorySelectionPage.this.checkPage();
            }
        });
    }

    private void createUriPanel(Composite parent) {
        if (this.configuredRemotes != null) {
            this.uriButton = new Button(parent, 16);
            this.uriButton.setText(String.valueOf(UIText.RepositorySelectionPage_uriChoice) + ":");
            this.uriButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositorySelectionPage.this.updateRemoteAndURIPanels();
                    RepositorySelectionPage.this.checkPage();
                }
            });
        }
        this.uriPanel = new Composite(parent, 0);
        this.uriPanel.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.uriPanel.setLayoutData((Object)gd);
        this.createLocationGroup(this.uriPanel);
        this.createConnectionGroup(this.uriPanel);
        this.authGroup = this.createAuthenticationGroup(this.uriPanel);
    }

    private void createLocationGroup(Composite parent) {
        Group g = RepositorySelectionPage.createGroup(parent, UIText.RepositorySelectionPage_groupLocation);
        g.setLayout((Layout)new GridLayout(3, false));
        RepositorySelectionPage.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptURI) + ":");
        this.uriText = new Text((Composite)g, 2048);
        this.uriText.setLayoutData((Object)RepositorySelectionPage.createFieldGridData());
        this.uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                block13: {
                    RepositorySelectionPage repositorySelectionPage = RepositorySelectionPage.this;
                    repositorySelectionPage.eventDepth = repositorySelectionPage.eventDepth + 1;
                    if (RepositorySelectionPage.this.eventDepth == 1) break block13;
                    RepositorySelectionPage repositorySelectionPage2 = RepositorySelectionPage.this;
                    repositorySelectionPage2.eventDepth = repositorySelectionPage2.eventDepth - 1;
                    return;
                }
                try {
                    try {
                        URIish u = new URIish(RepositorySelectionPage.this.uriText.getText());
                        RepositorySelectionPage.safeSet(RepositorySelectionPage.this.hostText, u.getHost());
                        RepositorySelectionPage.safeSet(RepositorySelectionPage.this.pathText, u.getPath());
                        RepositorySelectionPage.safeSet(RepositorySelectionPage.this.userText, u.getUser());
                        RepositorySelectionPage.safeSet(RepositorySelectionPage.this.passText, u.getPass());
                        if (u.getPort() > 0) {
                            RepositorySelectionPage.this.portText.setText(Integer.toString(u.getPort()));
                        } else {
                            RepositorySelectionPage.this.portText.setText("");
                        }
                        if (RepositorySelectionPage.isFile(u)) {
                            RepositorySelectionPage.this.scheme.select(6);
                        } else if (RepositorySelectionPage.isSSH(u)) {
                            RepositorySelectionPage.this.scheme.select(1);
                        } else {
                            int i = 0;
                            while (i < DEFAULT_SCHEMES.length) {
                                if (DEFAULT_SCHEMES[i].equals(u.getScheme())) {
                                    RepositorySelectionPage.this.scheme.select(i);
                                    break;
                                }
                                ++i;
                            }
                        }
                        RepositorySelectionPage.this.updateAuthGroup();
                        RepositorySelectionPage.this.uri = u;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        RepositorySelectionPage.this.uri = new URIish();
                        RepositorySelectionPage.this.hostText.setText("");
                        RepositorySelectionPage.this.pathText.setText("");
                        RepositorySelectionPage.this.userText.setText("");
                        RepositorySelectionPage.this.passText.setText("");
                        RepositorySelectionPage.this.portText.setText("");
                        RepositorySelectionPage.this.scheme.select(0);
                        RepositorySelectionPage repositorySelectionPage = RepositorySelectionPage.this;
                        repositorySelectionPage.eventDepth = repositorySelectionPage.eventDepth - 1;
                    }
                }
                catch (Throwable throwable) {
                    RepositorySelectionPage repositorySelectionPage = RepositorySelectionPage.this;
                    repositorySelectionPage.eventDepth = repositorySelectionPage.eventDepth - 1;
                    throw throwable;
                }
                RepositorySelectionPage repositorySelectionPage = RepositorySelectionPage.this;
                repositorySelectionPage.eventDepth = repositorySelectionPage.eventDepth - 1;
                RepositorySelectionPage.this.checkPage();
            }
        });
        Button browseButton = new Button((Composite)g, 0);
        browseButton.setText(UIText.RepositorySelectionPage_BrowseLocalFile);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result;
                DirectoryDialog dialog = new DirectoryDialog(RepositorySelectionPage.this.getShell());
                if (!RepositorySelectionPage.this.uriText.getText().equals("")) {
                    try {
                        URI testUri = URI.create(RepositorySelectionPage.this.uriText.getText().replace('\\', '/'));
                        if (testUri.getScheme().equals("file")) {
                            String path = testUri.getPath();
                            if (path.length() > 1 && path.startsWith("/")) {
                                path = path.substring(1);
                            }
                            dialog.setFilterPath(path);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if ((result = dialog.open()) != null) {
                    RepositorySelectionPage.this.uriText.setText("file:///" + result);
                }
            }
        });
        RepositorySelectionPage.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptHost) + ":");
        this.hostText = new Text((Composite)g, 2048);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.hostText);
        this.hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setHost(RepositorySelectionPage.nullString(RepositorySelectionPage.this.hostText.getText())));
            }
        });
        RepositorySelectionPage.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptPath) + ":");
        this.pathText = new Text((Composite)g, 2048);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.pathText);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setPath(RepositorySelectionPage.nullString(RepositorySelectionPage.this.pathText.getText())));
            }
        });
    }

    private Group createAuthenticationGroup(Composite parent) {
        Group g = RepositorySelectionPage.createGroup(parent, UIText.RepositorySelectionPage_groupAuthentication);
        RepositorySelectionPage.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptUser) + ":");
        this.userText = new Text((Composite)g, 2048);
        this.userText.setLayoutData((Object)RepositorySelectionPage.createFieldGridData());
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setUser(RepositorySelectionPage.nullString(RepositorySelectionPage.this.userText.getText())));
            }
        });
        RepositorySelectionPage.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptPassword) + ":");
        this.passText = new Text((Composite)g, 0x400800);
        this.passText.setLayoutData((Object)RepositorySelectionPage.createFieldGridData());
        return g;
    }

    private void createConnectionGroup(Composite parent) {
        Group g = RepositorySelectionPage.createGroup(parent, UIText.RepositorySelectionPage_groupConnection);
        RepositorySelectionPage.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptScheme) + ":");
        this.scheme = new Combo((Composite)g, 12);
        this.scheme.setItems(DEFAULT_SCHEMES);
        this.scheme.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = RepositorySelectionPage.this.scheme.getSelectionIndex();
                if (idx < 0) {
                    RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setScheme(null));
                } else {
                    RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setScheme(RepositorySelectionPage.nullString(RepositorySelectionPage.this.scheme.getItem(idx))));
                }
                RepositorySelectionPage.this.updateAuthGroup();
            }
        });
        RepositorySelectionPage.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptPort) + ":");
        this.portText = new Text((Composite)g, 2048);
        this.portText.addVerifyListener(new VerifyListener(){
            final Pattern p = Pattern.compile("^(?:[1-9][0-9]*)?$");

            public void verifyText(VerifyEvent e) {
                String v = RepositorySelectionPage.this.portText.getText();
                e.doit = this.p.matcher(String.valueOf(v.substring(0, e.start)) + e.text + v.substring(e.end)).matches();
            }
        });
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String val = RepositorySelectionPage.nullString(RepositorySelectionPage.this.portText.getText());
                if (val == null) {
                    RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setPort(-1));
                } else {
                    try {
                        RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setPort(Integer.parseInt(val)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        });
    }

    private static Group createGroup(Composite parent, String text) {
        Group g = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        g.setLayout((Layout)layout);
        g.setText(text);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static void newLabel(Group g, String text) {
        new Label((Composite)g, 0).setText(text);
    }

    private static GridData createFieldGridData() {
        return new GridData(4, -1, true, false);
    }

    private static boolean isGIT(URIish uri) {
        return "git".equals(uri.getScheme());
    }

    private static boolean isFile(URIish uri) {
        if ("file".equals(uri.getScheme()) || uri.getScheme() == null) {
            return true;
        }
        if (uri.getHost() != null || uri.getPort() > 0 || uri.getUser() != null || uri.getPass() != null || uri.getPath() == null) {
            return false;
        }
        if (uri.getScheme() == null) {
            return FS.resolve((File)new File("."), (String)uri.getPath()).isDirectory();
        }
        return false;
    }

    private static boolean isSSH(URIish uri) {
        if (!uri.isRemote()) {
            return false;
        }
        String scheme = uri.getScheme();
        if ("ssh".equals(scheme)) {
            return true;
        }
        if ("ssh+git".equals(scheme)) {
            return true;
        }
        if ("git+ssh".equals(scheme)) {
            return true;
        }
        return scheme == null && uri.getHost() != null && uri.getPath() != null;
    }

    private static String nullString(String value) {
        if (value == null) {
            return null;
        }
        String v = value.trim();
        return v.length() == 0 ? null : v;
    }

    private static void safeSet(Text text, String value) {
        text.setText(value != null ? value : "");
    }

    private boolean isURISelected() {
        return this.configuredRemotes == null || this.uriButton.getSelection();
    }

    private void setURI(URIish u) {
        try {
            ++this.eventDepth;
            if (this.eventDepth == 1) {
                this.uri = u;
                this.uriText.setText(this.uri.toString());
                this.checkPage();
            }
        }
        finally {
            --this.eventDepth;
        }
    }

    private static void removeUnusableRemoteConfigs(List<RemoteConfig> remotes) {
        Iterator<RemoteConfig> iter = remotes.iterator();
        while (iter.hasNext()) {
            RemoteConfig rc = iter.next();
            if (!rc.getURIs().isEmpty()) continue;
            iter.remove();
        }
    }

    private RemoteConfig selectDefaultRemoteConfig() {
        for (RemoteConfig rc : this.configuredRemotes) {
            if (!"origin".equals(RepositorySelectionPage.getTextForRemoteConfig(rc))) continue;
            return rc;
        }
        return this.configuredRemotes.get(0);
    }

    private static String getTextForRemoteConfig(RemoteConfig rc) {
        StringBuilder sb = new StringBuilder(rc.getName());
        sb.append(": ");
        boolean first = true;
        for (URIish u : rc.getURIs()) {
            String uString = u.toString();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
                if (sb.length() + uString.length() > 80) {
                    sb.append("...");
                    break;
                }
            }
            sb.append(uString);
        }
        return sb.toString();
    }

    private void checkPage() {
        if (this.isURISelected()) {
            assert (this.uri != null);
            if (this.uriText.getText().length() == 0) {
                this.selectionIncomplete(null);
                return;
            }
            try {
                URIish finalURI = new URIish(this.uriText.getText());
                String proto = finalURI.getScheme();
                if (proto == null && this.scheme.getSelectionIndex() >= 0) {
                    proto = this.scheme.getItem(this.scheme.getSelectionIndex());
                }
                if (this.uri.getPath() == null) {
                    this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldRequired, (Object)this.unamp(UIText.RepositorySelectionPage_promptPath), (Object)proto));
                    return;
                }
                if (RepositorySelectionPage.isFile(finalURI)) {
                    String badField = null;
                    if (this.uri.getHost() != null) {
                        badField = UIText.RepositorySelectionPage_promptHost;
                    } else if (this.uri.getUser() != null) {
                        badField = UIText.RepositorySelectionPage_promptUser;
                    } else if (this.uri.getPass() != null) {
                        badField = UIText.RepositorySelectionPage_promptPassword;
                    }
                    if (badField != null) {
                        this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldNotSupported, (Object)this.unamp(badField), (Object)proto));
                        return;
                    }
                    File d = FS.resolve((File)new File("."), (String)this.uri.getPath());
                    if (!d.exists()) {
                        this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fileNotFound, (Object)d.getAbsolutePath()));
                        return;
                    }
                    this.selectionComplete(finalURI, null);
                    return;
                }
                if (this.uri.getHost() == null) {
                    this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldRequired, (Object)this.unamp(UIText.RepositorySelectionPage_promptHost), (Object)proto));
                    return;
                }
                if (RepositorySelectionPage.isGIT(finalURI)) {
                    String badField = null;
                    if (this.uri.getUser() != null) {
                        badField = UIText.RepositorySelectionPage_promptUser;
                    } else if (this.uri.getPass() != null) {
                        badField = UIText.RepositorySelectionPage_promptPassword;
                    }
                    if (badField != null) {
                        this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldNotSupported, (Object)this.unamp(badField), (Object)proto));
                        return;
                    }
                }
                this.selectionComplete(finalURI, null);
                return;
            }
            catch (URISyntaxException e) {
                this.selectionIncomplete(e.getReason());
                return;
            }
            catch (Exception e) {
                Activator.logError("Error validating " + ((Object)((Object)this)).getClass().getName(), e);
                this.selectionIncomplete(UIText.RepositorySelectionPage_internalError);
                return;
            }
        }
        assert (this.remoteButton.getSelection());
        this.selectionComplete(null, this.remoteConfig);
    }

    private String unamp(String s) {
        return s.replace("&", "");
    }

    private void selectionIncomplete(String errorMessage) {
        this.setExposedSelection(null, null);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(false);
    }

    private void selectionComplete(URIish u, RemoteConfig rc) {
        this.setExposedSelection(u, rc);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void setExposedSelection(URIish u, RemoteConfig rc) {
        RepositorySelection newSelection = new RepositorySelection(u, rc);
        if (newSelection.equals(this.selection)) {
            return;
        }
        this.selection = newSelection;
        this.notifySelectionChanged();
    }

    private void updateRemoteAndURIPanels() {
        RepositorySelectionPage.setEnabledRecursively((Control)this.uriPanel, this.isURISelected());
        if (this.uriPanel.getEnabled()) {
            this.updateAuthGroup();
        }
        if (this.configuredRemotes != null) {
            RepositorySelectionPage.setEnabledRecursively((Control)this.remotePanel, !this.isURISelected());
        }
    }

    private void updateAuthGroup() {
        switch (this.scheme.getSelectionIndex()) {
            case 0: {
                this.hostText.setEnabled(true);
                this.portText.setEnabled(true);
                RepositorySelectionPage.setEnabledRecursively((Control)this.authGroup, false);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.hostText.setEnabled(true);
                this.portText.setEnabled(true);
                RepositorySelectionPage.setEnabledRecursively((Control)this.authGroup, true);
                break;
            }
            case 6: {
                this.hostText.setEnabled(false);
                this.portText.setEnabled(false);
                RepositorySelectionPage.setEnabledRecursively((Control)this.authGroup, false);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.uriText.setFocus();
        }
    }
}

