/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.egit.core.ContainerTreeIterator;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.decorators.IDecoratableResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.team.core.Team;

class DecoratableResourceAdapter
implements IDecoratableResource {
    private final IResource resource;
    private final RepositoryMapping mapping;
    private final Repository repository;
    private final ObjectId headId;
    private final IPreferenceStore store;
    private String branch = "";
    private boolean tracked = false;
    private boolean ignored = false;
    private boolean dirty = false;
    private boolean conflicts = false;
    private boolean assumeValid = false;
    private IDecoratableResource.Staged staged = IDecoratableResource.Staged.NOT_STAGED;
    static final int T_HEAD = 0;
    static final int T_INDEX = 1;
    static final int T_WORKSPACE = 2;

    public DecoratableResourceAdapter(IResource resourceToWrap) throws IOException {
        this.resource = resourceToWrap;
        this.mapping = RepositoryMapping.getMapping((IResource)this.resource);
        this.repository = this.mapping.getRepository();
        this.headId = this.repository.resolve("HEAD");
        this.store = Activator.getDefault().getPreferenceStore();
        this.branch = this.repository.getBranch();
        TreeWalk treeWalk = this.createThreeWayTreeWalk();
        if (treeWalk == null) {
            return;
        }
        switch (this.resource.getType()) {
            case 1: {
                if (!treeWalk.next()) {
                    return;
                }
                this.extractResourceProperties(treeWalk);
                break;
            }
            case 4: {
                this.tracked = true;
            }
            case 2: {
                this.extractContainerProperties(treeWalk);
            }
        }
    }

    private void extractResourceProperties(TreeWalk treeWalk) {
        DirCacheEntry indexEntry;
        ContainerTreeIterator.ResourceEntry resourceEntry;
        ContainerTreeIterator workspaceIterator = (ContainerTreeIterator)treeWalk.getTree(2, ContainerTreeIterator.class);
        ContainerTreeIterator.ResourceEntry resourceEntry2 = resourceEntry = workspaceIterator != null ? workspaceIterator.getResourceEntry() : null;
        if (resourceEntry == null) {
            return;
        }
        if (DecoratableResourceAdapter.isIgnored(resourceEntry.getResource())) {
            this.ignored = true;
            return;
        }
        int mHead = treeWalk.getRawMode(0);
        int mIndex = treeWalk.getRawMode(1);
        if (mHead == FileMode.MISSING.getBits() && mIndex == FileMode.MISSING.getBits()) {
            return;
        }
        this.tracked = true;
        this.staged = mHead == FileMode.MISSING.getBits() ? IDecoratableResource.Staged.ADDED : (mIndex == FileMode.MISSING.getBits() ? IDecoratableResource.Staged.REMOVED : (mHead != mIndex || mIndex != FileMode.TREE.getBits() && !treeWalk.idEqual(0, 1) ? IDecoratableResource.Staged.MODIFIED : IDecoratableResource.Staged.NOT_STAGED));
        DirCacheIterator indexIterator = (DirCacheIterator)treeWalk.getTree(1, DirCacheIterator.class);
        DirCacheEntry dirCacheEntry = indexEntry = indexIterator != null ? indexIterator.getDirCacheEntry() : null;
        if (indexEntry == null) {
            return;
        }
        if (indexEntry.getStage() > 0) {
            this.conflicts = true;
        }
        if (indexEntry.isAssumeValid()) {
            this.dirty = false;
            this.assumeValid = true;
        } else if (!DecoratableResourceAdapter.timestampMatches(indexEntry, resourceEntry)) {
            this.dirty = true;
        }
    }

    private void extractContainerProperties(TreeWalk treeWalk) throws IOException {
        if (DecoratableResourceAdapter.isIgnored(this.resource)) {
            this.ignored = true;
            return;
        }
        treeWalk.setFilter(AndTreeFilter.create((TreeFilter)treeWalk.getFilter(), (TreeFilter)new RecursiveStateFilter()));
        treeWalk.setRecursive(true);
        treeWalk.next();
    }

    private boolean addResourceFilter(TreeWalk treeWalk, IResource resourceToFilterBy) {
        Set<String> repositoryPaths = Collections.singleton(this.mapping.getRepoRelativePath(resourceToFilterBy));
        if (repositoryPaths.isEmpty()) {
            return false;
        }
        if (repositoryPaths.contains("")) {
            return true;
        }
        treeWalk.setFilter(PathFilterGroup.createFromStrings(repositoryPaths));
        return true;
    }

    private TreeWalk createThreeWayTreeWalk() throws IOException {
        TreeWalk treeWalk = new TreeWalk(this.repository);
        if (!this.addResourceFilter(treeWalk, this.resource)) {
            return null;
        }
        treeWalk.setRecursive(treeWalk.getFilter().shouldBeRecursive());
        treeWalk.reset();
        if (this.headId != null) {
            treeWalk.addTree((ObjectId)new RevWalk(this.repository).parseTree((AnyObjectId)this.headId));
        } else {
            treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
        }
        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(DirCache.read((Repository)this.repository)));
        IProject project = this.resource.getProject();
        IWorkspaceRoot workspaceRoot = this.resource.getWorkspace().getRoot();
        File repoRoot = this.repository.getWorkDir();
        if (repoRoot.equals(project.getLocation().toFile())) {
            treeWalk.addTree((AbstractTreeIterator)new ContainerTreeIterator((IContainer)project));
        } else if (repoRoot.equals(workspaceRoot.getLocation().toFile())) {
            treeWalk.addTree((AbstractTreeIterator)new ContainerTreeIterator(workspaceRoot));
        } else {
            treeWalk.addTree((AbstractTreeIterator)new AdaptableFileTreeIterator(repoRoot, workspaceRoot));
        }
        return treeWalk;
    }

    private static boolean timestampMatches(DirCacheEntry indexEntry, ContainerTreeIterator.ResourceEntry resourceEntry) {
        long tIndex = indexEntry.getLastModified();
        long tWorkspaceResource = resourceEntry.getLastModified();
        if (tIndex % 1000L == 0L || tWorkspaceResource % 1000L == 0L) {
            return tIndex / 1000L == tWorkspaceResource / 1000L;
        }
        return tIndex == tWorkspaceResource;
    }

    private static boolean isIgnored(IResource resource) {
        return Team.isIgnoredHint((IResource)resource);
    }

    public String getName() {
        return this.resource.getName();
    }

    public int getType() {
        return this.resource.getType();
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isTracked() {
        return this.tracked;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public IDecoratableResource.Staged staged() {
        return this.staged;
    }

    public boolean hasConflicts() {
        return this.conflicts;
    }

    public boolean isAssumeValid() {
        return this.assumeValid;
    }

    private class RecursiveStateFilter
    extends TreeFilter {
        private int filesChecked = 0;
        private int targetDepth = -1;
        private final int recurseLimit;

        public RecursiveStateFilter() {
            this.recurseLimit = DecoratableResourceAdapter.this.store.getInt("decorator_recursive_limit");
        }

        public boolean include(TreeWalk treeWalk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            if (treeWalk.getFileMode(0) == FileMode.MISSING && treeWalk.getFileMode(1) == FileMode.MISSING) {
                return false;
            }
            if (FileMode.TREE.equals(treeWalk.getRawMode(2))) {
                return this.shouldRecurse(treeWalk);
            }
            IDecoratableResource.Staged wasStaged = DecoratableResourceAdapter.this.staged;
            boolean wasDirty = DecoratableResourceAdapter.this.dirty;
            boolean hadConflicts = DecoratableResourceAdapter.this.conflicts;
            DecoratableResourceAdapter.this.extractResourceProperties(treeWalk);
            ++this.filesChecked;
            DecoratableResourceAdapter.this.ignored = false;
            DecoratableResourceAdapter.this.assumeValid = false;
            DecoratableResourceAdapter.this.dirty = wasDirty || DecoratableResourceAdapter.this.dirty;
            DecoratableResourceAdapter.this.conflicts = hadConflicts || DecoratableResourceAdapter.this.conflicts;
            if (DecoratableResourceAdapter.this.staged != wasStaged && this.filesChecked > 1) {
                DecoratableResourceAdapter.this.staged = IDecoratableResource.Staged.MODIFIED;
            }
            return false;
        }

        private boolean shouldRecurse(TreeWalk treeWalk) {
            WorkingTreeIterator workspaceIterator = (WorkingTreeIterator)treeWalk.getTree(2, WorkingTreeIterator.class);
            if (workspaceIterator instanceof AdaptableFileTreeIterator) {
                return true;
            }
            ContainerTreeIterator.ResourceEntry resourceEntry = null;
            if (workspaceIterator != null) {
                resourceEntry = ((ContainerTreeIterator)workspaceIterator).getResourceEntry();
            }
            if (resourceEntry == null) {
                return true;
            }
            IResource visitingResource = resourceEntry.getResource();
            if (this.targetDepth == -1) {
                if (visitingResource.equals((Object)DecoratableResourceAdapter.this.resource) || visitingResource.getParent().equals((Object)DecoratableResourceAdapter.this.resource)) {
                    this.targetDepth = treeWalk.getDepth();
                } else {
                    return true;
                }
            }
            if (treeWalk.getDepth() - this.targetDepth >= this.recurseLimit) {
                if (visitingResource.equals((Object)DecoratableResourceAdapter.this.resource)) {
                    DecoratableResourceAdapter.this.extractResourceProperties(treeWalk);
                }
                return false;
            }
            return true;
        }

        public TreeFilter clone() {
            RecursiveStateFilter clone = new RecursiveStateFilter();
            clone.filesChecked = this.filesChecked;
            return clone;
        }

        public boolean shouldBeRecursive() {
            return true;
        }
    }
}

