/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.IndexChangedEvent;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.RefsChangedEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryListener;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.team.core.RepositoryProvider;

class GitDocument
extends Document
implements RepositoryListener {
    private final IResource resource;
    private ObjectId lastCommit;
    private ObjectId lastTree;
    private ObjectId lastBlob;
    static Map<GitDocument, Repository> doc2repo = new WeakHashMap<GitDocument, Repository>();

    static GitDocument create(IResource resource) throws IOException {
        Activator.trace("(GitDocument) create: " + resource);
        GitDocument ret = null;
        if (RepositoryProvider.getProvider((IProject)resource.getProject()) instanceof GitProvider) {
            ret = new GitDocument(resource);
            ret.populate();
            Repository repository = ret.getRepository();
            if (repository != null) {
                repository.addRepositoryChangedListener((RepositoryListener)ret);
            }
        }
        return ret;
    }

    private GitDocument(IResource resource) {
        this.resource = resource;
        doc2repo.put(this, this.getRepository());
    }

    private void setResolved(AnyObjectId commit, AnyObjectId tree, AnyObjectId blob, String value) {
        this.lastCommit = commit != null ? commit.copy() : null;
        this.lastTree = tree != null ? tree.copy() : null;
        this.lastBlob = blob != null ? blob.copy() : null;
        this.set(value);
        if (blob != null) {
            Activator.trace("(GitDocument) resolved " + this.resource + " to " + this.lastBlob + " in " + this.lastCommit + "/" + this.lastTree);
        } else {
            Activator.trace("(GitDocument) unresolved " + this.resource);
        }
    }

    void populate() throws IOException {
        ObjectId commitId;
        Activator.trace("(GitDocument) populate: " + this.resource);
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)this.resource);
        if (mapping == null) {
            this.setResolved(null, null, null, "");
            return;
        }
        String gitPath = mapping.getRepoRelativePath(this.resource);
        Repository repository = mapping.getRepository();
        String baseline = GitQuickDiffProvider.baseline.get(repository);
        if (baseline == null) {
            baseline = "HEAD";
        }
        if ((commitId = repository.resolve(baseline)) != null) {
            if (commitId.equals((AnyObjectId)this.lastCommit)) {
                Activator.trace("(GitDocument) already resolved");
                return;
            }
        } else {
            Activator.logError("Could not resolve quickdiff baseline " + baseline + " corresponding to " + this.resource + " in " + repository, new Throwable());
            this.setResolved(null, null, null, "");
            return;
        }
        Commit baselineCommit = repository.mapCommit(commitId);
        if (baselineCommit == null) {
            Activator.logError("Could not load commit " + commitId + " for " + baseline + " corresponding to " + this.resource + " in " + repository, new Throwable());
            this.setResolved(null, null, null, "");
            return;
        }
        ObjectId treeId = baselineCommit.getTreeId();
        if (treeId.equals((AnyObjectId)this.lastTree)) {
            Activator.trace("(GitDocument) already resolved");
            return;
        }
        Tree baselineTree = baselineCommit.getTree();
        if (baselineTree == null) {
            Activator.logError("Could not load tree " + treeId + " for " + baseline + " corresponding to " + this.resource + " in " + repository, new Throwable());
            this.setResolved(null, null, null, "");
            return;
        }
        TreeEntry blobEntry = baselineTree.findBlobMember(gitPath);
        if (blobEntry != null && !blobEntry.getId().equals((AnyObjectId)this.lastBlob)) {
            String charset;
            Activator.trace("(GitDocument) compareTo: " + baseline);
            ObjectLoader loader = repository.openBlob(blobEntry.getId());
            byte[] bytes = loader.getBytes();
            IEncodedStorage encodedStorage = (IEncodedStorage)this.resource;
            try {
                charset = encodedStorage != null ? encodedStorage.getCharset() : this.resource.getParent().getDefaultCharset();
            }
            catch (CoreException coreException) {
                charset = "UTF-8";
            }
            String s = new String(bytes, charset);
            this.setResolved((AnyObjectId)commitId, (AnyObjectId)baselineTree.getId(), (AnyObjectId)blobEntry.getId(), s);
            Activator.trace("(GitDocument) has reference doc, size=" + s.length() + " bytes");
        } else if (blobEntry == null) {
            this.setResolved(null, null, null, "");
        } else {
            Activator.trace("(GitDocument) already resolved");
        }
    }

    void dispose() {
        Activator.trace("(GitDocument) dispose: " + this.resource);
        doc2repo.remove((Object)this);
        Repository repository = this.getRepository();
        if (repository != null) {
            repository.removeRepositoryChangedListener((RepositoryListener)this);
        }
    }

    public void refsChanged(RefsChangedEvent e) {
        try {
            this.populate();
        }
        catch (IOException e1) {
            Activator.logError("Failed to refresh quickdiff", e1);
        }
    }

    public void indexChanged(IndexChangedEvent e) {
    }

    private Repository getRepository() {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)this.resource);
        return mapping != null ? mapping.getRepository() : null;
    }

    static void refreshRelevant(Repository repository) throws IOException {
        for (Map.Entry<GitDocument, Repository> i : doc2repo.entrySet()) {
            if (i.getValue() != repository) continue;
            i.getKey().populate();
        }
    }
}

