/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.util.ExceptionCollector;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryChangeListener;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceAdapter;
import org.eclipse.egit.ui.internal.decorators.IDecoratableResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jgit.lib.IndexChangedEvent;
import org.eclipse.jgit.lib.RefsChangedEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryChangedEvent;
import org.eclipse.jgit.lib.RepositoryListener;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class GitLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IPropertyChangeListener,
IResourceChangeListener,
RepositoryChangeListener,
RepositoryListener {
    public static final String DECORATOR_ID = "org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator";
    private static int INTERESTING_CHANGES = 323840;
    private static ExceptionCollector exceptions = new ExceptionCollector(UIText.Decorator_exceptionMessage, Activator.getPluginId(), 4, Activator.getDefault().getLog());
    private static String[] fonts = new String[]{"org.eclipse.egit.ui.UncommittedChangeFont"};
    private static String[] colors = new String[]{"org.eclipse.egit.ui.UncommittedChangeBackgroundColor", "org.eclipse.egit.ui.UncommittedChangeForegroundColor"};

    public GitLightweightDecorator() {
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this);
        Activator.addPropertyChangeListener(this);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener((IPropertyChangeListener)this);
        Repository.addAnyRepositoryChangedListener((RepositoryListener)this);
        GitProjectData.addRepositoryChangeListener((RepositoryChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.ensureFontAndColorsCreated(fonts, colors);
    }

    private void ensureFontAndColorsCreated(final String[] fonts, final String[] colors) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                int i = 0;
                while (i < colors.length) {
                    theme.getColorRegistry().get(colors[i]);
                    ++i;
                }
                i = 0;
                while (i < fonts.length) {
                    theme.getFontRegistry().get(fonts[i]);
                    ++i;
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener((IPropertyChangeListener)this);
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
        Activator.removePropertyChangeListener(this);
        Repository.removeAnyRepositoryChangedListener((RepositoryListener)this);
        GitProjectData.removeRepositoryChangeListener((RepositoryChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void decorate(Object element, IDecoration decoration) {
        IResource resource = GitLightweightDecorator.getResource(element);
        if (resource == null) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return;
        }
        if (resource.getType() == 8) {
            return;
        }
        if (!resource.exists() && !resource.isPhantom()) {
            return;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
        if (mapping == null) {
            return;
        }
        if (mapping.getRepoRelativePath(resource) == null) {
            return;
        }
        try {
            DecorationHelper helper = new DecorationHelper(activator.getPreferenceStore());
            helper.decorate(decoration, new DecoratableResourceAdapter(resource));
        }
        catch (IOException e) {
            GitLightweightDecorator.handleException(resource, new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e)));
        }
    }

    public static void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Activator.getDefault().getWorkbench().getDecoratorManager().update(GitLightweightDecorator.DECORATOR_ID);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if (prop.equals("org.eclipse.team.uiglobal_ignores_changed") || prop.equals("org.eclipse.team.uiglobal_file_types_changed") || prop.equals("org.eclipse.egit.ui.DECORATORS_CHANGED")) {
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        } else if (prop.equals("org.eclipse.egit.ui.UncommittedChangeBackgroundColor") || prop.equals("org.eclipse.egit.ui.UncommittedChangeFont") || prop.equals("org.eclipse.egit.ui.UncommittedChangeForegroundColor")) {
            this.ensureFontAndColorsCreated(fonts, colors);
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final HashSet<IResource> resourcesToUpdate = new HashSet<IResource>();
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getKind() == 4 && (delta.getFlags() & INTERESTING_CHANGES) == 0) {
                        return true;
                    }
                    IResource resource = delta.getResource();
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
                    if (mapping == null) {
                        return true;
                    }
                    if (resource.getType() == 8) {
                        return true;
                    }
                    if (resource.getType() == 4 && !resource.isAccessible()) {
                        return false;
                    }
                    if (".gitignore".equals(resource.getName())) {
                        resourcesToUpdate.addAll(Arrays.asList(resource.getParent().members()));
                    } else {
                        resourcesToUpdate.add(resource);
                    }
                    return delta.getKind() != 4 || (delta.getFlags() & 0x4000) <= 1;
                }
            }, true);
        }
        catch (CoreException e) {
            GitLightweightDecorator.handleException(null, e);
        }
        if (resourcesToUpdate.isEmpty()) {
            return;
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.getBoolean("decorator_recompute_ancestors")) {
            IResource[] changedResources;
            IResource[] iResourceArray = changedResources = resourcesToUpdate.toArray(new IResource[resourcesToUpdate.size()]);
            int n = changedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource current = iResourceArray[n2];
                while (current.getType() != 8) {
                    current = current.getParent();
                    resourcesToUpdate.add(current);
                }
                ++n2;
            }
        }
        this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resourcesToUpdate.toArray()));
    }

    private void repositoryChanged(RepositoryChangedEvent e) {
        HashSet<RepositoryMapping> ms = new HashSet<RepositoryMapping>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)p);
            if (mapping != null && mapping.getRepository() == e.getRepository()) {
                ms.add(mapping);
            }
            ++n2;
        }
        for (RepositoryMapping m : ms) {
            this.repositoryChanged(m);
        }
    }

    public void indexChanged(IndexChangedEvent e) {
        this.repositoryChanged((RepositoryChangedEvent)e);
    }

    public void refsChanged(RefsChangedEvent e) {
        this.repositoryChanged((RepositoryChangedEvent)e);
    }

    public void repositoryChanged(RepositoryMapping mapping) {
        this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    private static IResource getResource(Object element) {
        IContributorResourceAdapter adapter;
        IAdaptable adaptable;
        if (element instanceof ResourceMapping) {
            element = ((ResourceMapping)element).getModelObject();
        }
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) == null && (adapter = (IContributorResourceAdapter)adaptable.getAdapter(IContributorResourceAdapter.class)) != null) {
            resource = adapter.getAdaptedResource(adaptable);
        }
        return resource;
    }

    private void postLabelEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GitLightweightDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    private static void handleException(IResource resource, CoreException e) {
        if (resource == null || resource.isAccessible()) {
            exceptions.handleException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DecorationHelper {
        public static final String BINDING_RESOURCE_NAME = "name";
        public static final String BINDING_BRANCH_NAME = "branch";
        public static final String BINDING_DIRTY_FLAG = "dirty";
        public static final String BINDING_STAGED_FLAG = "staged";
        private IPreferenceStore store;
        private static ImageDescriptor trackedImage = new CachedImageDescriptor(TeamImages.getImageDescriptor((String)"ovr/version_controlled.gif"));
        private static ImageDescriptor untrackedImage = new CachedImageDescriptor(UIIcons.OVR_UNTRACKED);
        private static ImageDescriptor stagedImage = new CachedImageDescriptor(UIIcons.OVR_STAGED);
        private static ImageDescriptor stagedAddedImage = new CachedImageDescriptor(UIIcons.OVR_STAGED_ADD);
        private static ImageDescriptor stagedRemovedImage = new CachedImageDescriptor(UIIcons.OVR_STAGED_REMOVE);
        private static ImageDescriptor conflictImage = new CachedImageDescriptor(UIIcons.OVR_CONFLICT);
        private static ImageDescriptor assumeValidImage = new CachedImageDescriptor(UIIcons.OVR_ASSUMEVALID);

        public DecorationHelper(IPreferenceStore preferencesStore) {
            this.store = preferencesStore;
        }

        public void decorate(IDecoration decoration, IDecoratableResource resource) {
            if (resource.isIgnored()) {
                return;
            }
            this.decorateText(decoration, resource);
            this.decorateIcons(decoration, resource);
            this.decorateFontAndColour(decoration, resource);
        }

        private void decorateFontAndColour(IDecoration decoration, IDecoratableResource resource) {
            ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            if (resource.isIgnored()) {
                return;
            }
            if (!resource.isTracked() || resource.isDirty() || resource.staged() != IDecoratableResource.Staged.NOT_STAGED) {
                Color bc = current.getColorRegistry().get("org.eclipse.egit.ui.UncommittedChangeBackgroundColor");
                Color fc = current.getColorRegistry().get("org.eclipse.egit.ui.UncommittedChangeForegroundColor");
                Font f = current.getFontRegistry().get("org.eclipse.egit.ui.UncommittedChangeFont");
                decoration.setBackgroundColor(bc);
                decoration.setForegroundColor(fc);
                decoration.setFont(f);
            }
        }

        private void decorateText(IDecoration decoration, IDecoratableResource resource) {
            String format = "";
            switch (resource.getType()) {
                case 1: {
                    format = this.store.getString("decorator_filetext_decoration");
                    break;
                }
                case 2: {
                    format = this.store.getString("decorator_foldertext_decoration");
                    break;
                }
                case 4: {
                    format = this.store.getString("decorator_projecttext_decoration");
                }
            }
            HashMap<String, String> bindings = new HashMap<String, String>();
            bindings.put(BINDING_RESOURCE_NAME, resource.getName());
            bindings.put(BINDING_BRANCH_NAME, resource.getBranch());
            bindings.put(BINDING_DIRTY_FLAG, resource.isDirty() ? ">" : null);
            bindings.put(BINDING_STAGED_FLAG, resource.staged() != IDecoratableResource.Staged.NOT_STAGED ? "*" : null);
            DecorationHelper.decorate(decoration, format, bindings);
        }

        private void decorateIcons(IDecoration decoration, IDecoratableResource resource) {
            ImageDescriptor overlay = null;
            if (resource.isTracked()) {
                if (this.store.getBoolean("decorator_show_tracked_icon")) {
                    overlay = trackedImage;
                }
                if (this.store.getBoolean("decorator_show_assume_valid_icon") && resource.isAssumeValid()) {
                    overlay = assumeValidImage;
                }
                IDecoratableResource.Staged staged = resource.staged();
                if (this.store.getBoolean("decorator_show_staged_icon") && staged != IDecoratableResource.Staged.NOT_STAGED) {
                    overlay = staged == IDecoratableResource.Staged.ADDED ? stagedAddedImage : (staged == IDecoratableResource.Staged.REMOVED ? stagedRemovedImage : stagedImage);
                }
                if (this.store.getBoolean("decorator_show_conflicts_icon") && resource.hasConflicts()) {
                    overlay = conflictImage;
                }
            } else if (this.store.getBoolean("decorator_show_untracked_icon")) {
                overlay = untrackedImage;
            }
            decoration.addOverlay(overlay);
        }

        public static void decorate(IDecoration decoration, String format, Map<String, String> bindings) {
            String suffixString;
            StringBuffer suffix;
            StringBuffer prefix;
            block9: {
                prefix = new StringBuffer();
                suffix = new StringBuffer();
                StringBuffer output = prefix;
                int length = format.length();
                int start = -1;
                int end = length;
                while ((end = format.indexOf(123, start)) > -1) {
                    output.append(format.substring(start + 1, end));
                    start = format.indexOf(125, end);
                    if (start > -1) {
                        char c;
                        String s;
                        String key = format.substring(end + 1, start);
                        if (key.indexOf(58) > -1) {
                            String[] keyAndBinding = key.split(":", 2);
                            key = keyAndBinding[0];
                            if (keyAndBinding.length > 1 && bindings.get(key) != null) {
                                bindings.put(key, keyAndBinding[1]);
                            }
                        }
                        if (key.equals(BINDING_RESOURCE_NAME)) {
                            output = suffix;
                            s = null;
                        } else {
                            s = bindings.get(key);
                        }
                        if (s != null) {
                            output.append(s);
                            continue;
                        }
                        int curLength = output.length();
                        if (curLength <= 0 || (c = output.charAt(curLength - 1)) != ':' && c != '@') continue;
                        output.deleteCharAt(curLength - 1);
                        continue;
                    }
                    output.append(format.substring(end, length));
                    break block9;
                }
                output.append(format.substring(start + 1, length));
            }
            String prefixString = prefix.toString().replaceAll("^\\s+", "");
            if (prefixString != null) {
                decoration.addPrefix(TextProcessor.process((String)prefixString, (String)"()[]."));
            }
            if ((suffixString = suffix.toString().replaceAll("\\s+$", "")) != null) {
                decoration.addSuffix(TextProcessor.process((String)suffixString, (String)"()[]."));
            }
        }

        private static class CachedImageDescriptor
        extends ImageDescriptor {
            ImageDescriptor descriptor;
            ImageData data;

            public CachedImageDescriptor(ImageDescriptor descriptor) {
                this.descriptor = descriptor;
            }

            public ImageData getImageData() {
                if (this.data == null) {
                    this.data = this.descriptor.getImageData();
                }
                return this.data;
            }
        }
    }
}

