/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class BranchSelectionDialog
extends Dialog {
    private final Repository repo;
    private boolean showResetType = true;
    private Composite parent;
    private Tree branchTree;
    private String refName = null;
    private ResetOperation.ResetType resetType = ResetOperation.ResetType.MIXED;

    public BranchSelectionDialog(Shell parentShell, Repository repo) {
        super(parentShell);
        this.repo = repo;
    }

    public void setShowResetType(boolean show) {
        this.showResetType = show;
    }

    protected Composite createDialogArea(Composite base) {
        this.parent = (Composite)super.createDialogArea(base);
        this.parent.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        new Label(this.parent, 0).setText(UIText.BranchSelectionDialog_Refs);
        this.branchTree = new Tree(this.parent, 2048);
        this.branchTree.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(500, 300).create());
        if (this.showResetType) {
            this.buildResetGroup();
        }
        String rawTitle = this.showResetType ? UIText.BranchSelectionDialog_TitleReset : UIText.BranchSelectionDialog_TitleCheckout;
        this.getShell().setText(NLS.bind((String)rawTitle, (Object[])new Object[]{this.repo.getDirectory()}));
        try {
            this.fillTreeWithBranches(null);
        }
        catch (Throwable e) {
            Activator.logError(UIText.BranchSelectionDialog_ErrorCouldNotRefresh, e);
        }
        return this.parent;
    }

    private void buildResetGroup() {
        Group g = new Group(this.parent, 0);
        g.setText(UIText.BranchSelectionDialog_ResetType);
        g.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).create());
        g.setLayout((Layout)new RowLayout(512));
        Button soft = new Button((Composite)g, 16);
        soft.setText(UIText.BranchSelectionDialog_ResetTypeSoft);
        soft.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BranchSelectionDialog.this.resetType = ResetOperation.ResetType.SOFT;
            }
        });
        Button medium = new Button((Composite)g, 16);
        medium.setSelection(true);
        medium.setText(UIText.BranchSelectionDialog_ResetTypeMixed);
        medium.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BranchSelectionDialog.this.resetType = ResetOperation.ResetType.MIXED;
            }
        });
        Button hard = new Button((Composite)g, 16);
        hard.setText(UIText.BranchSelectionDialog_ResetTypeHard);
        hard.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BranchSelectionDialog.this.resetType = ResetOperation.ResetType.HARD;
            }
        });
    }

    private void fillTreeWithBranches(String select) throws IOException {
        String branch = this.repo.getFullBranch();
        ArrayList branches = new ArrayList(this.repo.getAllRefs().keySet());
        Collections.sort(branches);
        TreeItem curItem = null;
        TreeItem curSubItem = null;
        String curPrefix = null;
        String curSubPrefix = null;
        TreeItem itemToSelect = null;
        Iterator iterator = branches.iterator();
        while (iterator.hasNext()) {
            String ref;
            String shortName = ref = (String)iterator.next();
            if (ref.startsWith("refs/heads/")) {
                shortName = ref.substring(11);
                if (!"refs/heads/".equals(curPrefix)) {
                    curPrefix = "refs/heads/";
                    curSubPrefix = null;
                    curSubItem = null;
                    curItem = new TreeItem(this.branchTree, 0);
                    curItem.setText(UIText.BranchSelectionDialog_LocalBranches);
                }
            } else if (ref.startsWith("refs/remotes/")) {
                int slashPos;
                shortName = ref.substring(13);
                if (!"refs/remotes/".equals(curPrefix)) {
                    curPrefix = "refs/remotes/";
                    curItem = new TreeItem(this.branchTree, 0);
                    curItem.setText(UIText.BranchSelectionDialog_RemoteBranches);
                    curSubItem = null;
                    curSubPrefix = null;
                }
                if ((slashPos = shortName.indexOf("/")) > -1) {
                    String remoteName = shortName.substring(0, slashPos);
                    shortName = shortName.substring(slashPos + 1);
                    if (!remoteName.equals(curSubPrefix)) {
                        curSubItem = new TreeItem(curItem, 0);
                        curSubItem.setText(remoteName);
                        curSubPrefix = remoteName;
                    }
                } else {
                    curSubItem = null;
                    curSubPrefix = null;
                }
            } else if (ref.startsWith("refs/tags/")) {
                shortName = ref.substring(10);
                if (!"refs/tags/".equals(curPrefix)) {
                    curPrefix = "refs/tags/";
                    curSubPrefix = null;
                    curSubItem = null;
                    curItem = new TreeItem(this.branchTree, 0);
                    curItem.setText(UIText.BranchSelectionDialog_Tags);
                }
            }
            TreeItem item = curItem == null ? new TreeItem(this.branchTree, 0) : (curSubItem == null ? new TreeItem(curItem, 0) : new TreeItem(curSubItem, 0));
            item.setData((Object)ref);
            if (ref.equals(branch)) {
                item.setText(String.valueOf(shortName) + UIText.BranchSelectionDialog_BranchSuffix_Current);
                FontData fd = item.getFont().getFontData()[0];
                fd.setStyle(fd.getStyle() | 1);
                final Font f = new Font((Device)this.getShell().getDisplay(), fd);
                item.setFont(f);
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        f.dispose();
                    }
                });
                this.branchTree.showItem(item);
            } else {
                item.setText(shortName);
            }
            if (ref.equals(select)) {
                itemToSelect = item;
            }
            this.branchTree.setLinesVisible(true);
        }
        if (itemToSelect != null) {
            this.branchTree.select(itemToSelect);
            this.branchTree.showItem(itemToSelect);
        }
    }

    public String getRefName() {
        return this.refName;
    }

    public ResetOperation.ResetType getResetType() {
        return this.resetType;
    }

    protected void okPressed() {
        this.refNameFromDialog();
        if (this.refName == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.BranchSelectionDialog_NoBranchSeletectTitle, (String)UIText.BranchSelectionDialog_NoBranchSeletectMessage);
            return;
        }
        if (this.showResetType && this.resetType == ResetOperation.ResetType.HARD && !MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.BranchSelectionDialog_ReallyResetTitle, (String)UIText.BranchSelectionDialog_ReallyResetMessage)) {
            return;
        }
        super.okPressed();
    }

    private void refNameFromDialog() {
        TreeItem[] selection = this.branchTree.getSelection();
        this.refName = null;
        if (selection != null && selection.length > 0) {
            TreeItem item = selection[0];
            this.refName = (String)item.getData();
        }
    }

    private InputDialog getRefNameInputDialog(String prompt) {
        InputDialog labelDialog = new InputDialog(this.getShell(), UIText.BranchSelectionDialog_QuestionNewBranchTitle, prompt, null, new IInputValidator(){

            public String isValid(String newText) {
                String testFor = "refs/heads/" + newText;
                try {
                    if (BranchSelectionDialog.this.repo.resolve(testFor) != null) {
                        return UIText.BranchSelectionDialog_ErrorAlreadyExists;
                    }
                }
                catch (IOException e1) {
                    Activator.logError(NLS.bind((String)UIText.BranchSelectionDialog_ErrorCouldNotResolve, (Object)testFor), e1);
                    return e1.getMessage();
                }
                if (!Repository.isValidRefName((String)testFor)) {
                    return UIText.BranchSelectionDialog_ErrorInvalidRefName;
                }
                return null;
            }
        });
        labelDialog.setBlockOnOpen(true);
        return labelDialog;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.showResetType) {
            Button newButton = new Button(parent, 8);
            newButton.setFont(JFaceResources.getDialogFont());
            newButton.setText(UIText.BranchSelectionDialog_NewBranch);
            ++((GridLayout)parent.getLayout()).numColumns;
            Button renameButton = new Button(parent, 8);
            renameButton.setText(UIText.BranchSelectionDialog_Rename);
            renameButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    BranchSelectionDialog.this.refNameFromDialog();
                    String branchName = BranchSelectionDialog.this.refName.startsWith("refs/heads/") ? BranchSelectionDialog.this.refName.substring("refs/heads/".length()) : BranchSelectionDialog.this.refName;
                    InputDialog labelDialog = BranchSelectionDialog.this.getRefNameInputDialog(NLS.bind((String)UIText.BranchSelectionDialog_QuestionNewBranchNameMessage, (Object)branchName));
                    if (labelDialog.open() == 0) {
                        String newRefName = "refs/heads/" + labelDialog.getValue();
                        try {
                            RefRename renameRef = BranchSelectionDialog.this.repo.renameRef(BranchSelectionDialog.this.refName, newRefName);
                            if (renameRef.rename() != RefUpdate.Result.RENAMED) {
                                BranchSelectionDialog.this.reportError(null, UIText.BranchSelectionDialog_BranchSelectionDialog_RenamedFailedTitle, UIText.BranchSelectionDialog_ErrorCouldNotRenameRef, new Object[]{BranchSelectionDialog.this.refName, newRefName, renameRef.getResult()});
                            }
                        }
                        catch (Throwable e1) {
                            BranchSelectionDialog.this.reportError(e1, UIText.BranchSelectionDialog_BranchSelectionDialog_RenamedFailedTitle, UIText.BranchSelectionDialog_ErrorCouldNotRenameRef, new Object[]{BranchSelectionDialog.this.refName, newRefName, e1.getMessage()});
                        }
                        try {
                            BranchSelectionDialog.this.branchTree.removeAll();
                            BranchSelectionDialog.this.fillTreeWithBranches(newRefName);
                        }
                        catch (Throwable e1) {
                            BranchSelectionDialog.this.reportError(e1, UIText.BranchSelectionDialog_BranchSelectionDialog_RenamedFailedTitle, UIText.BranchSelectionDialog_ErrorCouldNotRefreshBranchList, new Object[0]);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            newButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    BranchSelectionDialog.this.refNameFromDialog();
                    InputDialog labelDialog = BranchSelectionDialog.this.getRefNameInputDialog(UIText.BranchSelectionDialog_QuestionNewBranchMessage);
                    if (labelDialog.open() == 0) {
                        String newRefName = "refs/heads/" + labelDialog.getValue();
                        try {
                            RefUpdate updateRef = BranchSelectionDialog.this.repo.updateRef(newRefName);
                            Ref startRef = BranchSelectionDialog.this.repo.getRef(BranchSelectionDialog.this.refName);
                            ObjectId startAt = BranchSelectionDialog.this.refName == null ? BranchSelectionDialog.this.repo.resolve("HEAD") : BranchSelectionDialog.this.repo.resolve(BranchSelectionDialog.this.refName);
                            String startBranch = startRef != null ? BranchSelectionDialog.this.refName : startAt.name();
                            startBranch = BranchSelectionDialog.this.repo.shortenRefName(startBranch);
                            updateRef.setNewObjectId((AnyObjectId)startAt);
                            updateRef.setRefLogMessage("branch: Created from " + startBranch, false);
                            updateRef.update();
                        }
                        catch (Throwable e1) {
                            BranchSelectionDialog.this.reportError(e1, UIText.BranchSelectionDialog_BranchSelectionDialog_CreateFailedTitle, UIText.BranchSelectionDialog_ErrorCouldNotCreateNewRef, new Object[]{newRefName});
                        }
                        try {
                            BranchSelectionDialog.this.branchTree.removeAll();
                            BranchSelectionDialog.this.fillTreeWithBranches(newRefName);
                        }
                        catch (Throwable e1) {
                            BranchSelectionDialog.this.reportError(e1, UIText.BranchSelectionDialog_BranchSelectionDialog_CreateFailedTitle, UIText.BranchSelectionDialog_ErrorCouldNotRefreshBranchList, new Object[0]);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.createButton(parent, 0, this.showResetType ? UIText.BranchSelectionDialog_OkReset : UIText.BranchSelectionDialog_OkCheckout, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private void reportError(Throwable e, String title, String message, Object ... args) {
        String msg = NLS.bind((String)message, (Object[])args);
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)msg);
        Activator.logError(msg, e);
    }
}

