/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.internal.storage.GitFileHistoryProvider;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.dialogs.CommitItem;
import org.eclipse.egit.ui.internal.dialogs.CommitViewerComparator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitDialog
extends Dialog {
    ArrayList<CommitItem> items = new ArrayList();
    Text commitText;
    Text authorText;
    Text committerText;
    Button amendingButton;
    Button signedOffButton;
    CheckboxTableViewer filesViewer;
    private String commitMessage = "";
    private String author = null;
    private String committer = null;
    private String previousAuthor = null;
    private boolean signedOff = false;
    private boolean amending = false;
    private boolean amendAllowed = true;
    private ArrayList<IFile> selectedFiles = new ArrayList();
    private String previousCommitMessage = "";

    public CommitDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 18, UIText.CommitDialog_SelectAll, false);
        this.createButton(parent, 19, UIText.CommitDialog_DeselectAll, false);
        this.createButton(parent, 0, UIText.CommitDialog_Commit, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        parent.getShell().setText(UIText.CommitDialog_CommitChanges);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label label = new Label(container, 16384);
        label.setText(UIText.CommitDialog_CommitMessage);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, false).create());
        this.commitText = new Text(container, 2562);
        this.commitText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).hint(600, 200).create());
        this.commitText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.keyCode == 13 && (arg0.stateMask & 0x40000) > 0) {
                    CommitDialog.this.okPressed();
                } else if (arg0.keyCode == 9 && (arg0.stateMask & 0x20000) == 0) {
                    arg0.doit = false;
                    CommitDialog.this.commitText.traverse(16);
                }
            }
        });
        new Label(container, 16384).setText(UIText.CommitDialog_Author);
        this.authorText = new Text(container, 2048);
        this.authorText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        if (this.author != null) {
            this.authorText.setText(this.author);
        }
        new Label(container, 16384).setText(UIText.CommitDialog_Committer);
        this.committerText = new Text(container, 2048);
        this.committerText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        if (this.committer != null) {
            this.committerText.setText(this.committer);
        }
        this.committerText.addModifyListener(new ModifyListener(){
            String oldCommitter;
            {
                this.oldCommitter = CommitDialog.this.committerText.getText();
            }

            public void modifyText(ModifyEvent e) {
                if (CommitDialog.this.signedOffButton.getSelection()) {
                    String newCommitter = CommitDialog.this.committerText.getText();
                    String oldSignOff = CommitDialog.this.getSignedOff(this.oldCommitter);
                    String newSignOff = CommitDialog.this.getSignedOff(newCommitter);
                    CommitDialog.this.commitText.setText(CommitDialog.this.replaceSignOff(CommitDialog.this.commitText.getText(), oldSignOff, newSignOff));
                    this.oldCommitter = newCommitter;
                }
            }
        });
        this.amendingButton = new Button(container, 32);
        if (this.amending) {
            this.amendingButton.setSelection(this.amending);
            this.amendingButton.setEnabled(false);
            this.commitText.setText(this.previousCommitMessage);
            this.authorText.setText(this.previousAuthor);
        } else if (!this.amendAllowed) {
            this.amendingButton.setEnabled(false);
        }
        this.amendingButton.addSelectionListener(new SelectionListener(){
            boolean alreadyAdded = false;

            public void widgetSelected(SelectionEvent arg0) {
                if (this.alreadyAdded) {
                    return;
                }
                if (CommitDialog.this.amendingButton.getSelection()) {
                    this.alreadyAdded = true;
                    String curText = CommitDialog.this.commitText.getText();
                    if (curText.length() > 0) {
                        curText = String.valueOf(curText) + "\n";
                    }
                    CommitDialog.this.commitText.setText(String.valueOf(curText) + CommitDialog.this.previousCommitMessage);
                    CommitDialog.this.authorText.setText(CommitDialog.this.previousAuthor);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.amendingButton.setText(UIText.CommitDialog_AmendPreviousCommit);
        this.amendingButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.signedOffButton = new Button(container, 32);
        this.signedOffButton.setSelection(this.signedOff);
        this.signedOffButton.setText(UIText.CommitDialog_AddSOB);
        this.signedOffButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.signedOffButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String curText = CommitDialog.this.commitText.getText();
                if (CommitDialog.this.signedOffButton.getSelection()) {
                    CommitDialog.this.commitText.setText(CommitDialog.this.signOff(curText));
                } else {
                    if ((curText = CommitDialog.this.replaceSignOff(curText, CommitDialog.this.getSignedOff(), "")).endsWith(String.valueOf(Text.DELIMITER) + Text.DELIMITER)) {
                        curText = curText.substring(0, curText.length() - Text.DELIMITER.length());
                    }
                    CommitDialog.this.commitText.setText(curText);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.commitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommitDialog.this.updateSignedOffButton();
            }
        });
        this.updateSignedOffButton();
        Table resourcesTable = new Table(container, 68386);
        resourcesTable.setLayoutData((Object)GridDataFactory.fillDefaults().hint(600, 200).span(2, 1).grab(true, true).create());
        resourcesTable.addSelectionListener((SelectionListener)new CommitItemSelectionListener());
        resourcesTable.setHeaderVisible(true);
        TableColumn statCol = new TableColumn(resourcesTable, 16384);
        statCol.setText(UIText.CommitDialog_Status);
        statCol.setWidth(150);
        statCol.addSelectionListener((SelectionListener)new HeaderSelectionListener(CommitItem.Order.ByStatus));
        TableColumn resourceCol = new TableColumn(resourcesTable, 16384);
        resourceCol.setText(UIText.CommitDialog_File);
        resourceCol.setWidth(415);
        resourceCol.addSelectionListener((SelectionListener)new HeaderSelectionListener(CommitItem.Order.ByFile));
        this.filesViewer = new CheckboxTableViewer(resourcesTable);
        this.filesViewer.setContentProvider((IContentProvider)new CommitContentProvider());
        this.filesViewer.setLabelProvider((IBaseLabelProvider)new CommitLabelProvider());
        this.filesViewer.setInput(this.items);
        this.filesViewer.setAllChecked(true);
        this.filesViewer.getTable().setMenu(this.getContextMenu());
        container.pack();
        return container;
    }

    private void updateSignedOffButton() {
        String curText = this.commitText.getText();
        if (!curText.endsWith(Text.DELIMITER)) {
            curText = String.valueOf(curText) + Text.DELIMITER;
        }
        this.signedOffButton.setSelection(curText.indexOf(String.valueOf(this.getSignedOff()) + Text.DELIMITER) != -1);
    }

    private String getSignedOff() {
        return this.getSignedOff(this.committerText.getText());
    }

    private String getSignedOff(String signer) {
        return "Signed-off-by: " + signer;
    }

    private String signOff(String input) {
        String output = input;
        if (!output.endsWith(Text.DELIMITER)) {
            output = String.valueOf(output) + Text.DELIMITER;
        }
        if (!this.getLastLine(output).startsWith("Signed-off-by: ")) {
            output = String.valueOf(output) + Text.DELIMITER;
        }
        output = String.valueOf(output) + this.getSignedOff();
        return output;
    }

    private String getLastLine(String input) {
        String output = input;
        int breakLength = Text.DELIMITER.length();
        int lastIndexOfLineBreak = output.lastIndexOf(Text.DELIMITER);
        if (lastIndexOfLineBreak != -1 && lastIndexOfLineBreak == output.length() - breakLength) {
            output = output.substring(0, output.length() - breakLength);
        }
        return (lastIndexOfLineBreak = output.lastIndexOf(Text.DELIMITER)) == -1 ? output : output.substring(lastIndexOfLineBreak + breakLength, output.length());
    }

    private String replaceSignOff(String input, String oldSignOff, String newSignOff) {
        int indexOfSignOff;
        assert (input != null);
        assert (oldSignOff != null);
        assert (newSignOff != null);
        String curText = input;
        if (!curText.endsWith(Text.DELIMITER)) {
            curText = String.valueOf(curText) + Text.DELIMITER;
        }
        if ((indexOfSignOff = curText.indexOf(String.valueOf(oldSignOff) + Text.DELIMITER)) == -1) {
            return input;
        }
        return String.valueOf(input.substring(0, indexOfSignOff)) + newSignOff + input.substring(indexOfSignOff + oldSignOff.length(), input.length());
    }

    private Menu getContextMenu() {
        Menu menu = new Menu((Control)this.filesViewer.getTable());
        MenuItem item = new MenuItem(menu, 8);
        item.setText(UIText.CommitDialog_AddFileOnDiskToIndex);
        item.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                IStructuredSelection sel = (IStructuredSelection)CommitDialog.this.filesViewer.getSelection();
                if (sel.isEmpty()) {
                    return;
                }
                try {
                    ArrayList<GitIndex> changedIndexes = new ArrayList<GitIndex>();
                    for (CommitItem commitItem : sel) {
                        IProject project = commitItem.file.getProject();
                        RepositoryMapping map = RepositoryMapping.getMapping((IResource)project);
                        Repository repo = map.getRepository();
                        GitIndex index = null;
                        index = repo.getIndex();
                        GitIndex.Entry entry = index.getEntry(map.getRepoRelativePath((IResource)commitItem.file));
                        if (entry == null || !entry.isModified(map.getWorkDir())) continue;
                        entry.update(new File(map.getWorkDir(), entry.getName()));
                        if (changedIndexes.contains(index)) continue;
                        changedIndexes.add(index);
                    }
                    if (!changedIndexes.isEmpty()) {
                        for (GitIndex idx : changedIndexes) {
                            idx.write();
                        }
                        CommitDialog.this.filesViewer.refresh(true);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        return menu;
    }

    private static String getFileStatus(IFile file) {
        String prefix = UIText.CommitDialog_StatusUnknown;
        try {
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)file.getProject());
            Repository repo = repositoryMapping.getRepository();
            GitIndex index = repo.getIndex();
            Tree headTree = repo.mapTree("HEAD");
            String repoPath = repositoryMapping.getRepoRelativePath((IResource)file);
            TreeEntry headEntry = headTree.findBlobMember(repoPath);
            boolean headExists = headTree.existsBlob(repoPath);
            GitIndex.Entry indexEntry = index.getEntry(repoPath);
            if (headEntry == null) {
                prefix = UIText.CommitDialog_StatusAdded;
                if (indexEntry.isModified(repositoryMapping.getWorkDir())) {
                    prefix = UIText.CommitDialog_StatusAddedIndexDiff;
                }
            } else if (indexEntry == null) {
                prefix = UIText.CommitDialog_StatusRemoved;
            } else if (headExists && !headEntry.getId().equals((AnyObjectId)indexEntry.getObjectId())) {
                prefix = UIText.CommitDialog_StatusModified;
                if (indexEntry.isModified(repositoryMapping.getWorkDir())) {
                    prefix = UIText.CommitDialog_StatusModifiedIndexDiff;
                }
            } else if (!new File(repositoryMapping.getWorkDir(), indexEntry.getName()).isFile()) {
                prefix = UIText.CommitDialog_StatusRemovedNotStaged;
            } else if (indexEntry.isModified(repositoryMapping.getWorkDir())) {
                prefix = UIText.CommitDialog_StatusModifiedNotStaged;
            }
        }
        catch (Exception e) {
            Activator.logError((String)"Problem in finding file status", (Throwable)e);
            prefix = e.getMessage();
        }
        return prefix;
    }

    public String getCommitMessage() {
        return this.commitMessage.replaceAll(Text.DELIMITER, "\n");
    }

    public void setCommitMessage(String s) {
        this.commitMessage = s;
    }

    public void setSelectedFiles(IFile[] items) {
        Collections.addAll(this.selectedFiles, items);
    }

    public IFile[] getSelectedFiles() {
        return this.selectedFiles.toArray(new IFile[0]);
    }

    protected void okPressed() {
        this.commitMessage = this.commitText.getText();
        this.author = this.authorText.getText().trim();
        this.committer = this.committerText.getText().trim();
        this.signedOff = this.signedOffButton.getSelection();
        this.amending = this.amendingButton.getSelection();
        Object[] checkedElements = this.filesViewer.getCheckedElements();
        this.selectedFiles.clear();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.selectedFiles.add(((CommitItem)obj).file);
            ++n2;
        }
        if (this.commitMessage.trim().length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorNoMessage, (String)UIText.CommitDialog_ErrorMustEnterCommitMessage);
            return;
        }
        boolean authorValid = false;
        if (this.author.length() > 0) {
            try {
                new PersonIdent(this.author);
                authorValid = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                authorValid = false;
            }
        }
        if (!authorValid) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorInvalidAuthor, (String)UIText.CommitDialog_ErrorInvalidAuthorSpecified);
            return;
        }
        boolean committerValid = false;
        if (this.committer.length() > 0) {
            try {
                new PersonIdent(this.committer);
                committerValid = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                committerValid = false;
            }
        }
        if (!committerValid) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorInvalidAuthor, (String)UIText.CommitDialog_ErrorInvalidCommitterSpecified);
            return;
        }
        if (this.selectedFiles.isEmpty() && !this.amending) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorNoItemsSelected, (String)UIText.CommitDialog_ErrorNoItemsSelectedToBeCommitted);
            return;
        }
        super.okPressed();
    }

    public void setFileList(ArrayList<IFile> files) {
        this.items.clear();
        for (IFile file : files) {
            CommitItem item = new CommitItem();
            item.status = CommitDialog.getFileStatus(file);
            item.file = file;
            this.items.add(item);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (18 == buttonId) {
            this.filesViewer.setAllChecked(true);
        }
        if (19 == buttonId) {
            this.filesViewer.setAllChecked(false);
        }
        super.buttonPressed(buttonId);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public void setPreviousAuthor(String previousAuthor) {
        this.previousAuthor = previousAuthor;
    }

    public boolean isSignedOff() {
        return this.signedOff;
    }

    public void setSignedOff(boolean signedOff) {
        this.signedOff = signedOff;
    }

    public boolean isAmending() {
        return this.amending;
    }

    public void setAmending(boolean amending) {
        this.amending = amending;
    }

    public void setPreviousCommitMessage(String string) {
        this.previousCommitMessage = string;
    }

    public void setAmendAllowed(boolean amendAllowed) {
        this.amendAllowed = amendAllowed;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    class CommitContentProvider
    implements IStructuredContentProvider {
        CommitContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return CommitDialog.this.items.toArray();
        }
    }

    class CommitItemSelectionListener
    extends SelectionAdapter {
        CommitItemSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Commit headCommit;
            IStructuredSelection selection = (IStructuredSelection)CommitDialog.this.filesViewer.getSelection();
            CommitItem commitItem = (CommitItem)selection.getFirstElement();
            if (commitItem == null) {
                return;
            }
            IProject project = commitItem.file.getProject();
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            if (mapping == null) {
                return;
            }
            Repository repository = mapping.getRepository();
            try {
                headCommit = repository.mapCommit("HEAD");
            }
            catch (IOException iOException) {
                headCommit = null;
            }
            if (headCommit == null) {
                return;
            }
            GitProvider provider = (GitProvider)RepositoryProvider.getProvider((IProject)project);
            GitFileHistoryProvider fileHistoryProvider = (GitFileHistoryProvider)provider.getFileHistoryProvider();
            IFileHistory fileHistory = fileHistoryProvider.getFileHistoryFor((IResource)commitItem.file, 1, null);
            IFileRevision baseFile = fileHistory.getFileRevisions()[0];
            IFileRevision nextFile = fileHistoryProvider.getWorkspaceFileRevision((IResource)commitItem.file);
            FileRevisionTypedElement base = new FileRevisionTypedElement(baseFile);
            FileRevisionTypedElement next = new FileRevisionTypedElement(nextFile);
            GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput((ITypedElement)base, (ITypedElement)next, null);
            CompareUI.openCompareDialog((CompareEditorInput)input);
        }
    }

    class CommitLabelProvider
    extends WorkbenchLabelProvider
    implements ITableLabelProvider {
        CommitLabelProvider() {
        }

        public String getColumnText(Object obj, int columnIndex) {
            CommitItem item = (CommitItem)obj;
            switch (columnIndex) {
                case 0: {
                    return item.status;
                }
                case 1: {
                    return String.valueOf(item.file.getProject().getName()) + ": " + item.file.getProjectRelativePath();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }
    }

    class HeaderSelectionListener
    extends SelectionAdapter {
        private CommitItem.Order order;
        private boolean reversed;

        public HeaderSelectionListener(CommitItem.Order order) {
            this.order = order;
        }

        public void widgetSelected(SelectionEvent e) {
            Comparator<CommitItem> comparator;
            TableColumn column = (TableColumn)e.widget;
            Table table = column.getParent();
            this.reversed = column == table.getSortColumn() ? !this.reversed : false;
            table.setSortColumn(column);
            if (this.reversed) {
                comparator = this.order.descending();
                table.setSortDirection(1024);
            } else {
                comparator = this.order;
                table.setSortDirection(128);
            }
            CommitDialog.this.filesViewer.setComparator((ViewerComparator)new CommitViewerComparator(comparator));
        }
    }
}

