/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchResultTable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class FetchResultDialog
extends Dialog {
    private final Repository localDb;
    private final FetchResult result;
    private final String sourceString;

    FetchResultDialog(Shell parentShell, Repository localDb, FetchResult result, String sourceString) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.localDb = localDb;
        this.result = result;
        this.sourceString = sourceString;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        String text = !this.result.getTrackingRefUpdates().isEmpty() ? NLS.bind((String)UIText.FetchResultDialog_labelNonEmptyResult, (Object)this.sourceString) : NLS.bind((String)UIText.FetchResultDialog_labelEmptyResult, (Object)this.sourceString);
        label.setText(text);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        FetchResultTable table = new FetchResultTable(composite);
        table.setData(this.localDb, this.result);
        Control tableControl = table.getControl();
        GridData tableLayout = new GridData(4, 4, true, true);
        tableLayout.widthHint = 600;
        tableLayout.heightHint = 300;
        tableControl.setLayoutData((Object)tableLayout);
        this.getShell().setText(NLS.bind((String)UIText.FetchResultDialog_title, (Object)this.sourceString));
        return composite;
    }
}

