/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.fetch.TrackingRefUpdateContentProvider;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

class FetchResultTable {
    private static final int TABLE_PREFERRED_HEIGHT = 600;
    private static final int TABLE_PREFERRED_WIDTH = 300;
    private static final int COLUMN_SRC_WEIGHT = 10;
    private static final int COLUMN_DST_WEIGHT = 10;
    private static final int COLUMN_STATUS_WEIGHT = 7;
    private static final String COLOR_REJECTED_KEY = "REJECTED";
    private static final RGB COLOR_REJECTED = new RGB(255, 0, 0);
    private static final String COLOR_UPDATED_KEY = "UPDATED";
    private static final RGB COLOR_UPDATED = new RGB(0, 255, 0);
    private static final String COLOR_UP_TO_DATE_KEY = "UP_TO_DATE";
    private static final RGB COLOR_UP_TO_DATE = new RGB(245, 245, 245);
    private final Composite tablePanel;
    private final TableViewer tableViewer;
    private final ColorRegistry colorRegistry;
    private Repository db;

    FetchResultTable(Composite parent) {
        this.tablePanel = new Composite(parent, 0);
        this.tablePanel.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 600;
        layoutData.widthHint = 300;
        this.tableViewer = new TableViewer(this.tablePanel);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.colorRegistry = new ColorRegistry(table.getDisplay());
        this.colorRegistry.put(COLOR_REJECTED_KEY, COLOR_REJECTED);
        this.colorRegistry.put(COLOR_UPDATED_KEY, COLOR_UPDATED);
        this.colorRegistry.put(COLOR_UP_TO_DATE_KEY, COLOR_UP_TO_DATE);
        this.tableViewer.setContentProvider((IContentProvider)new TrackingRefUpdateContentProvider());
        this.tableViewer.setInput(null);
        this.createTableColumns();
    }

    void setData(Repository db, FetchResult fetchResult) {
        this.tableViewer.setInput(null);
        this.db = db;
        this.tableViewer.setInput((Object)fetchResult);
    }

    Control getControl() {
        return this.tablePanel;
    }

    private void createTableColumns() {
        TableColumnLayout layout = new TableColumnLayout();
        this.tablePanel.setLayout((Layout)layout);
        TableViewerColumn srcViewer = this.createColumn(layout, UIText.FetchResultTable_columnSrc, 10, 16384);
        srcViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TrackingRefUpdate)element).getRemoteName();
            }
        });
        TableViewerColumn dstViewer = this.createColumn(layout, UIText.FetchResultTable_columnDst, 10, 16384);
        dstViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TrackingRefUpdate)element).getLocalName();
            }
        });
        TableViewerColumn statusViewer = this.createColumn(layout, UIText.FetchResultTable_columnStatus, 7, 16384);
        statusViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TrackingRefUpdate tru = (TrackingRefUpdate)element;
                RefUpdate.Result r = tru.getResult();
                if (r == RefUpdate.Result.LOCK_FAILURE) {
                    return UIText.FetchResultTable_statusLockFailure;
                }
                if (r == RefUpdate.Result.IO_FAILURE) {
                    return UIText.FetchResultTable_statusIOError;
                }
                if (r == RefUpdate.Result.NEW) {
                    if (tru.getRemoteName().startsWith("refs/heads/")) {
                        return UIText.FetchResultTable_statusNewBranch;
                    }
                    if (tru.getLocalName().startsWith("refs/tags/")) {
                        return UIText.FetchResultTable_statusNewTag;
                    }
                    return UIText.FetchResultTable_statusNew;
                }
                if (r == RefUpdate.Result.FORCED) {
                    String o = tru.getOldObjectId().abbreviate(FetchResultTable.this.db).name();
                    String n = tru.getNewObjectId().abbreviate(FetchResultTable.this.db).name();
                    return String.valueOf(o) + "..." + n;
                }
                if (r == RefUpdate.Result.FAST_FORWARD) {
                    String o = tru.getOldObjectId().abbreviate(FetchResultTable.this.db).name();
                    String n = tru.getNewObjectId().abbreviate(FetchResultTable.this.db).name();
                    return String.valueOf(o) + ".." + n;
                }
                if (r == RefUpdate.Result.REJECTED) {
                    return UIText.FetchResultTable_statusRejected;
                }
                if (r == RefUpdate.Result.NO_CHANGE) {
                    return UIText.FetchResultTable_statusUpToDate;
                }
                throw new IllegalArgumentException(NLS.bind((String)UIText.FetchResultTable_statusUnexpected, (Object)r));
            }

            public String getToolTipText(Object element) {
                RefUpdate.Result result = ((TrackingRefUpdate)element).getResult();
                switch (result) {
                    case FAST_FORWARD: {
                        return UIText.FetchResultTable_statusDetailFastForward;
                    }
                    case FORCED: 
                    case REJECTED: {
                        return UIText.FetchResultTable_statusDetailNonFastForward;
                    }
                    case NO_CHANGE: 
                    case NEW: {
                        return null;
                    }
                    case IO_FAILURE: {
                        return UIText.FetchResultTable_statusDetailIOError;
                    }
                    case LOCK_FAILURE: {
                        return UIText.FetchResultTable_statusDetailCouldntLock;
                    }
                }
                throw new IllegalArgumentException(NLS.bind((String)UIText.FetchResultTable_statusUnexpected, (Object)result));
            }

            public Color getBackground(Object element) {
                RefUpdate.Result result = ((TrackingRefUpdate)element).getResult();
                switch (result) {
                    case NEW: 
                    case FORCED: 
                    case FAST_FORWARD: {
                        return FetchResultTable.this.colorRegistry.get(FetchResultTable.COLOR_UPDATED_KEY);
                    }
                    case NO_CHANGE: {
                        return FetchResultTable.this.colorRegistry.get(FetchResultTable.COLOR_UP_TO_DATE_KEY);
                    }
                    case LOCK_FAILURE: 
                    case REJECTED: 
                    case IO_FAILURE: {
                        return FetchResultTable.this.colorRegistry.get(FetchResultTable.COLOR_REJECTED_KEY);
                    }
                }
                throw new IllegalArgumentException(NLS.bind((String)UIText.FetchResultTable_statusUnexpected, (Object)result));
            }
        });
    }

    private TableViewerColumn createColumn(TableColumnLayout columnLayout, String text, int weight, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(text);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return viewerColumn;
    }
}

