/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.RefSpecPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.fetch.FetchResultDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryConfig;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FetchWizard
extends Wizard {
    private final Repository localDb;
    private final RepositorySelectionPage repoPage;
    private final RefSpecPage refSpecPage;

    public FetchWizard(Repository localDb) throws URISyntaxException {
        this.localDb = localDb;
        List remotes = RemoteConfig.getAllRemoteConfigs((Config)localDb.getConfig());
        this.repoPage = new RepositorySelectionPage(true, remotes);
        this.refSpecPage = new RefSpecPage(localDb, false, this.repoPage);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.repoPage);
        this.addPage((IWizardPage)this.refSpecPage);
    }

    public boolean performFinish() {
        Transport transport;
        if (this.repoPage.getSelection().isConfigSelected() && this.refSpecPage.isSaveRequested()) {
            this.saveConfig();
        }
        RepositorySelection repoSelection = this.repoPage.getSelection();
        try {
            transport = repoSelection.isConfigSelected() ? Transport.open((Repository)this.localDb, (RemoteConfig)repoSelection.getConfig()) : Transport.open((Repository)this.localDb, (URIish)repoSelection.getURI());
        }
        catch (NotSupportedException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.FetchWizard_transportNotSupportedTitle, (String)UIText.FetchWizard_transportNotSupportedMessage, (IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
            return false;
        }
        transport.setTagOpt(this.refSpecPage.getTagOpt());
        FetchJob fetchJob = new FetchJob(transport, this.refSpecPage.getRefSpecs(), this.getSourceString());
        fetchJob.setUser(true);
        fetchJob.schedule();
        return true;
    }

    public String getWindowTitle() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.repoPage || currentPage == null) {
            return UIText.FetchWizard_windowTitleDefault;
        }
        return NLS.bind((String)UIText.FetchWizard_windowTitleWithSource, (Object)this.getSourceString());
    }

    private void saveConfig() {
        RemoteConfig rc = this.repoPage.getSelection().getConfig();
        rc.setFetchRefSpecs(this.refSpecPage.getRefSpecs());
        rc.setTagOpt(this.refSpecPage.getTagOpt());
        RepositoryConfig config = this.localDb.getConfig();
        rc.update((Config)config);
        try {
            config.save();
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.FetchWizard_cantSaveTitle, (String)UIText.FetchWizard_cantSaveMessage, (IStatus)new Status(2, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    private String getSourceString() {
        RepositorySelection repoSelection = this.repoPage.getSelection();
        if (repoSelection.isConfigSelected()) {
            return repoSelection.getConfigName();
        }
        return repoSelection.getURI().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FetchJob
    extends Job {
        private final Transport transport;
        private final List<RefSpec> refSpecs;
        private final String sourceString;

        public FetchJob(Transport transport, List<RefSpec> refSpecs, String sourceString) {
            super(NLS.bind((String)UIText.FetchWizard_jobName, (Object)sourceString));
            this.transport = transport;
            this.refSpecs = refSpecs;
            this.sourceString = sourceString;
        }

        protected IStatus run(IProgressMonitor monitor) {
            FetchResult result;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                result = this.transport.fetch((ProgressMonitor)new EclipseGitProgressTransformer(monitor), this.refSpecs);
            }
            catch (NotSupportedException e) {
                return new Status(4, Activator.getPluginId(), UIText.FetchWizard_fetchNotSupported, (Throwable)e);
            }
            catch (TransportException e) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return new Status(4, Activator.getPluginId(), UIText.FetchWizard_transportError, (Throwable)e);
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    FetchResultDialog dialog = new FetchResultDialog(shell, FetchWizard.this.localDb, result, FetchJob.this.sourceString);
                    dialog.open();
                }
            });
            return Status.OK_STATUS;
        }
    }
}

