/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.util.Iterator;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FileDiffContentProvider;
import org.eclipse.egit.ui.internal.history.FileDiffLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;

class CommitFileDiffViewer
extends TableViewer {
    private TreeWalk walker;
    private Clipboard clipboard;

    CommitFileDiffViewer(Composite parent) {
        super(parent, 68354);
        Table rawTable = this.getTable();
        rawTable.setHeaderVisible(true);
        rawTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        rawTable.setLayout((Layout)layout);
        this.createColumns(rawTable, layout);
        this.setLabelProvider((IBaseLabelProvider)new FileDiffLabelProvider());
        this.setContentProvider((IContentProvider)new FileDiffContentProvider());
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                FileDiff d = (FileDiff)iss.getFirstElement();
                if (CommitFileDiffViewer.this.walker != null && d.blobs.length == 2) {
                    CommitFileDiffViewer.this.showTwoWayFileDiff(d);
                }
            }
        });
        this.clipboard = new Clipboard(rawTable.getDisplay());
        rawTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitFileDiffViewer.this.clipboard.dispose();
            }
        });
    }

    void showTwoWayFileDiff(FileDiff d) {
        Repository db = this.walker.getRepository();
        String p = d.path;
        RevCommit c = d.commit;
        GitFileRevision baseFile = GitFileRevision.inCommit((Repository)db, (RevCommit)c.getParent(0), (String)p, (ObjectId)d.blobs[0]);
        GitFileRevision nextFile = GitFileRevision.inCommit((Repository)db, (RevCommit)c, (String)p, (ObjectId)d.blobs[1]);
        FileRevisionTypedElement base = new FileRevisionTypedElement((IFileRevision)baseFile);
        FileRevisionTypedElement next = new FileRevisionTypedElement((IFileRevision)nextFile);
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput((ITypedElement)base, (ITypedElement)next, null);
        CompareUI.openCompareEditor((CompareEditorInput)in);
    }

    TreeWalk getTreeWalk() {
        return this.walker;
    }

    void setTreeWalk(TreeWalk walk) {
        this.walker = walk;
    }

    void doSelectAll() {
        Object in = this.getInput();
        if (in == null) {
            return;
        }
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        Object[] el = cp.getElements(in);
        if (el == null || el.length == 0) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection(el));
    }

    void doCopy() {
        ISelection s = this.getSelection();
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        Iterator itr = iss.iterator();
        StringBuilder r = new StringBuilder();
        while (itr.hasNext()) {
            FileDiff d = (FileDiff)itr.next();
            if (r.length() > 0) {
                r.append("\n");
            }
            r.append(d.path);
        }
        this.clipboard.setContents(new Object[]{r.toString()}, new Transfer[]{TextTransfer.getInstance()}, 1);
    }

    private void createColumns(Table rawTable, TableLayout layout) {
        TableColumn mode = new TableColumn(rawTable, 0);
        mode.setResizable(true);
        mode.setText("");
        mode.setWidth(5);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        TableColumn path = new TableColumn(rawTable, 0);
        path.setResizable(true);
        path.setText(UIText.HistoryPage_pathnameColumn);
        path.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
    }
}

