/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.util.Iterator;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.GraphContentProvider;
import org.eclipse.egit.ui.internal.history.GraphLabelProvider;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTPlotRenderer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class CommitGraphTable {
    private final TableViewer table;
    private Clipboard clipboard;
    private final SWTPlotRenderer renderer;
    private final Font nFont = Activator.getFont("org.eclipse.egit.ui.CommitGraphNormalFont");
    private final Font hFont = CommitGraphTable.highlightFont();
    private SWTCommitList allCommits;
    private RevFlag highlight;

    private static Font highlightFont() {
        FontData[] hData;
        Font n = Activator.getFont("org.eclipse.egit.ui.CommitGraphNormalFont");
        Font h = Activator.getFont("org.eclipse.egit.ui.CommitGraphHighlightFont");
        FontData[] nData = n.getFontData();
        if (nData.length != (hData = h.getFontData()).length) {
            return h;
        }
        int i = 0;
        while (i < nData.length) {
            if (!nData[i].equals((Object)hData[i])) {
                return h;
            }
            ++i;
        }
        return Activator.getBoldFont("org.eclipse.egit.ui.CommitGraphNormalFont");
    }

    CommitGraphTable(Composite parent) {
        Table rawTable = new Table(parent, 268503810);
        rawTable.setHeaderVisible(true);
        rawTable.setLinesVisible(false);
        rawTable.setFont(this.nFont);
        TableLayout layout = new TableLayout();
        rawTable.setLayout((Layout)layout);
        this.createColumns(rawTable, layout);
        this.createPaintListener(rawTable);
        this.table = new TableViewer(rawTable){

            protected Widget doFindItem(Object element) {
                return element != null ? ((SWTCommit)((Object)element)).widget : null;
            }

            protected void mapElement(Object element, Widget item) {
                ((SWTCommit)((Object)element)).widget = item;
            }
        };
        this.table.setLabelProvider((IBaseLabelProvider)new GraphLabelProvider());
        this.table.setContentProvider((IContentProvider)new GraphContentProvider());
        this.renderer = new SWTPlotRenderer(rawTable.getDisplay());
        this.clipboard = new Clipboard(rawTable.getDisplay());
        rawTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitGraphTable.this.clipboard.dispose();
            }
        });
    }

    Control getControl() {
        return this.table.getControl();
    }

    void selectCommit(RevCommit c) {
        this.table.setSelection((ISelection)new StructuredSelection((Object)c));
        this.table.reveal((Object)c);
    }

    void addSelectionChangedListener(ISelectionChangedListener l) {
        this.table.addPostSelectionChangedListener(l);
    }

    void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.table.removePostSelectionChangedListener(l);
    }

    boolean canDoCopy() {
        return !this.table.getSelection().isEmpty();
    }

    void doCopy() {
        ISelection s = this.table.getSelection();
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        Iterator itr = iss.iterator();
        StringBuilder r = new StringBuilder();
        while (itr.hasNext()) {
            PlotCommit d = (PlotCommit)itr.next();
            if (r.length() > 0) {
                r.append("\n");
            }
            r.append(d.getId().name());
        }
        this.clipboard.setContents(new Object[]{r.toString()}, new Transfer[]{TextTransfer.getInstance()}, 1);
    }

    void setInput(RevFlag hFlag, SWTCommitList list, SWTCommit[] asArray) {
        SWTCommitList oldList = this.allCommits;
        this.highlight = hFlag;
        this.allCommits = list;
        this.table.setInput((Object)asArray);
        if (asArray != null && asArray.length > 0) {
            if (oldList != list) {
                this.selectCommit((RevCommit)asArray[0]);
            }
        } else {
            this.table.getTable().deselectAll();
        }
    }

    private void createColumns(Table rawTable, TableLayout layout) {
        TableColumn graph = new TableColumn(rawTable, 0);
        graph.setResizable(true);
        graph.setText("");
        graph.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        TableColumn author = new TableColumn(rawTable, 0);
        author.setResizable(true);
        author.setText(UIText.HistoryPage_authorColumn);
        author.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        TableColumn date = new TableColumn(rawTable, 0);
        date.setResizable(true);
        date.setText(UIText.HistoryPage_dateColumn);
        date.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
    }

    private void createPaintListener(Table rawTable) {
        rawTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (event.index >= 0 && event.index <= 2) {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        });
        rawTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                CommitGraphTable.this.doPaint(event);
            }
        });
    }

    void doPaint(Event event) {
        RevCommit c = (RevCommit)((TableItem)event.item).getData();
        if (this.highlight != null && c.has(this.highlight)) {
            event.gc.setFont(this.hFont);
        } else {
            event.gc.setFont(this.nFont);
        }
        if (event.index == 0) {
            this.renderer.paint(event);
            return;
        }
        ITableLabelProvider lbl = (ITableLabelProvider)this.table.getLabelProvider();
        String txt = lbl.getColumnText((Object)c, event.index);
        Point textsz = event.gc.textExtent(txt);
        int texty = (event.height - textsz.y) / 2;
        event.gc.drawString(txt, event.x, event.y + texty, true);
    }

    public TableViewer getTableView() {
        return this.table;
    }
}

