/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.history.CommitNavigationListener;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommitMessageViewer
extends TextViewer
implements ISelectionChangedListener {
    private final ListenerList navListeners = new ListenerList();
    private final DateFormat fmt;
    private PlotCommit<?> commit;
    private Color sys_linkColor;
    private Color sys_darkgray;
    private Cursor sys_linkCursor;
    private Cursor sys_normalCursor;
    private boolean fill;
    private Repository db;
    private TreeWalk walker;
    private DiffFormatter diffFmt = new DiffFormatter();

    CommitMessageViewer(Composite parent) {
        super(parent, 776);
        this.fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        final StyledText t = this.getTextWidget();
        t.setFont(Activator.getFont("org.eclipse.egit.ui.CommitMessageFont"));
        this.sys_linkColor = t.getDisplay().getSystemColor(9);
        this.sys_darkgray = t.getDisplay().getSystemColor(16);
        this.sys_linkCursor = t.getDisplay().getSystemCursor(21);
        this.sys_normalCursor = t.getCursor();
        t.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                int o;
                try {
                    o = t.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    t.setCursor(CommitMessageViewer.this.sys_normalCursor);
                    return;
                }
                StyleRange r = t.getStyleRangeAtOffset(o);
                if (r instanceof ObjectLink) {
                    t.setCursor(CommitMessageViewer.this.sys_linkCursor);
                } else {
                    t.setCursor(CommitMessageViewer.this.sys_normalCursor);
                }
            }
        });
        t.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int o;
                try {
                    o = t.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
                StyleRange r = t.getStyleRangeAtOffset(o);
                if (r instanceof ObjectLink) {
                    RevCommit c = ((ObjectLink)r).targetCommit;
                    Object[] objectArray = CommitMessageViewer.this.navListeners.getListeners();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object l = objectArray[n2];
                        ((CommitNavigationListener)l).showCommit(c);
                        ++n2;
                    }
                }
            }
        });
        this.setTextDoubleClickStrategy((ITextDoubleClickStrategy)new DefaultTextDoubleClickStrategy(), "__dftl_partition_content_type");
        this.activatePlugins();
    }

    void addCommitNavigationListener(CommitNavigationListener l) {
        this.navListeners.add((Object)l);
    }

    void removeCommitNavigationListener(CommitNavigationListener l) {
        this.navListeners.remove((Object)l);
    }

    public void setInput(Object input) {
        this.commit = (PlotCommit)input;
        this.format();
    }

    public Object getInput() {
        return this.commit;
    }

    void setTreeWalk(TreeWalk walk) {
        this.walker = walk;
    }

    private void format() {
        Matcher spm;
        Object p;
        if (this.commit == null) {
            this.setDocument((IDocument)new Document());
            return;
        }
        PersonIdent author = this.commit.getAuthorIdent();
        PersonIdent committer = this.commit.getCommitterIdent();
        StringBuilder d = new StringBuilder();
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        d.append("commit ");
        d.append(this.commit.getId().name());
        d.append("\n");
        if (author != null) {
            d.append("Author: ");
            d.append(author.getName());
            d.append(" <");
            d.append(author.getEmailAddress());
            d.append("> ");
            d.append(this.fmt.format(author.getWhen()));
            d.append("\n");
        }
        if (committer != null) {
            d.append("Committer: ");
            d.append(committer.getName());
            d.append(" <");
            d.append(committer.getEmailAddress());
            d.append("> ");
            d.append(this.fmt.format(committer.getWhen()));
            d.append("\n");
        }
        int i = 0;
        while (i < this.commit.getParentCount()) {
            p = this.commit.getParent(i);
            d.append("Parent: ");
            this.addLink(d, styles, (RevCommit)p);
            d.append(" (");
            d.append(p.getShortMessage());
            d.append(")");
            d.append("\n");
            ++i;
        }
        i = 0;
        while (i < this.commit.getChildCount()) {
            p = this.commit.getChild(i);
            d.append("Child:  ");
            this.addLink(d, styles, (RevCommit)p);
            d.append(" (");
            d.append(p.getShortMessage());
            d.append(")");
            d.append("\n");
            ++i;
        }
        this.makeGrayText(d, styles);
        d.append("\n");
        String msg = this.commit.getFullMessage();
        p = Pattern.compile("\n([A-Z](?:[A-Za-z]+-)+by: [^\n]+)");
        if (this.fill && (spm = ((Pattern)p).matcher(msg)).find()) {
            String subMsg = msg.substring(0, spm.end());
            msg = String.valueOf(subMsg.replaceAll("([\\w.,; \t])\n(\\w)", "$1 $2")) + msg.substring(spm.end());
        }
        int h0 = d.length();
        d.append(msg);
        d.append("\n");
        this.addDiff(d);
        Matcher matcher = ((Pattern)p).matcher(msg);
        while (matcher.find()) {
            styles.add(new StyleRange(h0 + matcher.start(), matcher.end() - matcher.start(), null, null, 2));
        }
        StyleRange[] arr = new StyleRange[styles.size()];
        styles.toArray(arr);
        this.setDocument((IDocument)new Document(d.toString()));
        this.getTextWidget().setStyleRanges(arr);
    }

    private void makeGrayText(StringBuilder d, ArrayList<StyleRange> styles) {
        int p0 = 0;
        int i = 0;
        while (i < styles.size()) {
            StyleRange r = styles.get(i);
            if (p0 < r.start) {
                StyleRange nr = new StyleRange(p0, r.start - p0, this.sys_darkgray, null);
                styles.add(i, nr);
                p0 = r.start;
            } else {
                if (r.foreground == null) {
                    r.foreground = this.sys_darkgray;
                }
                p0 = r.start + r.length;
            }
            ++i;
        }
        if (d.length() - 1 > p0) {
            StyleRange nr = new StyleRange(p0, d.length() - p0, this.sys_darkgray, null);
            styles.add(nr);
        }
    }

    private void addLink(StringBuilder d, ArrayList<StyleRange> styles, RevCommit to) {
        ObjectLink sr = new ObjectLink();
        sr.targetCommit = to;
        sr.foreground = this.sys_linkColor;
        sr.underline = true;
        sr.start = d.length();
        d.append(to.getId().name());
        sr.length = d.length() - sr.start;
        styles.add(sr);
    }

    private void addDiff(StringBuilder d) {
        if (this.commit.getParentCount() != 1) {
            return;
        }
        try {
            FileDiff[] diffs;
            FileDiff[] fileDiffArray = diffs = FileDiff.compute(this.walker, this.commit);
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                FileDiff diff = fileDiffArray[n2];
                if (diff.blobs.length == 2) {
                    this.outputDiff(d, diff);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            Activator.error("Can't get file difference of " + this.commit.getId() + ".", e);
        }
    }

    private void outputDiff(final StringBuilder d, FileDiff fileDiff) throws IOException {
        String path = fileDiff.path;
        ObjectId id1 = fileDiff.blobs[0];
        ObjectId id2 = fileDiff.blobs[1];
        FileMode mode1 = fileDiff.modes[0];
        FileMode mode2 = fileDiff.modes[1];
        d.append(this.formatPathLine(path)).append("\n");
        if (id1.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("new file mode " + mode2).append("\n");
        } else if (id2.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("deleted file mode " + mode1).append("\n");
        } else if (!mode1.equals(mode2)) {
            d.append("old mode " + mode1);
            d.append("new mode " + mode2).append("\n");
        }
        d.append("index ").append(id1.abbreviate(this.db, 7).name()).append("..").append(id2.abbreviate(this.db, 7).name()).append(mode1.equals(mode2) ? " " + mode1 : "").append("\n");
        RawText a = this.getRawText(id1);
        RawText b = this.getRawText(id2);
        MyersDiff diff = new MyersDiff((Sequence)a, (Sequence)b);
        this.diffFmt.formatEdits(new OutputStream(){

            public void write(int b) throws IOException {
                d.append((char)b);
            }
        }, a, b, diff.getEdits());
        d.append("\n");
    }

    private String formatPathLine(String path) {
        int n = 80 - path.length() - 2;
        if (n < 0) {
            return path;
        }
        StringBuilder d = new StringBuilder();
        int i = 0;
        while (i < n / 2) {
            d.append("-");
            ++i;
        }
        d.append(" ").append(path).append(" ");
        while (i < n - 1) {
            d.append("-");
            ++i;
        }
        return d.toString();
    }

    private RawText getRawText(ObjectId id) throws IOException {
        if (id.equals((AnyObjectId)ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        return new RawText(this.db.openBlob(id).getCachedBytes());
    }

    void setWrap(boolean wrap) {
        this.format();
        this.getTextWidget().setWordWrap(wrap);
    }

    void setFill(boolean fill) {
        this.fill = fill;
        this.format();
    }

    public void setDb(Repository db) {
        this.db = db;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel;
        Object obj;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof FileDiff) {
            String path = ((FileDiff)obj).path;
            this.findAndSelect(0, this.formatPathLine(path), true, true, false, false);
        }
    }

    static class ObjectLink
    extends StyleRange {
        RevCommit targetCommit;

        ObjectLink() {
        }

        public boolean similarTo(StyleRange style) {
            if (!(style instanceof ObjectLink)) {
                return false;
            }
            if (this.targetCommit != ((ObjectLink)style).targetCommit) {
                return false;
            }
            return super.similarTo(style);
        }
    }
}

