/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;

class FileDiff {
    final RevCommit commit;
    final String path;
    String change;
    ObjectId[] blobs;
    FileMode[] modes;

    private static ObjectId[] trees(RevCommit commit) {
        ObjectId[] r = new ObjectId[commit.getParentCount() + 1];
        int i = 0;
        while (i < r.length - 1) {
            r[i] = commit.getParent(i).getTree().getId();
            ++i;
        }
        r[r.length - 1] = commit.getTree().getId();
        return r;
    }

    static FileDiff[] compute(TreeWalk walk, RevCommit commit) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        ArrayList<FileDiff> r = new ArrayList<FileDiff>();
        walk.reset((AnyObjectId[])FileDiff.trees(commit));
        int nTree = walk.getTreeCount();
        int myTree = nTree - 1;
        switch (nTree) {
            case 1: {
                FileDiff d;
                while (walk.next()) {
                    d = new FileDiff(commit, walk.getPathString());
                    d.change = "A";
                    d.blobs = new ObjectId[]{walk.getObjectId(0)};
                    d.modes = new FileMode[]{walk.getFileMode(0)};
                    r.add(d);
                }
                break;
            }
            case 2: {
                FileDiff d;
                while (walk.next()) {
                    d = new FileDiff(commit, walk.getPathString());
                    ObjectId id0 = walk.getObjectId(0);
                    ObjectId id1 = walk.getObjectId(1);
                    FileMode fm0 = walk.getFileMode(0);
                    FileMode fm1 = walk.getFileMode(1);
                    d.change = "M";
                    d.blobs = new ObjectId[]{id0, id1};
                    d.modes = new FileMode[]{fm0, fm1};
                    int m0 = walk.getRawMode(0);
                    int m1 = walk.getRawMode(1);
                    if (m0 == 0 && m1 != 0) {
                        d.change = "A";
                    } else if (m0 != 0 && m1 == 0) {
                        d.change = "D";
                    } else if (m0 != m1 && walk.idEqual(0, 1)) {
                        d.change = "T";
                    }
                    r.add(d);
                }
                break;
            }
            default: {
                FileDiff d;
                while (walk.next()) {
                    if (FileDiff.matchAnyParent(walk, myTree)) continue;
                    d = new FileDiff(commit, walk.getPathString());
                    int m0 = 0;
                    int i = 0;
                    while (i < myTree) {
                        m0 |= walk.getRawMode(i);
                        ++i;
                    }
                    int m1 = walk.getRawMode(myTree);
                    d.change = "M";
                    if (m0 == 0 && m1 != 0) {
                        d.change = "A";
                    } else if (m0 != 0 && m1 == 0) {
                        d.change = "D";
                    } else if (m0 != m1 && walk.idEqual(0, myTree)) {
                        d.change = "T";
                    }
                    d.blobs = new ObjectId[nTree];
                    d.modes = new FileMode[nTree];
                    int i2 = 0;
                    while (i2 < nTree) {
                        d.blobs[i2] = walk.getObjectId(i2);
                        d.modes[i2] = walk.getFileMode(i2);
                        ++i2;
                    }
                    r.add(d);
                }
                break block0;
            }
        }
        FileDiff[] tmp = new FileDiff[r.size()];
        r.toArray(tmp);
        return tmp;
    }

    private static boolean matchAnyParent(TreeWalk walk, int myTree) {
        int m = walk.getRawMode(myTree);
        int i = 0;
        while (i < myTree) {
            if (walk.getRawMode(i) == m && walk.idEqual(i, myTree)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    FileDiff(RevCommit c, String p) {
        this.commit = c;
        this.path = p;
    }
}

