/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;

class FileDiffContentProvider
implements IStructuredContentProvider {
    private TreeWalk walk;
    private RevCommit commit;
    private FileDiff[] diff;

    FileDiffContentProvider() {
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        this.walk = ((CommitFileDiffViewer)newViewer).getTreeWalk();
        this.commit = (RevCommit)newInput;
        this.diff = null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.diff == null && this.walk != null && this.commit != null) {
            try {
                this.diff = FileDiff.compute(this.walk, this.commit);
            }
            catch (IOException err) {
                Activator.error("Can't get file difference of " + this.commit.getId() + ".", err);
            }
        }
        return this.diff;
    }

    public void dispose() {
    }
}

