/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;

class GenerateHistoryJob
extends Job {
    private static final int BATCH_SIZE = 256;
    private final GitHistoryPage page;
    private final SWTCommitList allCommits;
    private int lastUpdateCnt;
    private long lastUpdateAt;

    GenerateHistoryJob(GitHistoryPage ghp, SWTCommitList list) {
        super(UIText.HistoryPage_refreshJob);
        this.page = ghp;
        this.allCommits = list;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                while (true) {
                    int oldsz = this.allCommits.size();
                    this.allCommits.fillTo(oldsz + 256 - 1);
                    if (!monitor.isCanceled() && oldsz != this.allCommits.size()) {
                        long now = System.currentTimeMillis();
                        if (now - this.lastUpdateAt < 2000L && this.lastUpdateCnt > 0) continue;
                        this.updateUI();
                        this.lastUpdateAt = now;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                status = new Status(4, Activator.getPluginId(), "Cannot compute Git history.", (Throwable)e);
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.updateUI();
        }
        finally {
            monitor.done();
        }
        return status;
    }

    void updateUI() {
        if (this.allCommits.size() == this.lastUpdateCnt) {
            return;
        }
        SWTCommit[] asArray = new SWTCommit[this.allCommits.size()];
        this.allCommits.toArray((Object[])asArray);
        this.page.showCommitList(this, this.allCommits, asArray);
        this.lastUpdateCnt = this.allCommits.size();
    }
}

