/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.ResourceList;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIPreferences;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.EditableRevision;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.CommitGraphTable;
import org.eclipse.egit.ui.internal.history.CommitMessageViewer;
import org.eclipse.egit.ui.internal.history.CommitNavigationListener;
import org.eclipse.egit.ui.internal.history.FindToolbar;
import org.eclipse.egit.ui.internal.history.GenerateHistoryJob;
import org.eclipse.egit.ui.internal.history.RevObjectSelectionProvider;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTWalk;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.IndexChangedEvent;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefsChangedEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryListener;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHistoryPage
extends HistoryPage
implements RepositoryListener {
    private static final String PREF_COMMENT_WRAP = "resourcehistory_show_comment_wrap";
    private static final String PREF_COMMENT_FILL = "resourcehistory_fill_comment_paragraph";
    private static final String SHOW_COMMENT = "resourcehistory_show_rev_comment";
    private static final String SHOW_FILES = "resourcehistory_show_rev_detail";
    private static final String SPLIT_GRAPH = "resourcehistory_graph_split";
    private static final String SPLIT_INFO = "resourcehistory_rev_split";
    private static final String SHOW_FIND_TOOLBAR = "resourcehistory_show_findtoolbar";
    private static final String POPUP_ID = "org.eclipse.egit.ui.historyPageContributions";
    private IAction compareAction = new CompareWithWorkingTreeAction();
    private IAction compareVersionsAction = new CompareVersionsAction();
    private Preferences prefs;
    private Composite ourControl;
    private SashForm graphDetailSplit;
    private SashForm revInfoSplit;
    private CommitGraphTable graph;
    private CommitMessageViewer commentViewer;
    private CommitFileDiffViewer fileViewer;
    private FindToolbar findToolbar;
    private MenuManager popupMgr;
    private GenerateHistoryJob job;
    private SWTWalk currentWalk;
    private AnyObjectId currentHeadId;
    private Repository db;
    private RevFlag highlightFlag;
    private List<String> pathFilters;
    private RevObjectSelectionProvider revObjectSelectionProvider;
    private static final String PREF_SHOWALLFILTER = "org.eclipse.egit.ui.githistorypage.showallfilter";
    private ShowFilter showAllFilter = ShowFilter.SHOWALLRESOURCE;
    private ShowFilterAction showAllRepoVersionsAction;
    private ShowFilterAction showAllProjectVersionsAction;
    private ShowFilterAction showAllFolderVersionsAction;
    private Runnable refschangedRunnable;

    public static boolean canShowHistoryFor(Object object) {
        if (object instanceof ResourceList) {
            IResource[] array = ((ResourceList)object).getItems();
            if (array.length == 0) {
                return false;
            }
            IResource[] iResourceArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (!GitHistoryPage.typeOk(r)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (object instanceof IResource) {
            return GitHistoryPage.typeOk((IResource)object);
        }
        return false;
    }

    private static boolean typeOk(IResource object) {
        switch (object.getType()) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void createResourceFilterActions() {
        try {
            this.showAllFilter = ShowFilter.valueOf(Activator.getDefault().getPreferenceStore().getString(PREF_SHOWALLFILTER));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.showAllFilter = ShowFilter.SHOWALLRESOURCE;
        }
        this.showAllRepoVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLREPO, UIIcons.FILTERREPO, UIText.HistoryPage_ShowAllVersionsForRepo);
        this.showAllProjectVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLPROJECT, UIIcons.FILTERPROJECT, UIText.HistoryPage_ShowAllVersionsForProject);
        this.showAllFolderVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLFOLDER, UIIcons.FILTERFOLDER, UIText.HistoryPage_ShowAllVersionsForFolder);
        this.showAllRepoVersionsAction.setChecked(this.showAllFilter == this.showAllRepoVersionsAction.filter);
        this.showAllProjectVersionsAction.setChecked(this.showAllFilter == this.showAllProjectVersionsAction.filter);
        this.showAllFolderVersionsAction.setChecked(this.showAllFilter == this.showAllFolderVersionsAction.filter);
        this.getSite().getActionBars().getToolBarManager().add((IContributionItem)new Separator());
        this.getSite().getActionBars().getToolBarManager().add((IAction)this.showAllRepoVersionsAction);
        this.getSite().getActionBars().getToolBarManager().add((IAction)this.showAllProjectVersionsAction);
        this.getSite().getActionBars().getToolBarManager().add((IAction)this.showAllFolderVersionsAction);
    }

    public void createControl(Composite parent) {
        this.prefs = Activator.getDefault().getPluginPreferences();
        this.ourControl = this.createMainPanel(parent);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.ourControl.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.graphDetailSplit = new SashForm(this.ourControl, 512);
        this.graphDetailSplit.setLayoutData((Object)gd);
        this.graph = new CommitGraphTable((Composite)this.graphDetailSplit);
        this.graph.getTableView().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object input = GitHistoryPage.this.getInput();
                if (!(input instanceof IFile)) {
                    return;
                }
                IFile resource = (IFile)input;
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource.getProject());
                String gitPath = mapping.getRepoRelativePath((IResource)resource);
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SWTCommit commit = (SWTCommit)((Object)selection.getFirstElement());
                ITypedElement right = GitHistoryPage.this.getEditableRevision(resource, gitPath, commit);
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(SaveableCompareEditorInput.createFileElement((IFile)resource), right, null);
                GitHistoryPage.this.openInCompare((CompareEditorInput)in);
            }
        });
        this.revInfoSplit = new SashForm((Composite)this.graphDetailSplit, 256);
        this.commentViewer = new CommitMessageViewer((Composite)this.revInfoSplit);
        this.fileViewer = new CommitFileDiffViewer((Composite)this.revInfoSplit);
        this.findToolbar = new FindToolbar(this.ourControl);
        this.layoutSashForm(this.graphDetailSplit, SPLIT_GRAPH);
        this.layoutSashForm(this.revInfoSplit, SPLIT_INFO);
        this.revObjectSelectionProvider = new RevObjectSelectionProvider();
        this.popupMgr = new MenuManager(null, POPUP_ID);
        this.attachCommitSelectionChanged();
        this.createLocalToolbarActions();
        this.createResourceFilterActions();
        this.createStandardActions();
        this.createViewMenu();
        this.finishContextMenu();
        this.attachContextMenu(this.graph.getControl());
        this.attachContextMenu(this.commentViewer.getControl());
        this.attachContextMenu(this.fileViewer.getControl());
        this.layout();
        Repository.addAnyRepositoryChangedListener((RepositoryListener)this);
    }

    private ITypedElement getEditableRevision(IFile resource, String gitPath, SWTCommit commit) {
        ITypedElement right = new EmptyElement(NLS.bind((String)UIText.GitHistoryPage_FileNotInCommit, (Object)resource.getName(), (Object)((Object)commit)));
        try {
            TreeWalk w = TreeWalk.forPath((Repository)this.db, (String)gitPath, (RevTree)commit.getTree());
            if (w != null) {
                GitFileRevision nextFile = GitFileRevision.inCommit((Repository)this.db, (RevCommit)commit, (String)gitPath, null);
                right = new EditableRevision((IFileRevision)nextFile);
            }
        }
        catch (IOException e) {
            Activator.error("IO error looking up path" + gitPath + " in " + commit.getId() + ".", e);
        }
        return right;
    }

    private void openInCompare(CompareEditorInput input) {
        IWorkbenchPage workBenchPage = this.getSite().getPage();
        IEditorPart editor = this.findReusableCompareEditor(input, workBenchPage);
        if (editor != null) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals(input)) {
                if (OpenStrategy.activateOnOpen()) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workBenchPage.bringToTop((IWorkbenchPart)editor);
                }
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                if (OpenStrategy.activateOnOpen()) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workBenchPage.bringToTop((IWorkbenchPart)editor);
                }
            }
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)input);
        }
    }

    private IEditorPart findReusableCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorPart part;
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            part = editorRefs[i].getEditor(false);
            if (part != null && part.getEditorInput() instanceof GitCompareFileRevisionEditorInput && part instanceof IReusableEditor && part.getEditorInput().equals(input)) {
                return part;
            }
            ++i;
        }
        if (GitHistoryPage.isReuseOpenEditor()) {
            i = 0;
            while (i < editorRefs.length) {
                part = editorRefs[i].getEditor(false);
                if (part != null && part.getEditorInput() instanceof SaveableCompareEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                    return part;
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean isReuseOpenEditor() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.reuse_open_compare_editors");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refsChanged(RefsChangedEvent e) {
        if (e.getRepository() != this.db) {
            return;
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        GitHistoryPage gitHistoryPage = this;
        synchronized (gitHistoryPage) {
            if (this.refschangedRunnable == null) {
                this.refschangedRunnable = new Runnable(){

                    public void run() {
                        if (!GitHistoryPage.this.getControl().isDisposed()) {
                            Activator.trace("Executing async repository changed event");
                            GitHistoryPage.this.refschangedRunnable = null;
                            GitHistoryPage.this.inputSet();
                        }
                    }
                };
                this.getControl().getDisplay().asyncExec(this.refschangedRunnable);
            }
        }
    }

    public void indexChanged(IndexChangedEvent e) {
    }

    private void finishContextMenu() {
        this.popupMgr.add((IContributionItem)new Separator());
        this.popupMgr.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu(POPUP_ID, this.popupMgr, (ISelectionProvider)this.revObjectSelectionProvider);
        this.getHistoryPageSite().getPart().getSite().setSelectionProvider((ISelectionProvider)this.revObjectSelectionProvider);
    }

    private void attachContextMenu(Control c) {
        c.setMenu(this.popupMgr.createContextMenu(c));
        this.popupMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GitHistoryPage.this.popupMgr.remove((IContributionItem)new ActionContributionItem(GitHistoryPage.this.compareAction));
                GitHistoryPage.this.popupMgr.remove((IContributionItem)new ActionContributionItem(GitHistoryPage.this.compareVersionsAction));
                int size = ((IStructuredSelection)GitHistoryPage.this.revObjectSelectionProvider.getSelection()).size();
                if (IFile.class.isAssignableFrom(GitHistoryPage.this.getInput().getClass())) {
                    if (size == 1) {
                        GitHistoryPage.this.popupMgr.add(GitHistoryPage.this.compareAction);
                    } else if (size == 2) {
                        GitHistoryPage.this.popupMgr.add(GitHistoryPage.this.compareVersionsAction);
                    }
                }
            }
        });
    }

    private void layoutSashForm(final SashForm sf, final String key) {
        sf.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int[] w = sf.getWeights();
                UIPreferences.setValue(GitHistoryPage.this.prefs, key, w);
            }
        });
        sf.setWeights(UIPreferences.getIntArray(this.prefs, key, 2));
    }

    private Composite createMainPanel(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.verticalSpacing = 0;
        c.setLayout((Layout)parentLayout);
        return c;
    }

    private void layout() {
        boolean showComment = this.prefs.getBoolean(SHOW_COMMENT);
        boolean showFiles = this.prefs.getBoolean(SHOW_FILES);
        boolean showFindToolbar = this.prefs.getBoolean(SHOW_FIND_TOOLBAR);
        if (showComment && showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(null);
        } else if (showComment && !showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(this.commentViewer.getControl());
        } else if (!showComment && showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(this.fileViewer.getControl());
        } else if (!showComment && !showFiles) {
            this.graphDetailSplit.setMaximizedControl(this.graph.getControl());
        }
        if (showFindToolbar) {
            ((GridData)this.findToolbar.getLayoutData()).heightHint = -1;
        } else {
            ((GridData)this.findToolbar.getLayoutData()).heightHint = 0;
            this.findToolbar.clear();
        }
        this.ourControl.layout();
    }

    private void attachCommitSelectionChanged() {
        this.graph.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    GitHistoryPage.this.commentViewer.setInput(null);
                    GitHistoryPage.this.fileViewer.setInput(null);
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)s;
                PlotCommit c = (PlotCommit)sel.getFirstElement();
                GitHistoryPage.this.commentViewer.setInput(c);
                GitHistoryPage.this.fileViewer.setInput(c);
                GitHistoryPage.this.revObjectSelectionProvider.setSelection(s);
            }
        });
        this.commentViewer.addCommitNavigationListener(new CommitNavigationListener(){

            public void showCommit(RevCommit c) {
                GitHistoryPage.this.graph.selectCommit(c);
            }
        });
        this.findToolbar.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                GitHistoryPage.this.graph.selectCommit((RevCommit)event.data);
            }
        });
    }

    private void createLocalToolbarActions() {
        IToolBarManager barManager = this.getSite().getActionBars().getToolBarManager();
        IAction a = this.createFindToolbarAction();
        barManager.add(a);
    }

    private IAction createFindToolbarAction() {
        Action r = new Action("Fi", UIIcons.ELCL16_FIND){

            public void run() {
                GitHistoryPage.this.prefs.setValue(GitHistoryPage.SHOW_FIND_TOOLBAR, this.isChecked());
                GitHistoryPage.this.layout();
            }
        };
        r.setChecked(this.prefs.getBoolean(SHOW_FIND_TOOLBAR));
        r.setToolTipText(UIText.HistoryPage_findbar_findTooltip);
        return r;
    }

    private void createViewMenu() {
        IActionBars actionBars = this.getSite().getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        IAction a = this.createCommentWrap();
        menuManager.add(a);
        this.popupMgr.add(a);
        a = this.createCommentFill();
        menuManager.add(a);
        this.popupMgr.add(a);
        menuManager.add((IContributionItem)new Separator());
        this.popupMgr.add((IContributionItem)new Separator());
        a = this.createShowComment();
        menuManager.add(a);
        this.popupMgr.add(a);
        a = this.createShowFiles();
        menuManager.add(a);
        this.popupMgr.add(a);
        menuManager.add((IContributionItem)new Separator());
        this.popupMgr.add((IContributionItem)new Separator());
    }

    private IAction createCommentWrap() {
        BooleanPrefAction a = new BooleanPrefAction(PREF_COMMENT_WRAP, UIText.ResourceHistory_toggleCommentWrap){

            void apply(boolean wrap) {
                GitHistoryPage.this.commentViewer.setWrap(wrap);
            }
        };
        a.apply(a.isChecked());
        return a;
    }

    private IAction createCommentFill() {
        BooleanPrefAction a = new BooleanPrefAction(PREF_COMMENT_FILL, UIText.ResourceHistory_toggleCommentFill){

            void apply(boolean fill) {
                GitHistoryPage.this.commentViewer.setFill(fill);
            }
        };
        a.apply(a.isChecked());
        return a;
    }

    private IAction createShowComment() {
        return new BooleanPrefAction(SHOW_COMMENT, UIText.ResourceHistory_toggleRevComment){

            void apply(boolean value) {
                GitHistoryPage.this.layout();
            }
        };
    }

    private IAction createShowFiles() {
        return new BooleanPrefAction(SHOW_FILES, UIText.ResourceHistory_toggleRevDetail){

            void apply(boolean value) {
                GitHistoryPage.this.layout();
            }
        };
    }

    private void createStandardActions() {
        TextAction copy = new TextAction(4);
        TextAction sAll = new TextAction(7);
        this.graph.getControl().addFocusListener((FocusListener)copy);
        this.graph.getControl().addFocusListener((FocusListener)sAll);
        this.graph.addSelectionChangedListener(copy);
        this.graph.addSelectionChangedListener(sAll);
        this.commentViewer.getControl().addFocusListener((FocusListener)copy);
        this.commentViewer.getControl().addFocusListener((FocusListener)sAll);
        this.commentViewer.addSelectionChangedListener(copy);
        this.commentViewer.addSelectionChangedListener(sAll);
        this.fileViewer.getControl().addFocusListener((FocusListener)copy);
        this.fileViewer.getControl().addFocusListener((FocusListener)sAll);
        this.fileViewer.addSelectionChangedListener(copy);
        this.fileViewer.addSelectionChangedListener(sAll);
        IActionBars b = this.getSite().getActionBars();
        b.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)copy);
        b.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)sAll);
        this.popupMgr.add(this.createStandardAction(ActionFactory.COPY));
        this.popupMgr.add(this.createStandardAction(ActionFactory.SELECT_ALL));
        this.popupMgr.add((IContributionItem)new Separator());
    }

    private IAction createStandardAction(ActionFactory af) {
        IPageSite s = this.getSite();
        ActionFactory.IWorkbenchAction a = af.create(s.getWorkbenchWindow());
        if (af instanceof IPartListener) {
            ((IPartListener)a).partActivated(s.getPage().getActivePart());
        }
        return a;
    }

    public void dispose() {
        Repository.removeAnyRepositoryChangedListener((RepositoryListener)this);
        this.cancelRefreshJob();
        if (this.popupMgr != null) {
            IContributionItem i;
            IContributionItem[] iContributionItemArray = this.popupMgr.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                i = iContributionItemArray[n2];
                if (i instanceof ActionFactory.IWorkbenchAction) {
                    ((ActionFactory.IWorkbenchAction)i).dispose();
                }
                ++n2;
            }
            iContributionItemArray = this.getSite().getActionBars().getMenuManager().getItems();
            n = iContributionItemArray.length;
            n2 = 0;
            while (n2 < n) {
                i = iContributionItemArray[n2];
                if (i instanceof ActionFactory.IWorkbenchAction) {
                    ((ActionFactory.IWorkbenchAction)i).dispose();
                }
                ++n2;
            }
        }
        Activator.getDefault().savePluginPreferences();
        super.dispose();
    }

    public void refresh() {
        this.inputSet();
    }

    public void setFocus() {
        this.graph.getControl().setFocus();
    }

    public Control getControl() {
        return this.ourControl;
    }

    public Object getInput() {
        ResourceList r = (ResourceList)super.getInput();
        if (r == null) {
            return null;
        }
        IResource[] in = r.getItems();
        if (in == null || in.length == 0) {
            return null;
        }
        if (in.length == 1) {
            return in[0];
        }
        return r;
    }

    public boolean setInput(Object o) {
        Object in = o instanceof IResource ? new ResourceList(new IResource[]{(IResource)o}) : (o instanceof ResourceList ? o : null);
        return super.setInput(in);
    }

    public boolean inputSet() {
        ObjectId headId;
        if (this.revObjectSelectionProvider != null) {
            this.revObjectSelectionProvider.setActiveRepository(null);
        }
        this.cancelRefreshJob();
        if (this.graph == null) {
            return false;
        }
        IResource[] in = ((ResourceList)super.getInput()).getItems();
        if (in == null || in.length == 0) {
            return false;
        }
        this.db = null;
        ArrayList<String> paths = new ArrayList<String>(in.length);
        IResource[] iResourceArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            RepositoryMapping map = RepositoryMapping.getMapping((IResource)r);
            if (map != null) {
                String name;
                if (this.db == null) {
                    this.db = map.getRepository();
                } else if (this.db != map.getRepository()) {
                    return false;
                }
                if (this.showAllFilter == ShowFilter.SHOWALLFOLDER) {
                    name = map.getRepoRelativePath((IResource)r.getParent());
                    if (name != null && name.length() > 0) {
                        paths.add(name);
                    }
                } else if (this.showAllFilter == ShowFilter.SHOWALLPROJECT) {
                    name = map.getRepoRelativePath((IResource)r.getProject());
                    if (name != null && name.length() > 0) {
                        paths.add(name);
                    }
                } else if (this.showAllFilter != ShowFilter.SHOWALLREPO && (name = map.getRepoRelativePath(r)) != null && name.length() > 0) {
                    paths.add(name);
                }
            }
            ++n2;
        }
        if (this.db == null) {
            return false;
        }
        try {
            headId = this.db.resolve("HEAD");
        }
        catch (IOException e) {
            Activator.logError("Cannot parse HEAD in: " + this.db.getDirectory().getAbsolutePath(), e);
            return false;
        }
        if (this.currentWalk == null || this.currentWalk.getRepository() != this.db || this.pathChange(this.pathFilters, paths) || headId != null && !headId.equals(this.currentHeadId)) {
            this.currentWalk = new SWTWalk(this.db);
            this.currentWalk.sort(RevSort.COMMIT_TIME_DESC, true);
            this.currentWalk.sort(RevSort.BOUNDARY, true);
            this.highlightFlag = this.currentWalk.newFlag("highlight");
        } else {
            this.currentWalk.reset();
        }
        if (headId == null) {
            return false;
        }
        try {
            this.currentWalk.markStart(this.currentWalk.parseCommit((AnyObjectId)headId));
        }
        catch (IOException e) {
            Activator.logError("Cannot read HEAD commit " + headId + " in: " + this.db.getDirectory().getAbsolutePath(), e);
            return false;
        }
        TreeWalk fileWalker = new TreeWalk(this.db);
        fileWalker.setRecursive(true);
        if (paths.size() > 0) {
            this.pathFilters = paths;
            this.currentWalk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(paths), (TreeFilter)TreeFilter.ANY_DIFF));
            fileWalker.setFilter(this.currentWalk.getTreeFilter().clone());
        } else {
            this.pathFilters = null;
            this.currentWalk.setTreeFilter(TreeFilter.ALL);
            fileWalker.setFilter(TreeFilter.ANY_DIFF);
        }
        this.fileViewer.setTreeWalk(fileWalker);
        this.fileViewer.addSelectionChangedListener(this.commentViewer);
        this.commentViewer.setTreeWalk(fileWalker);
        this.commentViewer.setDb(this.db);
        this.findToolbar.clear();
        this.graph.setInput(this.highlightFlag, null, null);
        SWTCommitList list = new SWTCommitList(this.graph.getControl().getDisplay());
        list.source((RevWalk)this.currentWalk);
        final GenerateHistoryJob rj = new GenerateHistoryJob(this, list);
        final Repository fdb = this.db;
        rj.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                GitHistoryPage.this.revObjectSelectionProvider.setActiveRepository(fdb);
                Control graphctl = GitHistoryPage.this.graph.getControl();
                if (GitHistoryPage.this.job != rj || graphctl.isDisposed()) {
                    return;
                }
                graphctl.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (GitHistoryPage.this.job == rj) {
                            GitHistoryPage.this.job = null;
                        }
                    }
                });
            }
        });
        this.job = rj;
        this.schedule(rj);
        return true;
    }

    private void cancelRefreshJob() {
        if (this.job != null && this.job.getState() != 0) {
            this.job.cancel();
            this.job = null;
            this.currentWalk = null;
            this.highlightFlag = null;
            this.pathFilters = null;
        }
    }

    private boolean pathChange(List<String> o, List<String> n) {
        if (o == null) {
            return !n.isEmpty();
        }
        return !o.equals(n);
    }

    private void schedule(Job j) {
        IWorkbenchSiteProgressService p;
        IWorkbenchPartSite site = this.getWorkbenchSite();
        if (site != null && (p = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            p.schedule(j, 0L, true);
            return;
        }
        j.schedule();
    }

    void showCommitList(final Job j, final SWTCommitList list, final SWTCommit[] asArray) {
        if (this.job != j || this.graph.getControl().isDisposed()) {
            return;
        }
        this.graph.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!GitHistoryPage.this.graph.getControl().isDisposed() && GitHistoryPage.this.job == j) {
                    GitHistoryPage.this.graph.setInput(GitHistoryPage.this.highlightFlag, list, asArray);
                    GitHistoryPage.this.findToolbar.setInput(GitHistoryPage.this.highlightFlag, GitHistoryPage.this.graph.getTableView().getTable(), asArray);
                }
            }
        });
    }

    private IWorkbenchPartSite getWorkbenchSite() {
        IWorkbenchPart part = this.getHistoryPageSite().getPart();
        return part != null ? part.getSite() : null;
    }

    public boolean isValidInput(Object object) {
        return GitHistoryPage.canShowHistoryFor(object);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getName() {
        ResourceList in = (ResourceList)super.getInput();
        if (this.currentWalk == null || in == null) {
            return "";
        }
        IResource[] items = in.getItems();
        if (items.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(items[0].getProject().getName());
        if (this.currentWalk.getRevFilter() != RevFilter.ALL) {
            b.append(": ");
            b.append(this.currentWalk.getRevFilter());
        }
        if (this.currentWalk.getTreeFilter() != TreeFilter.ALL) {
            b.append(":");
            for (String p : this.pathFilters) {
                b.append(' ');
                b.append(p);
            }
        }
        return b.toString();
    }

    public String getDescription() {
        return this.getName();
    }

    private abstract class BooleanPrefAction
    extends Action
    implements Preferences.IPropertyChangeListener,
    ActionFactory.IWorkbenchAction {
        private final String prefName;

        BooleanPrefAction(String pn, String text) {
            this.setText(text);
            this.prefName = pn;
            GitHistoryPage.this.prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
            this.setChecked(GitHistoryPage.this.prefs.getBoolean(this.prefName));
        }

        public void run() {
            GitHistoryPage.this.prefs.setValue(this.prefName, this.isChecked());
            this.apply(this.isChecked());
        }

        abstract void apply(boolean var1);

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (this.prefName.equals(event.getProperty())) {
                this.setChecked(GitHistoryPage.this.prefs.getBoolean(this.prefName));
                this.apply(this.isChecked());
            }
        }

        public void dispose() {
            GitHistoryPage.this.prefs.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
    }

    private class CompareVersionsAction
    extends Action {
        public CompareVersionsAction() {
            super(UIText.GitHistoryPage_CompareVersions);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)GitHistoryPage.this.revObjectSelectionProvider.getSelection();
            if (selection.size() == 2) {
                Iterator it = selection.iterator();
                SWTCommit commit1 = (SWTCommit)((Object)it.next());
                SWTCommit commit2 = (SWTCommit)((Object)it.next());
                if (GitHistoryPage.this.getInput() instanceof IFile) {
                    IFile resource = (IFile)GitHistoryPage.this.getInput();
                    RepositoryMapping map = RepositoryMapping.getMapping((IResource)resource);
                    String gitPath = map.getRepoRelativePath((IResource)resource);
                    ITypedElement base = GitHistoryPage.this.getEditableRevision(resource, gitPath, commit1);
                    ITypedElement next = GitHistoryPage.this.getEditableRevision(resource, gitPath, commit2);
                    GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
                    GitHistoryPage.this.openInCompare((CompareEditorInput)in);
                }
            }
        }

        public boolean isEnabled() {
            int size = ((IStructuredSelection)GitHistoryPage.this.revObjectSelectionProvider.getSelection()).size();
            return IFile.class.isAssignableFrom(GitHistoryPage.this.getInput().getClass()) && size == 2;
        }
    }

    private class CompareWithWorkingTreeAction
    extends Action {
        public CompareWithWorkingTreeAction() {
            super(UIText.GitHistoryPage_CompareWithWorking);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)GitHistoryPage.this.revObjectSelectionProvider.getSelection();
            if (selection.size() == 1) {
                Iterator it = selection.iterator();
                SWTCommit commit = (SWTCommit)((Object)it.next());
                if (GitHistoryPage.this.getInput() instanceof IFile) {
                    IFile file = (IFile)GitHistoryPage.this.getInput();
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file.getProject());
                    String gitPath = mapping.getRepoRelativePath((IResource)file);
                    ITypedElement right = GitHistoryPage.this.getEditableRevision(file, gitPath, commit);
                    GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(SaveableCompareEditorInput.createFileElement((IFile)file), right, null);
                    GitHistoryPage.this.openInCompare((CompareEditorInput)in);
                }
            }
        }

        public boolean isEnabled() {
            int size = ((IStructuredSelection)GitHistoryPage.this.revObjectSelectionProvider.getSelection()).size();
            return IFile.class.isAssignableFrom(GitHistoryPage.this.getInput().getClass()) && size == 1;
        }
    }

    private class EmptyElement
    implements ITypedElement {
        private String name;

        public EmptyElement(String name) {
            this.name = name;
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ShowFilter {
        SHOWALLRESOURCE,
        SHOWALLFOLDER,
        SHOWALLPROJECT,
        SHOWALLREPO;

    }

    class ShowFilterAction
    extends Action {
        private final ShowFilter filter;

        ShowFilterAction(ShowFilter filter, ImageDescriptor icon, String toolTipText) {
            super(null, 2);
            this.filter = filter;
            this.setImageDescriptor(icon);
            this.setToolTipText(toolTipText);
        }

        public void run() {
            if (!this.isChecked() && GitHistoryPage.this.showAllFilter == this.filter) {
                GitHistoryPage.this.showAllFilter = ShowFilter.SHOWALLRESOURCE;
                GitHistoryPage.this.refresh();
            }
            if (this.isChecked() && GitHistoryPage.this.showAllFilter != this.filter) {
                GitHistoryPage.this.showAllFilter = this.filter;
                if (this != GitHistoryPage.this.showAllRepoVersionsAction) {
                    GitHistoryPage.this.showAllRepoVersionsAction.setChecked(false);
                }
                if (this != GitHistoryPage.this.showAllProjectVersionsAction) {
                    GitHistoryPage.this.showAllProjectVersionsAction.setChecked(false);
                }
                if (this != GitHistoryPage.this.showAllFolderVersionsAction) {
                    GitHistoryPage.this.showAllFolderVersionsAction.setChecked(false);
                }
                GitHistoryPage.this.refresh();
            }
            Activator.getDefault().getPreferenceStore().setValue(GitHistoryPage.PREF_SHOWALLFILTER, GitHistoryPage.this.showAllFilter.toString());
        }

        public String toString() {
            return "ShowFilter[" + this.filter.toString() + "]";
        }
    }

    private class TextAction
    extends Action
    implements FocusListener,
    ISelectionChangedListener {
        private final int op;

        TextAction(int operationCode) {
            this.op = operationCode;
            this.setEnabled(false);
        }

        public void run() {
            if (GitHistoryPage.this.commentViewer.getTextWidget().isFocusControl()) {
                if (GitHistoryPage.this.commentViewer.canDoOperation(this.op)) {
                    GitHistoryPage.this.commentViewer.doOperation(this.op);
                }
            } else if (GitHistoryPage.this.fileViewer.getTable().isFocusControl()) {
                switch (this.op) {
                    case 4: {
                        GitHistoryPage.this.fileViewer.doCopy();
                        break;
                    }
                    case 7: {
                        GitHistoryPage.this.fileViewer.doSelectAll();
                    }
                }
            } else if (GitHistoryPage.this.graph.getControl().isFocusControl()) {
                switch (this.op) {
                    case 4: {
                        GitHistoryPage.this.graph.doCopy();
                    }
                }
            }
        }

        private void update() {
            if (GitHistoryPage.this.commentViewer.getTextWidget().isFocusControl()) {
                this.setEnabled(GitHistoryPage.this.commentViewer.canDoOperation(this.op));
            } else if (GitHistoryPage.this.fileViewer.getTable().isFocusControl()) {
                switch (this.op) {
                    case 4: {
                        this.setEnabled(!GitHistoryPage.this.fileViewer.getSelection().isEmpty());
                        break;
                    }
                    case 7: {
                        this.setEnabled(GitHistoryPage.this.fileViewer.getTable().getItemCount() > 0);
                    }
                }
            } else if (GitHistoryPage.this.graph.getControl().isFocusControl()) {
                switch (this.op) {
                    case 4: {
                        this.setEnabled(GitHistoryPage.this.graph.canDoCopy());
                        break;
                    }
                    case 7: {
                        this.setEnabled(false);
                    }
                }
            }
        }

        public void focusGained(FocusEvent e) {
            this.update();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.update();
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

