/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.graphics.Image;

class GraphLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider {
    private final DateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private RevCommit lastCommit;
    private PersonIdent lastAuthor;

    GraphLabelProvider() {
    }

    public String getColumnText(Object element, int columnIndex) {
        RevCommit c = (RevCommit)element;
        if (columnIndex == 0) {
            return c.getShortMessage();
        }
        PersonIdent author = this.authorOf(c);
        if (author != null) {
            switch (columnIndex) {
                case 1: {
                    return String.valueOf(author.getName()) + " <" + author.getEmailAddress() + ">";
                }
                case 2: {
                    return this.fmt.format(author.getWhen());
                }
            }
        }
        return "";
    }

    private PersonIdent authorOf(RevCommit c) {
        if (this.lastCommit != c) {
            this.lastCommit = c;
            this.lastAuthor = c.getAuthorIdent();
        }
        return this.lastAuthor;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

