/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.preferences.StorageSizeFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WindowCachePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;

    public WindowCachePreferencePage() {
        super(1);
        this.setTitle(UIText.WindowCachePreferencePage_title);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new StorageSizeFieldEditor("core_packedGitWindowSize", UIText.WindowCachePreferencePage_packedGitWindowSize, this.getFieldEditorParent(), 512, 0x8000000){

            protected boolean checkValue(int number) {
                return super.checkValue(number) && Integer.bitCount(number) == 1;
            }
        });
        this.addField((FieldEditor)new StorageSizeFieldEditor("core_packedGitLimit", UIText.WindowCachePreferencePage_packedGitLimit, this.getFieldEditorParent(), 512, 0x40000000));
        this.addField((FieldEditor)new StorageSizeFieldEditor("core_deltaBaseCacheLimit", UIText.WindowCachePreferencePage_deltaBaseCacheLimit, this.getFieldEditorParent(), 512, 0x40000000));
        this.addField((FieldEditor)new BooleanFieldEditor("core_packedGitMMAP", UIText.WindowCachePreferencePage_packedGitMMAP, this.getFieldEditorParent()));
    }

    public boolean performOk() {
        Activator.getDefault().savePluginPreferences();
        GitProjectData.reconfigureWindowCache();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

