/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.RefSpecPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.components.SelectionChangeListener;
import org.eclipse.egit.ui.internal.push.PushResultTable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfirmationPage
extends WizardPage {
    private final Repository local;
    private final RepositorySelectionPage repoPage;
    private final RefSpecPage refSpecPage;
    private RepositorySelection displayedRepoSelection;
    private List<RefSpec> displayedRefSpecs;
    private PushOperationResult confirmedResult;
    private PushResultTable resultPanel;
    private Button requireUnchangedButton;
    private Button showOnlyIfChanged;

    static Collection<RemoteRefUpdate> copyUpdates(Collection<RemoteRefUpdate> refUpdates) throws IOException {
        ArrayList<RemoteRefUpdate> copy = new ArrayList<RemoteRefUpdate>(refUpdates.size());
        for (RemoteRefUpdate rru : refUpdates) {
            copy.add(new RemoteRefUpdate(rru, null));
        }
        return copy;
    }

    public ConfirmationPage(Repository local, RepositorySelectionPage repoPage, RefSpecPage refSpecPage) {
        super(ConfirmationPage.class.getName());
        this.local = local;
        this.repoPage = repoPage;
        this.refSpecPage = refSpecPage;
        this.setTitle(UIText.ConfirmationPage_title);
        this.setDescription(UIText.ConfirmationPage_description);
        SelectionChangeListener listener = new SelectionChangeListener(){

            public void selectionChanged() {
                ConfirmationPage.this.checkPreviousPagesSelections();
            }
        };
        repoPage.addSelectionListener(listener);
        refSpecPage.addSelectionListener(listener);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        this.resultPanel = new PushResultTable(panel);
        Control tableControl = this.resultPanel.getControl();
        tableControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.requireUnchangedButton = new Button(panel, 32);
        this.requireUnchangedButton.setText(UIText.ConfirmationPage_requireUnchangedButton);
        this.showOnlyIfChanged = new Button(panel, 32);
        this.showOnlyIfChanged.setText(UIText.ConfirmationPage_showOnlyIfChanged);
        this.setControl((Control)panel);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.revalidate();
        }
        super.setVisible(visible);
    }

    boolean isConfirmed() {
        return this.confirmedResult != null;
    }

    PushOperationResult getConfirmedResult() {
        return this.confirmedResult;
    }

    boolean isRequireUnchangedSelected() {
        return this.requireUnchangedButton.getSelection();
    }

    boolean isShowOnlyIfChangedSelected() {
        return this.showOnlyIfChanged.getSelection();
    }

    private void checkPreviousPagesSelections() {
        if (!this.repoPage.selectionEquals(this.displayedRepoSelection) || !this.refSpecPage.specsSelectionEquals(this.displayedRefSpecs)) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(this.confirmedResult != null);
        }
    }

    private void revalidate() {
        this.resultPanel.setData(this.local, null);
        this.confirmedResult = null;
        this.displayedRepoSelection = this.repoPage.getSelection();
        this.displayedRefSpecs = this.refSpecPage.getRefSpecs();
        this.setErrorMessage(null);
        this.setPageComplete(false);
        this.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ConfirmationPage.this.revalidateImpl();
            }
        });
    }

    private void revalidateImpl() {
        PushOperation operation;
        if (this.getControl().isDisposed() || !this.isCurrentPage()) {
            return;
        }
        List fetchSpecs = this.displayedRepoSelection.isConfigSelected() ? this.displayedRepoSelection.getConfig().getFetchRefSpecs() : null;
        try {
            Collection updates = Transport.findRemoteRefUpdatesFor((Repository)this.local, this.displayedRefSpecs, (Collection)fetchSpecs);
            if (updates.isEmpty()) {
                this.setErrorMessage(UIText.ConfirmationPage_errorRefsChangedNoMatch);
                this.setPageComplete(false);
                return;
            }
            PushOperationSpecification spec = new PushOperationSpecification();
            for (URIish uri : this.displayedRepoSelection.getAllURIs()) {
                spec.addURIRefUpdates(uri, ConfirmationPage.copyUpdates(updates));
            }
            operation = new PushOperation(this.local, spec, true, this.displayedRepoSelection.getConfig());
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (IOException e) {
            this.setErrorMessage(NLS.bind((String)UIText.ConfirmationPage_errorCantResolveSpecs, (Object)e.getMessage()));
            return;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(NLS.bind((String)UIText.ConfirmationPage_errorUnexpected, (Object)e.getCause().getMessage()));
            return;
        }
        catch (InterruptedException interruptedException) {
            this.setErrorMessage(UIText.ConfirmationPage_errorInterrupted);
            this.setPageComplete(true);
            this.displayedRefSpecs = null;
            this.displayedRepoSelection = null;
            return;
        }
        PushOperationResult result = operation.getOperationResult();
        this.resultPanel.setData(this.local, result);
        if (result.isSuccessfulConnectionForAnyURI()) {
            this.setPageComplete(true);
            this.confirmedResult = result;
        } else {
            String message = NLS.bind((String)UIText.ConfirmationPage_cantConnectToAny, (Object)result.getErrorStringForAllURis());
            this.setErrorMessage(message);
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.ConfirmationPage_cantConnectToAnyTitle, null, (IStatus)new Status(4, Activator.getPluginId(), message));
        }
    }
}

