/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.push.PushResultTable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class PushResultDialog
extends Dialog {
    private final Repository localDb;
    private final PushOperationResult result;
    private final String destinationString;

    PushResultDialog(Shell parentShell, Repository localDb, PushOperationResult result, String destinationString) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.localDb = localDb;
        this.result = result;
        this.destinationString = destinationString;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        label.setText(NLS.bind((String)UIText.ResultDialog_label, (Object)this.destinationString));
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        PushResultTable table = new PushResultTable(composite);
        table.setData(this.localDb, this.result);
        Control tableControl = table.getControl();
        GridData tableLayout = new GridData(4, 4, true, true);
        tableLayout.widthHint = 650;
        tableLayout.heightHint = 300;
        tableControl.setLayoutData((Object)tableLayout);
        this.getShell().setText(NLS.bind((String)UIText.ResultDialog_title, (Object)this.destinationString));
        return composite;
    }
}

