/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.CenteredImageLabelProvider;
import org.eclipse.egit.ui.internal.push.RefUpdateContentProvider;
import org.eclipse.egit.ui.internal.push.RefUpdateElement;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

class PushResultTable {
    private static final int TABLE_PREFERRED_WIDTH = 650;
    private static final int TABLE_PREFERRED_HEIGHT = 300;
    private static final int COLUMN_STATUS_WEIGHT = 40;
    private static final int COLUMN_DST_WEIGHT = 40;
    private static final int COLUMN_SRC_WEIGHT = 40;
    private static final int COLUMN_MODE_WEIGHT = 15;
    private static final String IMAGE_DELETE = "MODE_DELETE";
    private static final String IMAGE_ADD = "MODE_ADD";
    private static final String COLOR_REJECTED_KEY = "REJECTED";
    private static final RGB COLOR_REJECTED = new RGB(255, 0, 0);
    private static final String COLOR_UPDATED_KEY = "UPDATED";
    private static final RGB COLOR_UPDATED = new RGB(0, 255, 0);
    private static final String COLOR_UP_TO_DATE_KEY = "UP_TO_DATE";
    private static final RGB COLOR_UP_TO_DATE = new RGB(245, 245, 245);
    private final TableViewer tableViewer;
    private final Composite tablePanel;
    private final ImageRegistry imageRegistry;
    private final ColorRegistry colorRegistry;

    PushResultTable(Composite parent) {
        this.tablePanel = new Composite(parent, 0);
        this.tablePanel.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 300;
        layoutData.widthHint = 650;
        this.tableViewer = new TableViewer(this.tablePanel);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.imageRegistry = new ImageRegistry(table.getDisplay());
        this.imageRegistry.put(IMAGE_ADD, UIIcons.ELCL16_ADD);
        this.imageRegistry.put(IMAGE_DELETE, UIIcons.ELCL16_DELETE);
        this.colorRegistry = new ColorRegistry(table.getDisplay());
        this.colorRegistry.put(COLOR_REJECTED_KEY, COLOR_REJECTED);
        this.colorRegistry.put(COLOR_UPDATED_KEY, COLOR_UPDATED);
        this.colorRegistry.put(COLOR_UP_TO_DATE_KEY, COLOR_UP_TO_DATE);
        this.tablePanel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PushResultTable.this.imageRegistry.dispose();
            }
        });
        this.tableViewer.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                return a == b;
            }

            public int hashCode(Object element) {
                return element.hashCode();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new RefUpdateContentProvider());
        this.tableViewer.setInput(null);
    }

    void setData(Repository localDb, PushOperationResult result) {
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.dispose();
            ++n2;
        }
        this.tableViewer.setInput(null);
        TableColumnLayout layout = new TableColumnLayout();
        this.tablePanel.setLayout((Layout)layout);
        TableViewerColumn modeViewer = this.createColumn(layout, UIText.PushResultTable_columnMode, 15, 0x1000000);
        modeViewer.setLabelProvider((CellLabelProvider)new CenteredImageLabelProvider(){

            public Image getImage(Object element) {
                if (((RefUpdateElement)element).isDelete()) {
                    return PushResultTable.this.imageRegistry.get(PushResultTable.IMAGE_DELETE);
                }
                return PushResultTable.this.imageRegistry.get(PushResultTable.IMAGE_ADD);
            }

            public String getToolTipText(Object element) {
                if (((RefUpdateElement)element).isDelete()) {
                    return UIText.RefSpecPanel_modeDeleteDescription;
                }
                return UIText.RefSpecPanel_modeUpdateDescription;
            }
        });
        TableViewerColumn srcViewer = this.createColumn(layout, UIText.PushResultTable_columnSrc, 40, 16384);
        srcViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RefUpdateElement)element).getSrcRefName();
            }
        });
        TableViewerColumn dstViewer = this.createColumn(layout, UIText.PushResultTable_columnDst, 40, 16384);
        dstViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RefUpdateElement)element).getDstRefName();
            }
        });
        if (result == null) {
            this.tablePanel.layout();
            return;
        }
        int i = 0;
        for (URIish uri : result.getURIs()) {
            TableViewerColumn statusViewer = this.createColumn(layout, NLS.bind((String)UIText.PushResultTable_columnStatusRepo, (Object)Integer.toString(++i)), 40, 0x1000000);
            statusViewer.getColumn().setToolTipText(uri.toString());
            statusViewer.setLabelProvider((CellLabelProvider)new UpdateStatusLabelProvider(localDb, uri));
        }
        this.tableViewer.setInput((Object)result);
        this.tablePanel.layout();
    }

    Control getControl() {
        return this.tablePanel;
    }

    private TableViewerColumn createColumn(TableColumnLayout columnLayout, String text, int weight, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(text);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return viewerColumn;
    }

    private class UpdateStatusLabelProvider
    extends ColumnLabelProvider {
        private Repository localDb;
        private final URIish uri;

        UpdateStatusLabelProvider(Repository localDb, URIish uri) {
            this.localDb = localDb;
            this.uri = uri;
        }

        public String getText(Object element) {
            RefUpdateElement rue = (RefUpdateElement)element;
            if (!rue.isSuccessfulConnection(this.uri)) {
                return UIText.PushResultTable_statusConnectionFailed;
            }
            RemoteRefUpdate rru = rue.getRemoteRefUpdate(this.uri);
            switch (rru.getStatus()) {
                case OK: {
                    if (rru.isDelete()) {
                        return UIText.PushResultTable_statusOkDeleted;
                    }
                    Ref oldRef = rue.getAdvertisedRemoteRef(this.uri);
                    if (oldRef == null) {
                        if (rue.getDstRefName().startsWith("refs/tags/")) {
                            return UIText.PushResultTable_statusOkNewTag;
                        }
                        return UIText.PushResultTable_statusOkNewBranch;
                    }
                    return String.valueOf(oldRef.getObjectId().abbreviate(this.localDb).name()) + (rru.isFastForward() ? ".." : "...") + rru.getNewObjectId().abbreviate(this.localDb).name();
                }
                case UP_TO_DATE: {
                    return UIText.PushResultTable_statusUpToDate;
                }
                case NON_EXISTING: {
                    return UIText.PushResultTable_statusNoMatch;
                }
                case REJECTED_NONFASTFORWARD: 
                case REJECTED_NODELETE: 
                case REJECTED_REMOTE_CHANGED: {
                    return UIText.PushResultTable_statusRejected;
                }
                case REJECTED_OTHER_REASON: {
                    return UIText.PushResultTable_statusRemoteRejected;
                }
            }
            throw new IllegalArgumentException(NLS.bind((String)UIText.PushResultTable_statusUnexpected, (Object)rru.getStatus()));
        }

        public Color getBackground(Object element) {
            RefUpdateElement rue = (RefUpdateElement)element;
            if (!rue.isSuccessfulConnection(this.uri)) {
                return PushResultTable.this.colorRegistry.get(PushResultTable.COLOR_REJECTED_KEY);
            }
            RemoteRefUpdate.Status status = rue.getRemoteRefUpdate(this.uri).getStatus();
            switch (status) {
                case OK: {
                    return PushResultTable.this.colorRegistry.get(PushResultTable.COLOR_UPDATED_KEY);
                }
                case UP_TO_DATE: 
                case NON_EXISTING: {
                    return PushResultTable.this.colorRegistry.get(PushResultTable.COLOR_UP_TO_DATE_KEY);
                }
                case REJECTED_NONFASTFORWARD: 
                case REJECTED_NODELETE: 
                case REJECTED_REMOTE_CHANGED: 
                case REJECTED_OTHER_REASON: {
                    return PushResultTable.this.colorRegistry.get(PushResultTable.COLOR_REJECTED_KEY);
                }
            }
            throw new IllegalArgumentException(NLS.bind((String)UIText.PushResultTable_statusUnexpected, (Object)status));
        }

        public String getToolTipText(Object element) {
            RefUpdateElement rue = (RefUpdateElement)element;
            if (!rue.isSuccessfulConnection(this.uri)) {
                return rue.getErrorMessage(this.uri);
            }
            RemoteRefUpdate rru = rue.getRemoteRefUpdate(this.uri);
            Ref oldRef = rue.getAdvertisedRemoteRef(this.uri);
            switch (rru.getStatus()) {
                case OK: {
                    if (rru.isDelete()) {
                        return NLS.bind((String)UIText.PushResultTable_statusDetailDeleted, (Object)oldRef.getObjectId().abbreviate(this.localDb).name());
                    }
                    if (oldRef == null) {
                        return null;
                    }
                    if (rru.isFastForward()) {
                        return UIText.PushResultTable_statusDetailFastForward;
                    }
                    return UIText.PushResultTable_statusDetailForcedUpdate;
                }
                case UP_TO_DATE: {
                    return null;
                }
                case NON_EXISTING: {
                    return UIText.PushResultTable_statusDetailNonExisting;
                }
                case REJECTED_NODELETE: {
                    return UIText.PushResultTable_statusDetailNoDelete;
                }
                case REJECTED_NONFASTFORWARD: {
                    return UIText.PushResultTable_statusDetailNonFastForward;
                }
                case REJECTED_REMOTE_CHANGED: {
                    Ref remoteRef = oldRef;
                    String curVal = remoteRef == null ? UIText.PushResultTable_refNonExisting : remoteRef.getObjectId().abbreviate(this.localDb).name();
                    ObjectId expectedOldObjectId = rru.getExpectedOldObjectId();
                    String expVal = expectedOldObjectId.equals((AnyObjectId)ObjectId.zeroId()) ? UIText.PushResultTable_refNonExisting : expectedOldObjectId.abbreviate(this.localDb).name();
                    return NLS.bind((String)UIText.PushResultTable_statusDetailChanged, (Object)curVal, (Object)expVal);
                }
                case REJECTED_OTHER_REASON: {
                    return rru.getMessage();
                }
            }
            throw new IllegalArgumentException(NLS.bind((String)UIText.PushResultTable_statusUnexpected, (Object)rru.getStatus()));
        }
    }
}

