/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.RefSpecPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.push.ConfirmationPage;
import org.eclipse.egit.ui.internal.push.PushResultDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushWizard
extends Wizard {
    private Repository localDb;
    private final RepositorySelectionPage repoPage;
    private final RefSpecPage refSpecPage;
    private ConfirmationPage confirmPage;

    private static String getURIsString(Collection<URIish> uris) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (URIish uri : uris) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(uri);
        }
        return sb.toString();
    }

    public PushWizard(Repository localDb) throws URISyntaxException {
        this.localDb = localDb;
        List remotes = RemoteConfig.getAllRemoteConfigs((Config)localDb.getConfig());
        this.repoPage = new RepositorySelectionPage(false, remotes);
        this.refSpecPage = new RefSpecPage(localDb, true, this.repoPage);
        this.confirmPage = new ConfirmationPage(localDb, this.repoPage, this.refSpecPage);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.repoPage);
        this.addPage((IWizardPage)this.refSpecPage);
        this.addPage((IWizardPage)this.confirmPage);
    }

    public boolean performFinish() {
        PushOperation operation;
        if (this.repoPage.getSelection().isConfigSelected() && this.refSpecPage.isSaveRequested()) {
            this.saveRefSpecs();
        }
        if ((operation = this.createPushOperation()) == null) {
            return false;
        }
        PushOperationResult resultToCompare = this.confirmPage.isShowOnlyIfChangedSelected() ? this.confirmPage.getConfirmedResult() : null;
        PushJob job = new PushJob(operation, resultToCompare, this.getDestinationString());
        job.setUser(true);
        job.schedule();
        return true;
    }

    public String getWindowTitle() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.repoPage || currentPage == null) {
            return UIText.PushWizard_windowTitleDefault;
        }
        String destination = this.getDestinationString();
        return NLS.bind((String)UIText.PushWizard_windowTitleWithDestination, (Object)destination);
    }

    private void saveRefSpecs() {
        RemoteConfig rc = this.repoPage.getSelection().getConfig();
        rc.setPushRefSpecs(this.refSpecPage.getRefSpecs());
        RepositoryConfig config = this.localDb.getConfig();
        rc.update((Config)config);
        try {
            config.save();
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.PushWizard_cantSaveTitle, (String)UIText.PushWizard_cantSaveMessage, (IStatus)new Status(2, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PushOperation createPushOperation() {
        Collection updates;
        PushOperationSpecification spec;
        RemoteConfig config;
        block5: {
            config = this.repoPage.getSelection().getConfig();
            if (this.confirmPage.isConfirmed()) {
                PushOperationResult confirmedResult = this.confirmPage.getConfirmedResult();
                spec = confirmedResult.deriveSpecification(this.confirmPage.isRequireUnchangedSelected());
                return new PushOperation(this.localDb, spec, false, config);
            }
            List fetchSpecs = config != null ? config.getFetchRefSpecs() : null;
            updates = Transport.findRemoteRefUpdatesFor((Repository)this.localDb, this.refSpecPage.getRefSpecs(), (Collection)fetchSpecs);
            if (!updates.isEmpty()) break block5;
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.PushWizard_missingRefsTitle, null, (IStatus)new Status(4, Activator.getPluginId(), UIText.PushWizard_missingRefsMessage));
            return null;
        }
        try {
            spec = new PushOperationSpecification();
            for (URIish uri : this.repoPage.getSelection().getAllURIs()) {
                spec.addURIRefUpdates(uri, ConfirmationPage.copyUpdates(updates));
            }
            return new PushOperation(this.localDb, spec, false, config);
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.PushWizard_cantPrepareUpdatesTitle, (String)UIText.PushWizard_cantPrepareUpdatesMessage, (IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
            return null;
        }
    }

    private String getDestinationString() {
        RepositorySelection repoSelection = this.repoPage.getSelection();
        String destination = repoSelection.isConfigSelected() ? repoSelection.getConfigName() : repoSelection.getURI().toString();
        return destination;
    }

    private class PushJob
    extends Job {
        private final PushOperation operation;
        private final PushOperationResult resultToCompare;
        private final String destinationString;

        public PushJob(PushOperation operation, PushOperationResult resultToCompare, String destinationString) {
            super(NLS.bind((String)UIText.PushWizard_jobName, (Object)PushWizard.getURIsString(operation.getSpecification().getURIs())));
            this.operation = operation;
            this.resultToCompare = resultToCompare;
            this.destinationString = destinationString;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.operation.run(monitor);
            }
            catch (InvocationTargetException e) {
                return new Status(4, Activator.getPluginId(), UIText.PushWizard_unexpectedError, e.getCause());
            }
            final PushOperationResult result = this.operation.getOperationResult();
            if (!result.isSuccessfulConnectionForAnyURI()) {
                return new Status(4, Activator.getPluginId(), NLS.bind((String)UIText.PushWizard_cantConnectToAny, (Object)result.getErrorStringForAllURis()));
            }
            if (this.resultToCompare == null || !result.equals((Object)this.resultToCompare)) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        PushResultDialog dialog = new PushResultDialog(shell, PushWizard.this.localDb, result, PushJob.this.destinationString);
                        dialog.open();
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

