/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;

class RefUpdateElement {
    private final String srcRefName;
    private final String dstRefName;
    private final PushOperationResult result;

    RefUpdateElement(PushOperationResult result, String srcRef, String dstRef) {
        this.result = result;
        this.srcRefName = srcRef;
        this.dstRefName = dstRef;
    }

    String getSrcRefName() {
        return this.srcRefName;
    }

    String getDstRefName() {
        return this.dstRefName;
    }

    boolean isDelete() {
        return this.srcRefName == null;
    }

    boolean isSuccessfulConnection(URIish uri) {
        return this.result.isSuccessfulConnection(uri);
    }

    String getErrorMessage(URIish uri) {
        return this.result.getErrorMessage(uri);
    }

    RemoteRefUpdate getRemoteRefUpdate(URIish uri) {
        return this.result.getPushResult(uri).getRemoteUpdate(this.dstRefName);
    }

    Ref getAdvertisedRemoteRef(URIish uri) {
        return this.result.getPushResult(uri).getAdvertisedRef(this.dstRefName);
    }
}

