/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.sharing;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.sharing.SharingWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExistingOrNewPage
extends WizardPage {
    private final SharingWizard myWizard;
    private Button button;
    private Tree tree;
    private Text repositoryToCreate;
    private IPath minumumPath;
    private Text dotGitSegment;

    ExistingOrNewPage(SharingWizard w) {
        super(ExistingOrNewPage.class.getName());
        this.setTitle(UIText.ExistingOrNewPage_title);
        this.setDescription(UIText.ExistingOrNewPage_description);
        this.setImageDescriptor(UIIcons.WIZBAN_CONNECT_REPO);
        this.myWizard = w;
    }

    public void createControl(Composite parent) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(3, false));
        g.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tree = new Tree((Composite)g, 67586);
        this.tree.setHeaderVisible(true);
        this.tree.setLayout((Layout)new GridLayout());
        this.tree.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(3, 1).create());
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem ti;
                TreeItem t = (TreeItem)e.item;
                TreeItem[] treeItemArray = t.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ti = treeItemArray[n2];
                    ExistingOrNewPage.this.tree.deselect(ti);
                    ++n2;
                }
                if (t.getParentItem() != null) {
                    ExistingOrNewPage.this.tree.deselect(t.getParentItem());
                    treeItemArray = t.getParentItem().getItems();
                    n = treeItemArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        ti = treeItemArray[n2];
                        if (ti != t) {
                            ExistingOrNewPage.this.tree.deselect(ti);
                        }
                        ++n2;
                    }
                }
                HashSet<IProject> projects = new HashSet<IProject>();
                TreeItem[] treeItemArray2 = ExistingOrNewPage.this.tree.getSelection();
                int n3 = treeItemArray2.length;
                n = 0;
                while (n < n3) {
                    IProject project;
                    TreeItem treeItem = treeItemArray2[n];
                    if (treeItem.getData() == null && treeItem.getParentItem() != null) {
                        treeItem = treeItem.getParentItem();
                    }
                    if (projects.contains(project = (IProject)treeItem.getData())) {
                        ExistingOrNewPage.this.tree.deselect(treeItem);
                    }
                    projects.add(project);
                    ++n;
                }
            }
        });
        TreeColumn c1 = new TreeColumn(this.tree, 0);
        c1.setText(UIText.ExistingOrNewPage_HeaderProject);
        c1.setWidth(100);
        TreeColumn c2 = new TreeColumn(this.tree, 0);
        c2.setText(UIText.ExistingOrNewPage_HeaderPath);
        c2.setWidth(400);
        TreeColumn c3 = new TreeColumn(this.tree, 0);
        c3.setText(UIText.ExistingOrNewPage_HeaderRepository);
        c3.setWidth(200);
        IProject[] iProjectArray = this.myWizard.projects;
        int n = this.myWizard.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            TreeItem treeItem = new TreeItem(this.tree, 0);
            treeItem.setData((Object)project);
            treeItem.setText(0, project.getName());
            treeItem.setText(1, project.getLocation().toOSString());
            RepositoryFinder repositoryFinder = new RepositoryFinder(project);
            try {
                RepositoryMapping m;
                Collection mappings = repositoryFinder.find((IProgressMonitor)new NullProgressMonitor());
                Iterator mi = mappings.iterator();
                RepositoryMapping repositoryMapping = m = mi.hasNext() ? (RepositoryMapping)mi.next() : null;
                if (m == null) {
                    treeItem.setText(2, "");
                } else {
                    this.fillTreeItemWithGitDirectory(m, treeItem, false);
                }
                while (mi.hasNext()) {
                    m = (RepositoryMapping)mi.next();
                    TreeItem treeItem2 = new TreeItem(treeItem, 0);
                    treeItem2.setData((Object)m.getContainer().getProject());
                    this.fillTreeItemWithGitDirectory(m, treeItem2, true);
                }
            }
            catch (CoreException e) {
                TreeItem treeItem2 = new TreeItem(treeItem, 3);
                treeItem2.setText(e.getMessage());
            }
            ++n2;
        }
        this.button = new Button((Composite)g, 8);
        this.button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.button.setText(UIText.ExistingOrNewPage_CreateButton);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File gitDir = new File(ExistingOrNewPage.this.repositoryToCreate.getText(), ".git");
                try {
                    Repository repository = new Repository(gitDir);
                    repository.create();
                    for (IProject project : ExistingOrNewPage.this.getProjects().keySet()) {
                        if (gitDir.toString().contains("..")) continue;
                        project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (IOException e1) {
                    MessageDialog.openError((Shell)ExistingOrNewPage.this.getShell(), (String)UIText.ExistingOrNewPage_ErrorFailedToCreateRepository, (String)(String.valueOf(gitDir.toString()) + ":\n" + e1.getMessage()));
                    Activator.logError((String)("Failed to create repository at " + gitDir), (Throwable)e1);
                }
                catch (CoreException e2) {
                    Activator.logError((String)(String.valueOf(UIText.ExistingOrNewPage_ErrorFailedToRefreshRepository) + gitDir), (Throwable)e2);
                }
                TreeItem[] treeItemArray = ExistingOrNewPage.this.tree.getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    ti.setText(2, gitDir.toString());
                    ++n2;
                }
                ExistingOrNewPage.this.updateCreateOptions();
                ExistingOrNewPage.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.repositoryToCreate = new Text((Composite)g, 2052);
        this.repositoryToCreate.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(1, 1).create());
        this.repositoryToCreate.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (e.text == null) {
                    return;
                }
                IPath fromOSString = Path.fromOSString((String)e.text);
                ExistingOrNewPage.this.button.setEnabled(ExistingOrNewPage.this.minumumPath.matchingFirstSegments(fromOSString) == fromOSString.segmentCount());
            }
        });
        this.dotGitSegment = new Text((Composite)g, 0);
        this.dotGitSegment.setEnabled(false);
        this.dotGitSegment.setEditable(false);
        this.dotGitSegment.setText(String.valueOf(File.separatorChar) + ".git");
        this.dotGitSegment.setLayoutData((Object)GridDataFactory.fillDefaults().align(16384, 0x1000000).create());
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExistingOrNewPage.this.updateCreateOptions();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateCreateOptions();
        this.setControl((Control)g);
    }

    private void fillTreeItemWithGitDirectory(RepositoryMapping m, TreeItem treeItem2, boolean isAlternative) {
        if (m.getGitDir() == null) {
            treeItem2.setText(2, UIText.ExistingOrNewPage_SymbolicValueEmptyMapping);
        } else {
            IPath container = m.getContainerPath();
            if (!container.isEmpty()) {
                container = container.addTrailingSeparator();
            }
            IPath relativePath = container.append(m.getGitDir());
            if (isAlternative) {
                treeItem2.setText(0, relativePath.removeLastSegments(1).addTrailingSeparator().toString());
            }
            treeItem2.setText(2, relativePath.toString());
        }
    }

    private void updateCreateOptions() {
        this.minumumPath = null;
        IPath p = null;
        TreeItem[] treeItemArray = this.tree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            String path = ti.getText(2);
            if (!path.equals("")) {
                p = null;
                break;
            }
            String gitDirParentCandidate = ti.getText(1);
            IPath thisPath = Path.fromOSString((String)gitDirParentCandidate);
            if (p == null) {
                p = thisPath;
            } else {
                int n3 = p.matchingFirstSegments(thisPath);
                p = p.removeLastSegments(p.segmentCount() - n3);
            }
            ++n2;
        }
        this.minumumPath = p;
        if (p != null) {
            this.repositoryToCreate.setText(p.toOSString());
        } else {
            this.repositoryToCreate.setText("");
        }
        this.button.setEnabled(p != null);
        this.repositoryToCreate.setEnabled(p != null);
        this.dotGitSegment.setEnabled(p != null);
        this.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        if (this.tree.getSelectionCount() == 0) {
            return false;
        }
        TreeItem[] treeItemArray = this.tree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            String path = ti.getText(2);
            if (path.equals("")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Map<IProject, File> getProjects() {
        TreeItem[] selection = this.tree.getSelection();
        HashMap<IProject, File> ret = new HashMap<IProject, File>(selection.length);
        int i = 0;
        while (i < selection.length) {
            IPath selectedRepo;
            TreeItem treeItem = selection[i];
            while (treeItem.getData() == null && treeItem.getParentItem() != null) {
                treeItem = treeItem.getParentItem();
            }
            IProject project = (IProject)treeItem.getData();
            IPath localPathToRepo = selectedRepo = Path.fromOSString((String)treeItem.getText(2));
            if (!selectedRepo.isAbsolute()) {
                localPathToRepo = project.getLocation().append(selectedRepo);
            }
            ret.put(project, localPathToRepo.toFile());
            ++i;
        }
        return ret;
    }
}

