/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.patch.FileHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffFormatter {
    private static final byte[] noNewLine = Constants.encodeASCII("\\ No newline at end of file\n");
    private int context;

    public DiffFormatter() {
        this.setContext(3);
    }

    public void setContext(int lineCount) {
        if (lineCount < 0) {
            throw new IllegalArgumentException("context must be >= 0");
        }
        this.context = lineCount;
    }

    public void format(OutputStream out, FileHeader head, RawText a, RawText b) throws IOException {
        int start = head.getStartOffset();
        int end = head.getEndOffset();
        if (!head.getHunks().isEmpty()) {
            end = head.getHunks().get(0).getStartOffset();
        }
        out.write(head.getBuffer(), start, end - start);
        this.formatEdits(out, a, b, head.toEditList());
    }

    public void formatEdits(OutputStream out, RawText a, RawText b, EditList edits) throws IOException {
        int curIdx = 0;
        while (curIdx < edits.size()) {
            Edit curEdit = edits.get(curIdx);
            int endIdx = this.findCombinedEnd(edits, curIdx);
            Edit endEdit = edits.get(endIdx);
            int aCur = Math.max(0, curEdit.getBeginA() - this.context);
            int bCur = Math.max(0, curEdit.getBeginB() - this.context);
            int aEnd = Math.min(a.size(), endEdit.getEndA() + this.context);
            int bEnd = Math.min(b.size(), endEdit.getEndB() + this.context);
            this.writeHunkHeader(out, aCur, aEnd, bCur, bEnd);
            while (aCur < aEnd || bCur < bEnd) {
                if (aCur < curEdit.getBeginA() || endIdx + 1 < curIdx) {
                    DiffFormatter.writeLine(out, ' ', a, aCur);
                    ++aCur;
                    ++bCur;
                } else if (aCur < curEdit.getEndA()) {
                    DiffFormatter.writeLine(out, '-', a, aCur++);
                } else if (bCur < curEdit.getEndB()) {
                    DiffFormatter.writeLine(out, '+', b, bCur++);
                }
                if (!DiffFormatter.end(curEdit, aCur, bCur) || ++curIdx >= edits.size()) continue;
                curEdit = edits.get(curIdx);
            }
        }
    }

    private void writeHunkHeader(OutputStream out, int aCur, int aEnd, int bCur, int bEnd) throws IOException {
        out.write(64);
        out.write(64);
        DiffFormatter.writeRange(out, '-', aCur + 1, aEnd - aCur);
        DiffFormatter.writeRange(out, '+', bCur + 1, bEnd - bCur);
        out.write(32);
        out.write(64);
        out.write(64);
        out.write(10);
    }

    private static void writeRange(OutputStream out, char prefix, int begin, int cnt) throws IOException {
        out.write(32);
        out.write(prefix);
        switch (cnt) {
            case 0: {
                out.write(Constants.encodeASCII(begin - 1));
                out.write(44);
                out.write(48);
                break;
            }
            case 1: {
                out.write(Constants.encodeASCII(begin));
                break;
            }
            default: {
                out.write(Constants.encodeASCII(begin));
                out.write(44);
                out.write(Constants.encodeASCII(cnt));
            }
        }
    }

    private static void writeLine(OutputStream out, char prefix, RawText text, int cur) throws IOException {
        out.write(prefix);
        text.writeLine(out, cur);
        out.write(10);
        if (cur + 1 == text.size() && text.isMissingNewlineAtEnd()) {
            out.write(noNewLine);
        }
    }

    private int findCombinedEnd(List<Edit> edits, int i) {
        int end;
        for (end = i + 1; end < edits.size() && (this.combineA(edits, end) || this.combineB(edits, end)); ++end) {
        }
        return end - 1;
    }

    private boolean combineA(List<Edit> e, int i) {
        return e.get(i).getBeginA() - e.get(i - 1).getEndA() <= 2 * this.context;
    }

    private boolean combineB(List<Edit> e, int i) {
        return e.get(i).getBeginB() - e.get(i - 1).getEndB() <= 2 * this.context;
    }

    private static boolean end(Edit edit, int a, int b) {
        return edit.getEndA() <= a && edit.getEndB() <= b;
    }
}

