/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Constants;

public class DirCacheEditor
extends BaseDirCacheEditor {
    private static final Comparator<PathEdit> EDIT_CMP = new Comparator<PathEdit>(){

        @Override
        public int compare(PathEdit o1, PathEdit o2) {
            byte[] a = o1.path;
            byte[] b = o2.path;
            return DirCache.cmp(a, a.length, b, b.length);
        }
    };
    private final List<PathEdit> edits = new ArrayList<PathEdit>();

    protected DirCacheEditor(DirCache dc, int ecnt) {
        super(dc, ecnt);
    }

    public void add(PathEdit edit) {
        this.edits.add(edit);
    }

    public boolean commit() throws IOException {
        if (this.edits.isEmpty()) {
            this.cache.unlock();
            return true;
        }
        return super.commit();
    }

    public void finish() {
        if (!this.edits.isEmpty()) {
            this.applyEdits();
            this.replace();
        }
    }

    private void applyEdits() {
        Collections.sort(this.edits, EDIT_CMP);
        int maxIdx = this.cache.getEntryCount();
        int lastIdx = 0;
        for (PathEdit e : this.edits) {
            DirCacheEntry ent;
            int cnt;
            boolean missing;
            int eIdx = this.cache.findEntry(e.path, e.path.length);
            boolean bl = missing = eIdx < 0;
            if (eIdx < 0) {
                eIdx = -(eIdx + 1);
            }
            if ((cnt = Math.min(eIdx, maxIdx) - lastIdx) > 0) {
                this.fastKeep(lastIdx, cnt);
            }
            int n = lastIdx = missing ? eIdx : this.cache.nextEntry(eIdx);
            if (e instanceof DeletePath) continue;
            if (e instanceof DeleteTree) {
                lastIdx = this.cache.nextEntry(e.path, e.path.length, eIdx);
                continue;
            }
            if (missing) {
                ent = new DirCacheEntry(e.path);
                e.apply(ent);
                if (ent.getRawMode() == 0) {
                    throw new IllegalArgumentException("FileMode not set for path " + ent.getPathString());
                }
            } else {
                ent = this.cache.getEntry(eIdx);
                e.apply(ent);
            }
            this.fastAdd(ent);
        }
        int cnt = maxIdx - lastIdx;
        if (cnt > 0) {
            this.fastKeep(lastIdx, cnt);
        }
    }

    public static final class DeleteTree
    extends PathEdit {
        public DeleteTree(String entryPath) {
            super(entryPath.endsWith("/") ? entryPath : entryPath + "/");
        }

        public void apply(DirCacheEntry ent) {
            throw new UnsupportedOperationException("No apply in delete");
        }
    }

    public static final class DeletePath
    extends PathEdit {
        public DeletePath(String entryPath) {
            super(entryPath);
        }

        public DeletePath(DirCacheEntry ent) {
            super(ent);
        }

        public void apply(DirCacheEntry ent) {
            throw new UnsupportedOperationException("No apply in delete");
        }
    }

    public static abstract class PathEdit {
        final byte[] path;

        public PathEdit(String entryPath) {
            this.path = Constants.encode(entryPath);
        }

        public PathEdit(DirCacheEntry ent) {
            this.path = ent.path;
        }

        public abstract void apply(DirCacheEntry var1);
    }
}

