/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.RawParseUtils;

public class BlobBasedConfig
extends Config {
    public BlobBasedConfig(Config base, byte[] blob) throws ConfigInvalidException {
        super(base);
        this.fromText(RawParseUtils.decode(blob));
    }

    public BlobBasedConfig(Config base, Repository r, ObjectId objectId) throws IOException, ConfigInvalidException {
        super(base);
        ObjectLoader loader = r.openBlob(objectId);
        if (loader == null) {
            throw new IOException("Blob not found: " + objectId);
        }
        this.fromText(RawParseUtils.decode(loader.getBytes()));
    }

    public BlobBasedConfig(Config base, Commit commit, String path) throws FileNotFoundException, IOException, ConfigInvalidException {
        super(base);
        ObjectId treeId = commit.getTreeId();
        Repository r = commit.getRepository();
        TreeWalk tree = TreeWalk.forPath(r, path, treeId);
        if (tree == null) {
            throw new FileNotFoundException("Entry not found by path: " + path);
        }
        ObjectId blobId = tree.getObjectId(0);
        ObjectLoader loader = tree.getRepository().openBlob(blobId);
        if (loader == null) {
            throw new IOException("Blob not found: " + blobId + " for path: " + path);
        }
        this.fromText(RawParseUtils.decode(loader.getBytes()));
    }
}

