/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CachedObjectDatabase;
import org.eclipse.jgit.lib.ObjectDirectory;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.WindowCursor;

public class CachedObjectDirectory
extends CachedObjectDatabase {
    private final ObjectIdSubclassMap<ObjectId> unpackedObjects = new ObjectIdSubclassMap();

    public CachedObjectDirectory(ObjectDirectory wrapped) {
        super(wrapped);
        File objects = wrapped.getDirectory();
        String[] fanout = objects.list();
        if (fanout == null) {
            fanout = new String[]{};
        }
        for (String d : fanout) {
            String[] entries;
            if (d.length() != 2 || (entries = new File(objects, d).list()) == null) continue;
            for (String e : entries) {
                if (e.length() != 38) continue;
                try {
                    this.unpackedObjects.add(ObjectId.fromString(d + e));
                }
                catch (IllegalArgumentException notAnObject) {
                    // empty catch block
                }
            }
        }
    }

    protected ObjectLoader openObject2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        if (this.unpackedObjects.get(objectId) == null) {
            return null;
        }
        return super.openObject2(curs, objectName, objectId);
    }

    protected boolean hasObject1(AnyObjectId objectId) {
        if (this.unpackedObjects.get(objectId) != null) {
            return true;
        }
        return super.hasObject1(objectId);
    }

    protected boolean hasObject2(String name) {
        return false;
    }
}

