/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.zip.DataFormatException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.BinaryDelta;
import org.eclipse.jgit.lib.PackFile;
import org.eclipse.jgit.lib.PackedObjectLoader;
import org.eclipse.jgit.lib.UnpackedObjectCache;
import org.eclipse.jgit.lib.WindowCursor;

abstract class DeltaPackedObjectLoader
extends PackedObjectLoader {
    private static final int OBJ_COMMIT = 1;
    private final int deltaSize;

    DeltaPackedObjectLoader(PackFile pr, long dataOffset, long objectOffset, int deltaSz) {
        super(pr, dataOffset, objectOffset);
        this.objectType = -1;
        this.deltaSize = deltaSz;
    }

    public void materialize(WindowCursor curs) throws IOException {
        UnpackedObjectCache.Entry cache;
        if (this.cachedBytes != null) {
            return;
        }
        if (this.objectType != 1 && (cache = this.pack.readCache(this.dataOffset)) != null) {
            curs.release();
            this.objectType = cache.type;
            this.objectSize = cache.data.length;
            this.cachedBytes = cache.data;
            return;
        }
        try {
            PackedObjectLoader baseLoader = this.getBaseLoader(curs);
            baseLoader.materialize(curs);
            this.cachedBytes = BinaryDelta.apply(baseLoader.getCachedBytes(), this.pack.decompress(this.dataOffset, this.deltaSize, curs));
            curs.release();
            this.objectType = baseLoader.getType();
            this.objectSize = this.cachedBytes.length;
            if (this.objectType != 1) {
                this.pack.saveCache(this.dataOffset, this.cachedBytes, this.objectType);
            }
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException("Object at " + this.dataOffset + " in " + this.pack.getPackFile() + " has bad zlib stream");
            coe.initCause(dfe);
            throw coe;
        }
    }

    public long getRawSize() {
        return this.deltaSize;
    }

    protected abstract PackedObjectLoader getBaseLoader(WindowCursor var1) throws IOException;
}

