/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.jgit.lib.AbstractIndexTreeVisitor;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.IndexTreeWalker;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDiff {
    private GitIndex index;
    private Tree tree;
    boolean anyChanges = false;
    HashSet<String> added = new HashSet();
    HashSet<String> changed = new HashSet();
    HashSet<String> removed = new HashSet();
    HashSet<String> missing = new HashSet();
    HashSet<String> modified = new HashSet();

    public IndexDiff(Repository repository) throws IOException {
        this.tree = repository.mapTree("HEAD");
        this.index = repository.getIndex();
    }

    public IndexDiff(Tree tree, GitIndex index) {
        this.tree = tree;
        this.index = index;
    }

    public boolean diff() throws IOException {
        final File root = this.index.getRepository().getWorkDir();
        new IndexTreeWalker(this.index, this.tree, root, new AbstractIndexTreeVisitor(){

            public void visitEntry(TreeEntry treeEntry, GitIndex.Entry indexEntry, File file) {
                if (treeEntry == null) {
                    IndexDiff.this.added.add(indexEntry.getName());
                    IndexDiff.this.anyChanges = true;
                } else if (indexEntry == null) {
                    if (!(treeEntry instanceof Tree)) {
                        IndexDiff.this.removed.add(treeEntry.getFullName());
                    }
                    IndexDiff.this.anyChanges = true;
                } else if (!treeEntry.getId().equals(indexEntry.getObjectId())) {
                    IndexDiff.this.changed.add(indexEntry.getName());
                    IndexDiff.this.anyChanges = true;
                }
                if (indexEntry != null) {
                    if (!file.exists()) {
                        IndexDiff.this.missing.add(indexEntry.getName());
                        IndexDiff.this.anyChanges = true;
                    } else if (indexEntry.isModified(root, true)) {
                        IndexDiff.this.modified.add(indexEntry.getName());
                        IndexDiff.this.anyChanges = true;
                    }
                }
            }
        }).walk();
        return this.anyChanges;
    }

    public HashSet<String> getAdded() {
        return this.added;
    }

    public HashSet<String> getChanged() {
        return this.changed;
    }

    public HashSet<String> getRemoved() {
        return this.removed;
    }

    public HashSet<String> getMissing() {
        return this.missing;
    }

    public HashSet<String> getModified() {
        return this.modified;
    }
}

