/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.IndexTreeVisitor;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.jgit.lib.TreeIterator;

public class IndexTreeWalker {
    private final Tree mainTree;
    private final Tree newTree;
    private final File root;
    private final IndexTreeVisitor visitor;
    private boolean threeTrees;
    GitIndex.Entry[] indexMembers;
    int indexCounter = 0;

    public IndexTreeWalker(GitIndex index, Tree tree, File root, IndexTreeVisitor visitor) {
        this.mainTree = tree;
        this.root = root;
        this.visitor = visitor;
        this.newTree = null;
        this.threeTrees = false;
        this.indexMembers = index.getMembers();
    }

    public IndexTreeWalker(GitIndex index, Tree mainTree, Tree newTree, File root, IndexTreeVisitor visitor) {
        this.mainTree = mainTree;
        this.newTree = newTree;
        this.root = root;
        this.visitor = visitor;
        this.threeTrees = true;
        this.indexMembers = index.getMembers();
    }

    public void walk() throws IOException {
        this.walk(this.mainTree, this.newTree);
    }

    private void walk(Tree tree, Tree auxTree) throws IOException {
        GitIndex.Entry i;
        TreeIterator mi = new TreeIterator(tree, TreeIterator.Order.POSTORDER);
        TreeIterator ai = new TreeIterator(auxTree, TreeIterator.Order.POSTORDER);
        TreeEntry m = mi.hasNext() ? mi.next() : null;
        TreeEntry a = ai.hasNext() ? ai.next() : null;
        int curIndexPos = this.indexCounter;
        GitIndex.Entry entry = i = this.indexCounter < this.indexMembers.length ? this.indexMembers[this.indexCounter++] : null;
        while (m != null || a != null || i != null) {
            GitIndex.Entry pi;
            int cmpma = IndexTreeWalker.compare(m, a);
            int cmpmi = IndexTreeWalker.compare(m, i);
            int cmpai = IndexTreeWalker.compare(a, i);
            TreeEntry pm = cmpma <= 0 && cmpmi <= 0 ? m : null;
            TreeEntry pa = cmpma >= 0 && cmpai <= 0 ? a : null;
            GitIndex.Entry entry2 = pi = cmpmi >= 0 && cmpai >= 0 ? i : null;
            if (pi != null) {
                this.visitEntry(pm, pa, pi);
            } else {
                this.finishVisitTree(pm, pa, curIndexPos);
            }
            if (pm != null) {
                TreeEntry treeEntry = m = mi.hasNext() ? mi.next() : null;
            }
            if (pa != null) {
                TreeEntry treeEntry = a = ai.hasNext() ? ai.next() : null;
            }
            if (pi == null) continue;
            i = this.indexCounter < this.indexMembers.length ? this.indexMembers[this.indexCounter++] : null;
        }
    }

    private void visitEntry(TreeEntry t1, TreeEntry t2, GitIndex.Entry i) throws IOException {
        assert (t1 != null || t2 != null || i != null) : "Needs at least one entry";
        assert (this.root != null) : "Needs workdir";
        if (t1 != null && t1.getParent() == null) {
            t1 = null;
        }
        if (t2 != null && t2.getParent() == null) {
            t2 = null;
        }
        File f = null;
        if (i != null) {
            f = new File(this.root, i.getName());
        } else if (t1 != null) {
            f = new File(this.root, t1.getFullName());
        } else if (t2 != null) {
            f = new File(this.root, t2.getFullName());
        }
        if (t1 != null || t2 != null || i != null) {
            if (this.threeTrees) {
                this.visitor.visitEntry(t1, t2, i, f);
            } else {
                this.visitor.visitEntry(t1, i, f);
            }
        }
    }

    private void finishVisitTree(TreeEntry t1, TreeEntry t2, int curIndexPos) throws IOException {
        assert (t1 != null || t2 != null) : "Needs at least one entry";
        assert (this.root != null) : "Needs workdir";
        if (t1 != null && t1.getParent() == null) {
            t1 = null;
        }
        if (t2 != null && t2.getParent() == null) {
            t2 = null;
        }
        File f = null;
        String c = null;
        if (t1 != null) {
            c = t1.getFullName();
            f = new File(this.root, c);
        } else if (t2 != null) {
            c = t2.getFullName();
            f = new File(this.root, c);
        }
        if (t1 instanceof Tree || t2 instanceof Tree) {
            if (this.threeTrees) {
                this.visitor.finishVisitTree((Tree)t1, (Tree)t2, c);
            } else {
                this.visitor.finishVisitTree((Tree)t1, this.indexCounter - curIndexPos, c);
            }
        } else if (t1 != null || t2 != null) {
            if (this.threeTrees) {
                this.visitor.visitEntry(t1, t2, null, f);
            } else {
                this.visitor.visitEntry(t1, null, f);
            }
        }
    }

    static boolean lt(TreeEntry h, GitIndex.Entry i) {
        return IndexTreeWalker.compare(h, i) < 0;
    }

    static boolean lt(GitIndex.Entry i, TreeEntry t) {
        return IndexTreeWalker.compare(t, i) > 0;
    }

    static boolean lt(TreeEntry h, TreeEntry m) {
        return IndexTreeWalker.compare(h, m) < 0;
    }

    static boolean eq(TreeEntry t1, TreeEntry t2) {
        return IndexTreeWalker.compare(t1, t2) == 0;
    }

    static boolean eq(TreeEntry t1, GitIndex.Entry e) {
        return IndexTreeWalker.compare(t1, e) == 0;
    }

    static int compare(TreeEntry t, GitIndex.Entry i) {
        if (t == null && i == null) {
            return 0;
        }
        if (t == null) {
            return 1;
        }
        if (i == null) {
            return -1;
        }
        return Tree.compareNames(t.getFullNameUTF8(), i.getNameUTF8(), TreeEntry.lastChar(t), TreeEntry.lastChar(i));
    }

    static int compare(TreeEntry t1, TreeEntry t2) {
        if (t1 != null && t1.getParent() == null && t2 != null && t2.getParent() == null) {
            return 0;
        }
        if (t1 != null && t1.getParent() == null) {
            return -1;
        }
        if (t2 != null && t2.getParent() == null) {
            return 1;
        }
        if (t1 == null && t2 == null) {
            return 0;
        }
        if (t1 == null) {
            return 1;
        }
        if (t2 == null) {
            return -1;
        }
        return Tree.compareNames(t1.getFullNameUTF8(), t2.getFullNameUTF8(), TreeEntry.lastChar(t1), TreeEntry.lastChar(t2));
    }
}

