/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public class MutableObjectId
extends AnyObjectId {
    public MutableObjectId() {
    }

    MutableObjectId(MutableObjectId src) {
        this.w1 = src.w1;
        this.w2 = src.w2;
        this.w3 = src.w3;
        this.w4 = src.w4;
        this.w5 = src.w5;
    }

    public void clear() {
        this.w1 = 0;
        this.w2 = 0;
        this.w3 = 0;
        this.w4 = 0;
        this.w5 = 0;
    }

    public void fromRaw(byte[] bs) {
        this.fromRaw(bs, 0);
    }

    public void fromRaw(byte[] bs, int p) {
        this.w1 = NB.decodeInt32(bs, p);
        this.w2 = NB.decodeInt32(bs, p + 4);
        this.w3 = NB.decodeInt32(bs, p + 8);
        this.w4 = NB.decodeInt32(bs, p + 12);
        this.w5 = NB.decodeInt32(bs, p + 16);
    }

    public void fromRaw(int[] ints) {
        this.fromRaw(ints, 0);
    }

    public void fromRaw(int[] ints, int p) {
        this.w1 = ints[p];
        this.w2 = ints[p + 1];
        this.w3 = ints[p + 2];
        this.w4 = ints[p + 3];
        this.w5 = ints[p + 4];
    }

    public void fromString(byte[] buf, int offset) {
        this.fromHexString(buf, offset);
    }

    public void fromString(String str) {
        if (str.length() != 40) {
            throw new IllegalArgumentException("Invalid id: " + str);
        }
        this.fromHexString(Constants.encodeASCII(str), 0);
    }

    private void fromHexString(byte[] bs, int p) {
        try {
            this.w1 = RawParseUtils.parseHexInt32(bs, p);
            this.w2 = RawParseUtils.parseHexInt32(bs, p + 8);
            this.w3 = RawParseUtils.parseHexInt32(bs, p + 16);
            this.w4 = RawParseUtils.parseHexInt32(bs, p + 24);
            this.w5 = RawParseUtils.parseHexInt32(bs, p + 32);
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new InvalidObjectIdException(bs, p, 40);
        }
    }

    public ObjectId toObjectId() {
        return new ObjectId(this);
    }
}

